/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.helpers;

import android.annotation.SuppressLint;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.text.Html;
import android.util.Log;
import android.widget.RemoteViews;
import tk.jamun.volley.R;
import tk.jamun.volley.helpers.CheckOs;

public class HelperNotification {
    private static final String TAG = HelperNotification.class.getSimpleName();
    private Context context;
    private int colorCode = R.color.libraryColorPrimary;
    private int smallIcon = R.drawable.icon_notification;
    private int largeIcon = R.drawable.icon_notification;
    private int notificationLayout = R.layout.library_notification_view_progress;
    private String ticker = "";
    private int visibility = 1;
    private int priority = 2;
    private NotificationManager mNotifyManager;
    private NotificationCompat.Builder mBuilder;
    private RemoteViews notificationView;
    private int titleId = R.id.id_text_title;
    private int descriptionId = R.id.id_text_title;
    private int detailsId = R.id.id_text_title;
    private int progressbarId = R.id.id_progress_bar;
    private int speedId = R.id.id_text_title;
    private int iconId = R.id.id_image_notification;

    public HelperNotification(Context context) {
        this.context = context;
        this.mNotifyManager = (NotificationManager)context.getSystemService("notification");
    }

    public HelperNotification(Context context, int colorCode, int smallIcon, int largeIcon) {
        this.context = context;
        this.colorCode = colorCode;
        this.smallIcon = smallIcon;
        this.largeIcon = largeIcon;
        this.mNotifyManager = (NotificationManager)context.getSystemService("notification");
    }

    public void showInfiniteProgress(final int notificationId, String title, String description, Intent intent, String channelId) {
        this.mBuilder = new NotificationCompat.Builder(this.context.getApplicationContext(), channelId);
        this.mBuilder.setContentTitle((CharSequence)title).setContentText((CharSequence)description);
        this.mBuilder.setColor(this.context.getResources().getColor(this.colorCode));
        this.mBuilder.setSmallIcon(this.smallIcon);
        this.mBuilder.setChannelId(channelId);
        this.setIntent(intent, this.mBuilder);
        new Thread(new Runnable(){

            @Override
            public void run() {
                HelperNotification.this.mBuilder.setProgress(0, 0, true);
                HelperNotification.this.mNotifyManager.notify(notificationId, HelperNotification.this.mBuilder.build());
            }
        }).start();
    }

    public void createProgressView(int notificationId, String title, String description, Intent intent, String channelId) {
        if (CheckOs.checkForJellyBean()) {
            this.mBuilder = new NotificationCompat.Builder(this.context.getApplicationContext(), channelId).setAutoCancel(false);
            this.setIntent(intent, this.mBuilder);
            this.mBuilder.setContent(this.getCustomNotificationView(title, description));
            this.finalizeNotification(channelId, this.mBuilder, notificationId);
        } else {
            this.showInfiniteProgress(notificationId, title, description, intent, channelId);
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    public void updateProgressView(int notificationId, double progress, double speed, double fileSize) {
        try {
            if (this.notificationView != null) {
                this.notificationView.setViewVisibility(this.progressbarId, 0);
                if (this.speedId != 0) {
                    this.notificationView.setViewVisibility(this.speedId, 0);
                }
                this.notificationView.setViewVisibility(this.descriptionId, 8);
                this.notificationView.setProgressBar(this.progressbarId, (int)fileSize, (int)progress, false);
                if (this.speedId != 0 && this.detailsId != 0) {
                    String downloadType = " Kbps";
                    String type = " Kbps";
                    if (progress >= 1024.0) {
                        progress /= 1024.0;
                        downloadType = " Mb";
                    }
                    if (fileSize >= 1024.0) {
                        fileSize /= 1024.0;
                        type = " Mb";
                    }
                    this.notificationView.setTextViewText(this.detailsId, (CharSequence)(String.format("%.2f", progress) + downloadType + "/" + String.format("%.2f", fileSize) + type));
                    type = " Kbps";
                    if (speed >= 1024.0) {
                        speed /= 1024.0;
                        type = " Mb";
                    }
                    if (this.speedId != 0) {
                        this.notificationView.setTextViewText(this.speedId, (CharSequence)(String.format("%.2f", speed) + type));
                    }
                }
                this.mBuilder.setContent(this.notificationView);
                this.mNotifyManager.notify(notificationId, this.mBuilder.build());
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(e.getMessage() + " "));
        }
    }

    public void showImageNotification(String channelId, Intent intent, Bitmap bitmap, String title, String description, int notificationId) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, channelId);
        this.setIntent(intent, builder);
        NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
        if (title != null) {
            bigPictureStyle.setBigContentTitle((CharSequence)title);
        }
        if (description != null) {
            bigPictureStyle.setSummaryText((CharSequence)Html.fromHtml((String)description).toString());
        }
        bigPictureStyle.bigPicture(bitmap);
        builder.setAutoCancel(true).setStyle((NotificationCompat.Style)bigPictureStyle).setPriority(2);
        this.finalizeNotification(channelId, builder, notificationId);
    }

    public void createNotification(String title, String description, String channelId, int notificationId) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, channelId);
        builder.setContentTitle((CharSequence)title).setContentText((CharSequence)description).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)description));
        this.finalizeNotification(channelId, builder, notificationId);
    }

    private RemoteViews getCustomNotificationView(String title, String description) {
        try {
            this.notificationView = new RemoteViews(this.context.getPackageName(), this.notificationLayout);
            this.notificationView.setImageViewResource(this.iconId, this.largeIcon);
            this.setDescription(description);
            this.notificationView.setViewVisibility(this.progressbarId, 0);
            this.notificationView.setProgressBar(this.progressbarId, 0, 0, true);
            this.notificationView.setTextViewText(this.titleId, (CharSequence)title);
        }
        catch (Exception e) {
            Log.e((String)HelperNotification.class.getSimpleName(), (String)(e.getMessage() + " "));
        }
        return this.notificationView;
    }

    private void setDescription(String message) {
        try {
            this.notificationView.setViewVisibility(this.progressbarId, 8);
            if (this.speedId != 0) {
                this.notificationView.setViewVisibility(this.speedId, 8);
            }
            if (this.detailsId != 0) {
                this.notificationView.setViewVisibility(this.detailsId, 8);
            }
            this.notificationView.setViewVisibility(this.descriptionId, 0);
            this.notificationView.setTextViewText(this.descriptionId, (CharSequence)message);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(e.getMessage() + " "));
        }
    }

    private void finalizeNotification(String channelId, NotificationCompat.Builder builder, int tag) {
        try {
            if (this.mNotifyManager != null && builder != null) {
                builder.setAutoCancel(true).setTicker((CharSequence)this.ticker).setLargeIcon(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.largeIcon)).setVisibility(this.visibility).setSmallIcon(this.smallIcon).setDefaults(3).setColor(this.context.getResources().getColor(this.colorCode)).setPriority(this.priority).setChannelId(channelId);
                this.mNotifyManager.notify(tag, builder.build());
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.getMessage());
        }
    }

    public void removeNotification(int notificationId) {
        if (this.mNotifyManager != null) {
            this.mNotifyManager.cancel(notificationId);
        }
    }

    public void finishNotification(int notificationId, String message, Intent intent) {
        this.mBuilder.setAutoCancel(true);
        this.setIntent(intent, this.mBuilder);
        if (CheckOs.checkForJellyBean() && this.notificationView != null) {
            this.setDescription(message);
            this.mBuilder.setContent(this.notificationView);
            this.mNotifyManager.notify(notificationId, this.mBuilder.build());
        } else {
            this.mBuilder.setContentText((CharSequence)message).setProgress(0, 0, false);
            this.mNotifyManager.notify(notificationId, this.mBuilder.build());
        }
    }

    public void setNotificationLayout(int notificationLayout, int titleId, int descriptionId, int progressbarId, int detailsId, int speedId, int iconId) {
        this.notificationLayout = notificationLayout;
        this.titleId = titleId;
        this.descriptionId = descriptionId;
        this.progressbarId = progressbarId;
        this.detailsId = detailsId;
        this.speedId = speedId;
        this.iconId = iconId;
    }

    public void setTicker(String ticker) {
        this.ticker = ticker;
    }

    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    private void setIntent(Intent intent, NotificationCompat.Builder mBuilder) {
        if (intent != null) {
            intent.setFlags(0x10000000);
            TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)this.context);
            taskStackBuilder.addNextIntent(intent);
            PendingIntent pendingIntentWithTask = taskStackBuilder.getPendingIntent(0, 0x8000000);
            mBuilder.setContentIntent(pendingIntentWithTask);
        }
    }
}

