/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.android.volley.Response;
import com.android.volley.toolbox.RequestFuture;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import tk.jamun.volley.classes.VolleyMultipartRequest;
import tk.jamun.volley.classes.VolleyStringRequest;
import tk.jamun.volley.helpers.VolleyCancel;
import tk.jamun.volley.helpers.VolleyErrorExceptions;
import tk.jamun.volley.helpers.VolleyHelper;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.model.ModelByPart;

public class VolleyBackgroundServices {
    private static VolleyBackgroundServices volleyBackgroundServices;
    private VolleyMultipartRequest multipartRequest;
    private VolleyStringRequest volleyStringRequest;

    public static VolleyBackgroundServices getInstance() {
        if (volleyBackgroundServices == null) {
            volleyBackgroundServices = new VolleyBackgroundServices();
        }
        return volleyBackgroundServices;
    }

    public String volleyToSendData(String url, String payload, VolleyResponse.ErrorListener errorListener) {
        return this.volleyToGetPostData(1, url, payload, errorListener);
    }

    public String volleyToGetPostData(int method, String url, String payload, VolleyResponse.ErrorListener errorListener) {
        String response;
        RequestFuture requestFuture = RequestFuture.newFuture();
        this.volleyStringRequest = new VolleyStringRequest(method, url, payload, (Response.Listener<String>)requestFuture, (Response.ErrorListener)requestFuture);
        VolleyNeeds.getInstance().setVolleyExtraCalls(this.volleyStringRequest);
        try {
            response = (String)requestFuture.get((long)VolleyValues.getInstance().getDefaultRequestTimeMax(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (errorListener != null) {
                errorListener.onErrorResponse(VolleyErrorExceptions.getInstance().getVolleyErrorStatusCode(e), VolleyErrorExceptions.getInstance().getVolleyErrorMessage(e));
            }
            return null;
        }
        return response;
    }

    public String volleyToGetData(String url, VolleyResponse.ErrorListener errorListener) {
        return this.volleyToGetPostData(0, url, null, errorListener);
    }

    public String volleyToSendFile(final File file, String url, final String tagName, VolleyResponse.ErrorListener errorListener) {
        String response;
        RequestFuture requestFuture = RequestFuture.newFuture();
        this.multipartRequest = new VolleyMultipartRequest(1, url, (Response.Listener)requestFuture, (Response.ErrorListener)requestFuture){

            @Override
            protected Map<String, ModelByPart> getByteData() {
                HashMap<String, ModelByPart> params = new HashMap<String, ModelByPart>();
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
                String fileName = file.getName();
                params.put(tagName, new ModelByPart(fileName, VolleyHelper.getFileDataFromBitmap(bitmap), "image/" + fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()));
                return params;
            }
        };
        VolleyNeeds.getInstance().setVolleyExtraCalls(this.multipartRequest);
        try {
            response = (String)requestFuture.get((long)VolleyValues.getInstance().getDefaultRequestTimeForUploadingFileMax(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (errorListener != null) {
                errorListener.onErrorResponse(VolleyErrorExceptions.getInstance().getVolleyErrorStatusCode(e), VolleyErrorExceptions.getInstance().getVolleyErrorMessage(e));
            }
            return null;
        }
        return response;
    }

    public void stopServices() {
        VolleyCancel.closeDefaultObject(this.volleyStringRequest);
        VolleyCancel.closeDefaultObject(this.multipartRequest);
    }
}

