/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.widget.ImageView;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.NetworkImageView;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.main.VolleySingleton;

public class VolleyImageDownload {
    private static VolleyImageDownload volleyImageDownload;
    private int compressionSize = 500;

    public static VolleyImageDownload getInstance() {
        if (volleyImageDownload == null) {
            volleyImageDownload = new VolleyImageDownload();
        }
        return volleyImageDownload;
    }

    public void setCompressionSize(int compressionSize) {
        this.compressionSize = compressionSize;
    }

    public void downloadImage(String downloadUrl, final ImageView imageView, final VolleyResponse.ErrorImageListener errorImageListener) {
        VolleySingleton.getInstance().getImageLoader().get(downloadUrl, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    imageView.setImageBitmap(response.getBitmap());
                }
            }

            public void onErrorResponse(VolleyError error) {
                if (errorImageListener != null) {
                    errorImageListener.onErrorResponse();
                }
            }
        });
    }

    public void downloadImage(String downloadUrl, final VolleyResponse.Listener<Bitmap> bitmapListener, final VolleyResponse.ErrorImageListener errorImageListener) {
        VolleySingleton.getInstance().getImageLoader().get(downloadUrl, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                bitmapListener.onResponse(response.getBitmap());
            }

            public void onErrorResponse(VolleyError error) {
                if (errorImageListener != null) {
                    errorImageListener.onErrorResponse();
                }
            }
        });
    }

    public void downloadImageWithCompression(String downloadUrl, final ImageView imageView, final VolleyResponse.ErrorImageListener errorImageListener) {
        VolleySingleton.getInstance().getImageLoader().get(downloadUrl, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    imageView.setImageBitmap(ThumbnailUtils.extractThumbnail((Bitmap)response.getBitmap(), (int)VolleyImageDownload.this.compressionSize, (int)VolleyImageDownload.this.compressionSize));
                }
            }

            public void onErrorResponse(VolleyError error) {
                errorImageListener.onErrorResponse();
            }
        });
    }

    public void downloadImage(String downloadUrl, final ImageView imageView, final int backPlaceHolder) {
        this.downloadImage(downloadUrl, imageView, new VolleyResponse.ErrorImageListener(){

            @Override
            public void onErrorResponse() {
                imageView.setImageResource(backPlaceHolder);
            }
        });
    }

    public void downloadImage(String image, NetworkImageView imageView, int backPlaceHolder) {
        VolleySingleton.getInstance().getImageLoader().get(image, ImageLoader.getImageListener((ImageView)imageView, (int)backPlaceHolder, (int)backPlaceHolder));
        imageView.setImageUrl(image, VolleySingleton.getInstance().getImageLoader());
    }
}

