/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.helpers;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RetryPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tk.jamun.volley.classes.VolleyJsonArrayRequest;
import tk.jamun.volley.classes.VolleyJsonObjectRequest;
import tk.jamun.volley.classes.VolleyMultipartRequest;
import tk.jamun.volley.classes.VolleyNetworkRequest;
import tk.jamun.volley.classes.VolleyStringRequest;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.main.VolleySingleton;
import tk.jamun.volley.model.ModelHeader;

public class VolleyNeeds {
    private static VolleyNeeds volleyNeeds;
    private ArrayList<ModelHeader> headerArrayList;

    public static VolleyNeeds getInstance() {
        if (volleyNeeds == null) {
            volleyNeeds = new VolleyNeeds();
        }
        return volleyNeeds;
    }

    public boolean checkResponseCode(Integer networkResponse) {
        return networkResponse > 199 && networkResponse < 300;
    }

    public void setVolleyExtraCalls(VolleyNetworkRequest volleyNetworkRequest) {
        volleyNetworkRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.getInstance().getDefaultRequestTime(), 1, 1.0f));
        VolleySingleton.getInstance().getRequestQueue().add((Request)volleyNetworkRequest);
    }

    public void setVolleyExtraCalls(VolleyJsonObjectRequest volleyJsonObjectRequest) {
        volleyJsonObjectRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.getInstance().getDefaultRequestTime(), 1, 1.0f));
        VolleySingleton.getInstance().getRequestQueue().add((Request)volleyJsonObjectRequest);
    }

    public void setVolleyExtraCalls(VolleyMultipartRequest multipartRequest) {
        multipartRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.getInstance().getDefaultRequestTimeForUploadingFile(), 1, 1.0f));
        VolleySingleton.getInstance().getRequestQueue().add((Request)multipartRequest);
    }

    public void setVolleyExtraCalls(VolleyStringRequest stringRequest) {
        stringRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.getInstance().getDefaultRequestTime(), 1, 1.0f));
        VolleySingleton.getInstance().getRequestQueue().add((Request)stringRequest);
    }

    public void setVolleyExtraCalls(VolleyJsonArrayRequest volleyJsonArrayRequest) {
        volleyJsonArrayRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.getInstance().getDefaultRequestTime(), 1, 1.0f));
        VolleySingleton.getInstance().getRequestQueue().add((Request)volleyJsonArrayRequest);
    }

    public Map<String, String> setVolleyHeader() {
        if (this.headerArrayList != null && !this.headerArrayList.isEmpty()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            for (ModelHeader modelHeader : this.headerArrayList) {
                headers.put(modelHeader.getKey(), modelHeader.getValue());
            }
            return headers;
        }
        return new HashMap<String, String>();
    }

    public ArrayList<ModelHeader> getUpHeaders() {
        return this.headerArrayList;
    }

    public void setUpHeaders(ArrayList<ModelHeader> arrayList) {
        this.headerArrayList = arrayList;
    }
}

