/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.helpers;

import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;

public class VolleyErrorExceptions {
    private static VolleyErrorExceptions volleyErrorExceptions;
    public final String VOLLEY_ERROR_STRING_CONNECTION_TIMEOUT = "Connection Timeout!";
    public final String VOLLEY_ERROR_STRING_UNAUTHORIZED = "You are not Authorized, Please Login Again!";
    public final String VOLLEY_ERROR_STRING_CHECK_DATA = "Please Check your data and Try Again!";
    public final String VOLLEY_ERROR_STRING_FORBIDDEN_ACCESS = "Forbidden Error, You cannot access this!";
    public final String VOLLEY_ERROR_STRING_PAGE_NOT_FOUND = "Page not found or Missing Resources!";
    public final String VOLLEY_ERROR_STRING_NETWORK = "Network Failure, Please Try Again!";
    public final String VOLLEY_ERROR_STRING_PARSING = "Parsing Error,Unable to Parse Request!";
    public final String VOLLEY_ERROR_STRING_ELSE = "Check Connection and Try Again!";

    public static VolleyErrorExceptions getInstance() {
        if (volleyErrorExceptions == null) {
            volleyErrorExceptions = new VolleyErrorExceptions();
        }
        return volleyErrorExceptions;
    }

    public int getVolleyErrorStatusCode(VolleyError error) {
        if (error != null && error.networkResponse != null) {
            return error.networkResponse.statusCode;
        }
        return 0;
    }

    public String getVolleyErrorMessage(VolleyError error) {
        if (error != null && error.networkResponse != null) {
            switch (error.networkResponse.statusCode) {
                case 400: {
                    return "Please Check your data and Try Again!";
                }
                case 401: {
                    return "You are not Authorized, Please Login Again!";
                }
                case 403: {
                    return "Forbidden Error, You cannot access this!";
                }
                case 404: {
                    return "Page not found or Missing Resources!";
                }
            }
            if (error instanceof TimeoutError || error instanceof NoConnectionError) {
                return "Connection Timeout!";
            }
            if (error instanceof NetworkError) {
                return "Network Failure, Please Try Again!";
            }
            if (error instanceof ParseError) {
                return "Parsing Error,Unable to Parse Request!";
            }
            return "Check Connection and Try Again!";
        }
        return "";
    }

    public int getVolleyErrorStatusCode(Exception e) {
        return this.getVolleyErrorStatusCode(new VolleyError(e.getMessage()));
    }

    public String getVolleyErrorMessage(Exception e) {
        return this.getVolleyErrorMessage(new VolleyError(e.getMessage()));
    }
}

