/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import tk.jamun.volley.helpers.VolleyErrorExceptions;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.helpers.VolleyValues;

public class VolleyStringRequest
extends Request<String> {
    private VolleyResponse.Listener<String> volleyListener;
    private Response.Listener<String> mListener;
    private String mRequestBody;

    public VolleyStringRequest(String url, VolleyResponse.Listener<String> listener, VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    public VolleyStringRequest(int method, String url, String stringData, VolleyResponse.Listener<String> listener, final VolleyResponse.ErrorListener errorListener) {
        super(method, url, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                errorListener.onErrorResponse(VolleyErrorExceptions.getInstance().getVolleyErrorStatusCode(error), VolleyErrorExceptions.getInstance().getVolleyErrorMessage(error));
            }
        });
        this.volleyListener = listener;
        this.mRequestBody = stringData;
    }

    protected VolleyStringRequest(int method, String url, String stringData, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mListener = listener;
        this.mRequestBody = stringData;
    }

    public VolleyStringRequest(String url, String stringData, VolleyResponse.Listener<String> listener, VolleyResponse.ErrorListener errorListener) {
        this(1, url, stringData, listener, errorListener);
    }

    public String getBodyContentType() {
        return "application/json";
    }

    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes(VolleyValues.PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, VolleyValues.PROTOCOL_CHARSET});
            return null;
        }
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.getInstance().setVolleyHeader();
    }

    protected void deliverResponse(String response) {
        if (this.volleyListener != null) {
            this.volleyListener.onResponse(response);
        }
        if (this.mListener != null) {
            this.mListener.onResponse((Object)response);
        }
    }

    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return Response.success((Object)parsed, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
    }
}

