/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.StringRequest;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import tk.jamun.volley.helpers.VolleyErrorExceptions;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.helpers.VolleyValues;

public class VolleyResponseRequests
extends Request<StringRequest> {
    private String mRequestBody;
    private VolleyResponse.Listener<Integer> mNetworkListner;
    private VolleyResponse.Listener<StringRequest> mListener;

    public VolleyResponseRequests(String url, VolleyResponse.Listener<StringRequest> listener, VolleyResponse.Listener<Integer> mNetworkListener, VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, mNetworkListener, errorListener);
    }

    public VolleyResponseRequests(int method, String url, String stringData, VolleyResponse.Listener<StringRequest> listener, VolleyResponse.Listener<Integer> mNetworkListener, final VolleyResponse.ErrorListener errorListener) {
        super(0, url, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                errorListener.onErrorResponse(VolleyErrorExceptions.getInstance().getVolleyErrorStatusCode(error), VolleyErrorExceptions.getInstance().getVolleyErrorMessage(error));
            }
        });
        this.mListener = listener;
        this.mNetworkListner = mNetworkListener;
        this.mRequestBody = null;
    }

    public VolleyResponseRequests(String url, String stringData, VolleyResponse.Listener<StringRequest> listener, VolleyResponse.Listener<Integer> mNetworkListener, VolleyResponse.ErrorListener errorListener) {
        this(1, url, stringData, listener, mNetworkListener, errorListener);
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.getInstance().setVolleyHeader();
    }

    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes(VolleyValues.PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, VolleyValues.PROTOCOL_CHARSET});
            return null;
        }
    }

    protected Response<StringRequest> parseNetworkResponse(NetworkResponse response) {
        this.mNetworkListner.onResponse(response.statusCode);
        return null;
    }

    protected void deliverResponse(StringRequest response) {
        this.mListener.onResponse(response);
    }
}

