/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import tk.jamun.volley.helpers.VolleyErrorExceptions;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;

public class VolleyJsonObjectRequest
extends JsonRequest<JSONObject> {
    public VolleyJsonObjectRequest(int method, String url, String stringData, final VolleyResponse.Listener<JSONObject> listener, final VolleyResponse.ErrorListener errorListener) {
        super(method, url, stringData, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                listener.onResponse(response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                errorListener.onErrorResponse(VolleyErrorExceptions.getInstance().getVolleyErrorStatusCode(error), VolleyErrorExceptions.getInstance().getVolleyErrorMessage(error));
            }
        });
    }

    public VolleyJsonObjectRequest(String url, String stringData, VolleyResponse.Listener<JSONObject> listener, VolleyResponse.ErrorListener errorListener) {
        this(1, url, stringData, listener, errorListener);
    }

    public VolleyJsonObjectRequest(String url, VolleyResponse.Listener<JSONObject> listener, VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.getInstance().setVolleyHeader();
    }

    public String getBodyContentType() {
        return "application/json";
    }

    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"utf-8"));
            return Response.success((Object)new JSONObject(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JSONException je) {
            return Response.error((VolleyError)new ParseError((Throwable)je));
        }
    }
}

