/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.language;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import java.util.ArrayList;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.extras.PickerListenerLanguage;
import tk.jamun.ui.pickers.models.ModelLanguage;
import tk.jamun.ui.pickers.models.ModelLanguageParent;
import tk.jamun.ui.pickers.views.language.PickerLanguageNavigation;

public class PickerLanguageActivity
extends AppCompatActivity {
    private static PickerListenerLanguage pickerListener;
    private boolean selectionModeMulti;
    private ArrayList<ModelLanguage> arrayListSelected;
    private FloatingActionButton floatingActionButton;

    public static void setThings(Context context, PickerListenerLanguage pickerListenerLanguage, ArrayList<ModelLanguageParent> arrayList, int mode, boolean selectionModeMulti) {
        pickerListener = pickerListenerLanguage;
        context.startActivity(new Intent(context, PickerLanguageActivity.class).putParcelableArrayListExtra("data", arrayList).putExtra("mode", mode).putExtra("selecMode", selectionModeMulti));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ArrayList arrayList = this.getIntent().getParcelableArrayListExtra("data");
        this.setContentView(R.layout.library_language_activity);
        this.selectionModeMulti = this.getIntent().getBooleanExtra("selecMode", false);
        if (this.selectionModeMulti) {
            this.arrayListSelected = new ArrayList();
            this.floatingActionButton = (FloatingActionButton)this.findViewById(R.id.id_float);
            this.floatingActionButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    pickerListener.multiModeData(PickerLanguageActivity.this.arrayListSelected);
                    PickerLanguageActivity.this.onBackPressed();
                }
            });
        }
        this.getSupportFragmentManager().beginTransaction().add(R.id.id_frag, (Fragment)PickerLanguageNavigation.getInstance(new PickerListenerLanguage(){

            @Override
            public void singleModeData(ModelLanguage modelLanguage) {
                super.singleModeData(modelLanguage);
                if (PickerLanguageActivity.this.selectionModeMulti) {
                    if (PickerLanguageActivity.this.arrayListSelected.indexOf(modelLanguage) == -1) {
                        PickerLanguageActivity.this.arrayListSelected.add(modelLanguage);
                    } else {
                        PickerLanguageActivity.this.arrayListSelected.remove(modelLanguage);
                    }
                    if (PickerLanguageActivity.this.arrayListSelected.isEmpty()) {
                        PickerLanguageActivity.this.floatingActionButton.setVisibility(8);
                    } else {
                        PickerLanguageActivity.this.floatingActionButton.setVisibility(0);
                    }
                } else {
                    if (pickerListener != null) {
                        pickerListener.singleModeData(modelLanguage);
                    }
                    PickerLanguageActivity.this.onBackPressed();
                }
            }
        }, arrayList, this.getIntent().getIntExtra("mode", 0), this.selectionModeMulti), "FragNav").commit();
    }

    public void onBackPressed() {
        if (this.selectionModeMulti && this.arrayListSelected != null && !this.arrayListSelected.isEmpty()) {
            new AlertDialog.Builder((Context)this).setMessage(R.string.library_string_are_you_sure).setCancelable(true).setPositiveButton(R.string.library_string_button_name_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    PickerLanguageActivity.this.arrayListSelected.clear();
                    PickerLanguageActivity.this.finish();
                }
            }).setNegativeButton(R.string.library_string_button_name_no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).show();
        } else {
            super.onBackPressed();
        }
    }
}

