/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.extras;

import android.app.Activity;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.graphics.drawable.AnimatedVectorDrawableCompat;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.database.DBCountry;
import tk.jamun.ui.pickers.models.ModelCountry;
import tk.jamun.ui.pickers.models.ModelCountryDetails;

public class UtilityClassCountry {
    private AppCompatImageView appCompatImageViewProgress;

    public UtilityClassCountry() {
    }

    public UtilityClassCountry(View view) {
        this.appCompatImageViewProgress = (AppCompatImageView)view.findViewById(R.id.id_progress_bar);
    }

    public UtilityClassCountry(Activity view) {
        this.appCompatImageViewProgress = (AppCompatImageView)view.findViewById(R.id.id_progress_bar);
    }

    public void initializeData(ModelCountryDetails modelCountryDetails) {
        modelCountryDetails.setTagCountry("country");
        modelCountryDetails.setTagISO("iso");
        modelCountryDetails.setTagCountryCode("countrycode");
        modelCountryDetails.setTagFlag("flag");
        modelCountryDetails.setUrlImageDownload("http://flag.techcruzers.com/CountryFlag/");
        modelCountryDetails.setUrlGetCountry("http://api.simplyblood.com/public/country/2");
    }

    public void startProgressBar() {
        this.appCompatImageViewProgress.setVisibility(0);
        this.appCompatImageViewProgress.setImageResource(R.drawable.library_avd_progress_bar);
        this.startRegularAnimation(this.appCompatImageViewProgress);
    }

    public void startRegularAnimation(AppCompatImageView imageView) {
        Drawable d = imageView.getDrawable();
        if (Build.VERSION.SDK_INT >= 21 && d instanceof AnimatedVectorDrawable) {
            ((AnimatedVectorDrawable)d).start();
        } else if (d instanceof AnimatedVectorDrawableCompat) {
            ((AnimatedVectorDrawableCompat)d).start();
        }
    }

    public void closeProgressBar() {
        if (this.appCompatImageViewProgress != null) {
            this.appCompatImageViewProgress.setVisibility(8);
        }
    }

    public void setRecyclerViewCache(RecyclerView recyclerView, int size, boolean hasFixedSize) {
        recyclerView.setItemViewCacheSize(size);
        recyclerView.setHasFixedSize(hasFixedSize);
        recyclerView.setDrawingCacheEnabled(true);
        recyclerView.setDrawingCacheQuality(0x100000);
    }

    public void parseJsonResponse(ArrayList<ModelCountry> arrayList, JSONArray response, DBCountry dbCountry, ModelCountryDetails modelCountryDetails) {
        try {
            if (response != null) {
                for (int i = 0; i < response.length(); ++i) {
                    JSONObject jsonObject = response.getJSONObject(i);
                    if (!this.dataCheck(jsonObject, modelCountryDetails.getTagCountry()) || !this.dataCheck(jsonObject, modelCountryDetails.getTagCountryCode()) || !this.dataCheck(jsonObject, modelCountryDetails.getTagISO()) || !this.dataCheck(jsonObject, modelCountryDetails.getTagFlag())) continue;
                    arrayList.add(new ModelCountry(jsonObject.getString(modelCountryDetails.getTagCountry()), jsonObject.getInt(modelCountryDetails.getTagCountryCode()), jsonObject.getString(modelCountryDetails.getTagISO()), jsonObject.getString(modelCountryDetails.getTagFlag())));
                }
                dbCountry.insertCountry(arrayList);
            }
        }
        catch (JSONException e) {
            Log.d((String)"Jamun", (String)e.getMessage());
        }
    }

    private boolean dataCheck(JSONObject jsonObject, String key) {
        return jsonObject != null && jsonObject.has(key) && !jsonObject.isNull(key);
    }

    public void setView(View view) {
        this.appCompatImageViewProgress = (AppCompatImageView)view.findViewById(R.id.id_progress_bar);
    }

    public void validateData(ModelCountryDetails modelCountryDetails, ModelCountryDetails modelCountryDetailsNew) {
        if (modelCountryDetails == null) {
            modelCountryDetails = new ModelCountryDetails();
        }
        if (modelCountryDetailsNew.getUrlImageDownload() != null) {
            modelCountryDetails.setUrlImageDownload(modelCountryDetailsNew.getUrlImageDownload());
        }
        if (modelCountryDetailsNew.getUrlGetCountry() != null) {
            modelCountryDetails.setUrlGetCountry(modelCountryDetailsNew.getUrlGetCountry());
        }
        if (modelCountryDetailsNew.getTagFlag() != null) {
            modelCountryDetails.setTagFlag(modelCountryDetailsNew.getTagFlag());
        }
        if (modelCountryDetailsNew.getTagCountry() != null) {
            modelCountryDetails.setTagCountry(modelCountryDetailsNew.getTagCountry());
        }
        if (modelCountryDetailsNew.getTagCountryCode() != null) {
            modelCountryDetails.setTagCountryCode(modelCountryDetailsNew.getTagCountryCode());
        }
        if (modelCountryDetailsNew.getTagISO() != null) {
            modelCountryDetails.setTagISO(modelCountryDetailsNew.getTagISO());
        }
    }
}

