/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.adapters;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.extras.PickerListenerLanguage;
import tk.jamun.ui.pickers.models.ModelLanguage;
import tk.jamun.ui.pickers.models.ModelLanguageParent;

public class RecyclerAdapterLanguage
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<ModelLanguageParent> arrayListParent;
    private PickerListenerLanguage pickerListenerLanguage;
    private Context context;
    private boolean selectionModeMulti;
    private boolean isSomeoneSelectedFirst;

    public RecyclerAdapterLanguage(ArrayList<ModelLanguageParent> arrayListParent, PickerListenerLanguage pickerListenerLanguage, Context context, boolean selectionModeMulti) {
        this.arrayListParent = arrayListParent;
        this.pickerListenerLanguage = pickerListenerLanguage;
        this.context = context;
        this.selectionModeMulti = selectionModeMulti;
    }

    public void updateAdapter(ArrayList<ModelLanguageParent> arrayListParent) {
        this.arrayListParent = arrayListParent;
        this.notifyDataSetChanged();
    }

    private void notifyItemChangedAdapter(int position) {
        this.notifyItemChanged(position);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.library_language_recycler_parent, parent, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        ModelLanguageParent modelNavParent = this.arrayListParent.get(position);
        holder.textViewTitle.setText((CharSequence)modelNavParent.getTitle());
        holder.recyclerAdapterChild.setDataChanged(modelNavParent.getArrayList(), position);
    }

    public int getItemCount() {
        return this.arrayListParent.size();
    }

    class RecyclerAdapterChild
    extends RecyclerView.Adapter<ViewHolder> {
        private ArrayList<ModelLanguage> arrayList = new ArrayList();
        private int size;
        private int parentPosition;

        RecyclerAdapterChild() {
        }

        private void setDataChanged(ArrayList<ModelLanguage> arrayList, int parentPosition) {
            this.arrayList = arrayList;
            this.size = arrayList.size();
            this.parentPosition = parentPosition;
            this.notifyDataSetChanged();
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.library_language_recycler, parent, false));
        }

        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            ModelLanguage modelLanguage = this.arrayList.get(position);
            if (modelLanguage.isSelected()) {
                holder.imageView.setVisibility(0);
                RecyclerAdapterLanguage.this.isSomeoneSelectedFirst = true;
            } else {
                holder.imageView.setVisibility(8);
            }
            if (Build.VERSION.SDK_INT >= 25) {
                holder.textViewTitle.setText((CharSequence)Html.fromHtml((String)modelLanguage.getTitle(), (int)0), TextView.BufferType.SPANNABLE);
            } else {
                holder.textViewTitle.setText((CharSequence)Html.fromHtml((String)modelLanguage.getTitle()), TextView.BufferType.SPANNABLE);
            }
            holder.textViewLanguage.setText((CharSequence)modelLanguage.getLanguage());
            if (this.size == position + 1) {
                holder.view.setVisibility(8);
            } else {
                holder.view.setVisibility(0);
            }
            modelLanguage.setChildPosition(position);
            modelLanguage.setParentPosition(this.parentPosition);
        }

        public int getItemCount() {
            return this.arrayList.size();
        }

        public class ViewHolder
        extends RecyclerView.ViewHolder
        implements View.OnClickListener {
            TextView textViewTitle;
            TextView textViewLanguage;
            AppCompatImageView imageView;
            private View view;

            ViewHolder(View v) {
                super(v);
                this.textViewTitle = (TextView)v.findViewById(R.id.id_text_title);
                this.textViewLanguage = (TextView)v.findViewById(R.id.id_text_language);
                this.imageView = (AppCompatImageView)v.findViewById(R.id.id_image_check);
                this.view = v.findViewById(R.id.id_view);
                v.findViewById(R.id.id_linear_parent).setOnClickListener((View.OnClickListener)this);
            }

            public void onClick(View view) {
                if (!RecyclerAdapterLanguage.this.selectionModeMulti && RecyclerAdapterLanguage.this.isSomeoneSelectedFirst) {
                    for (ModelLanguageParent modelLanguageParent : RecyclerAdapterLanguage.this.arrayListParent) {
                        for (ModelLanguage modelLanguageChild : modelLanguageParent.getArrayList()) {
                            if (!modelLanguageChild.isSelected()) continue;
                            modelLanguageChild.setSelected(false);
                            if (RecyclerAdapterChild.this.parentPosition == modelLanguageChild.getParentPosition()) {
                                RecyclerAdapterChild.this.notifyItemChanged(modelLanguageChild.getChildPosition());
                                continue;
                            }
                            RecyclerAdapterLanguage.this.notifyItemChangedAdapter(modelLanguageChild.getParentPosition());
                        }
                    }
                }
                ModelLanguage modelLanguage = (ModelLanguage)RecyclerAdapterChild.this.arrayList.get(this.getAdapterPosition());
                if (RecyclerAdapterLanguage.this.selectionModeMulti && modelLanguage.isSelected()) {
                    modelLanguage.setSelected(false);
                    this.imageView.setVisibility(8);
                } else {
                    modelLanguage.setSelected(true);
                    this.imageView.setVisibility(0);
                    RecyclerAdapterLanguage.this.isSomeoneSelectedFirst = true;
                }
                RecyclerAdapterLanguage.this.pickerListenerLanguage.singleModeData(modelLanguage);
            }
        }
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private RecyclerAdapterChild recyclerAdapterChild;
        private TextView textViewTitle;

        private ViewHolder(View itemView) {
            super(itemView);
            this.textViewTitle = (TextView)itemView.findViewById(R.id.id_text_title);
            RecyclerView recyclerView = (RecyclerView)itemView.findViewById(R.id.id_recycler_view);
            recyclerView.setNestedScrollingEnabled(false);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(RecyclerAdapterLanguage.this.context));
            this.recyclerAdapterChild = new RecyclerAdapterChild();
            recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapterChild);
        }
    }
}

