/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.language;

import android.app.Activity;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import java.util.ArrayList;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.adapters.RecyclerAdapterLanguage;
import tk.jamun.ui.pickers.extras.PickerListenerLanguage;
import tk.jamun.ui.pickers.extras.UtilityClassLanguage;
import tk.jamun.ui.pickers.models.ModelLanguage;
import tk.jamun.ui.pickers.models.ModelLanguageParent;

public class PickerLanguageNavigation
extends Fragment {
    private boolean lockMode;
    private ArrayList<ModelLanguageParent> arrayList;
    private String searchData = "";
    private PickerListenerLanguage pickerListener;
    private RecyclerAdapterLanguage recyclerAdapterLanguage;
    private EditText editText;
    private DrawerLayout drawerLayout;
    private UtilityClassLanguage utilityClass;
    private View view;
    private ActionBarDrawerToggle actionBarDrawerToggle;
    private boolean found;
    private boolean selectionModeMulti;
    private ArrayList<ModelLanguage> arrayListSelected;
    private int closeDrawerGravity = 0x800003;

    public static PickerLanguageNavigation getInstance(PickerListenerLanguage pickerListener, ArrayList<ModelLanguageParent> arrayList, int mode, boolean selectionModeMulti) {
        PickerLanguageNavigation pickerCountryNavigation = new PickerLanguageNavigation();
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("data", arrayList);
        bundle.putBoolean("selecMode", selectionModeMulti);
        bundle.putInt("mode", mode);
        pickerCountryNavigation.setArguments(bundle);
        pickerCountryNavigation.bindListener(pickerListener);
        return pickerCountryNavigation;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.arrayList = new ArrayList();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.getArguments() != null) {
            return inflater.inflate(R.layout.library_language_frag, container, false);
        }
        return inflater.inflate(R.layout.library_language, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.view = view;
        this.utilityClass = new UtilityClassLanguage();
        this.initializeData();
    }

    private void initializeData() {
        if (this.getArguments() != null) {
            if (this.getArguments().getParcelableArrayList("data") == null) {
                this.utilityClass.initializeData(this.arrayList, this.getContext(), this.getArguments().getInt("mode"));
            } else {
                this.arrayList = this.getArguments().getParcelableArrayList("data");
            }
            this.selectionModeMulti = this.getArguments().getBoolean("selecMode");
            if (this.selectionModeMulti) {
                this.arrayListSelected = new ArrayList();
            }
            this.initializeView(true);
        }
    }

    private void initializeView(final boolean comeFromActivity) {
        if (!comeFromActivity) {
            this.view.findViewById(R.id.id_float).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PickerLanguageNavigation.this.pickerListener.multiModeData(PickerLanguageNavigation.this.arrayListSelected);
                    if (PickerLanguageNavigation.this.drawerLayout != null) {
                        if (PickerLanguageNavigation.this.lockMode) {
                            PickerLanguageNavigation.this.drawerLayout.setDrawerLockMode(0);
                        }
                        PickerLanguageNavigation.this.drawerLayout.closeDrawer(PickerLanguageNavigation.this.closeDrawerGravity);
                    }
                }
            });
        }
        RecyclerView recyclerView = (RecyclerView)this.view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.utilityClass.setRecyclerViewCache(recyclerView, 20, true);
        this.recyclerAdapterLanguage = new RecyclerAdapterLanguage(this.arrayList, new PickerListenerLanguage(){

            @Override
            public void singleModeData(ModelLanguage modelLanguage) {
                super.singleModeData(modelLanguage);
                if (PickerLanguageNavigation.this.selectionModeMulti) {
                    if (PickerLanguageNavigation.this.arrayListSelected.indexOf(modelLanguage) == -1) {
                        PickerLanguageNavigation.this.arrayListSelected.add(modelLanguage);
                    } else {
                        PickerLanguageNavigation.this.arrayListSelected.remove(modelLanguage);
                    }
                    if (!comeFromActivity) {
                        if (PickerLanguageNavigation.this.arrayListSelected.isEmpty()) {
                            PickerLanguageNavigation.this.view.findViewById(R.id.id_float).setVisibility(8);
                        } else {
                            PickerLanguageNavigation.this.view.findViewById(R.id.id_float).setVisibility(0);
                        }
                    }
                } else {
                    if (PickerLanguageNavigation.this.pickerListener != null) {
                        PickerLanguageNavigation.this.pickerListener.singleModeData(modelLanguage);
                    }
                    if (!comeFromActivity) {
                        PickerLanguageNavigation.this.closeDrawer();
                    }
                }
            }
        }, this.getContext(), this.selectionModeMulti);
        recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapterLanguage);
        this.editText = (EditText)this.view.findViewById(R.id.id_edit_search);
        final ArrayList newArrayListParent = new ArrayList();
        this.editText.setText((CharSequence)this.searchData);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    PickerLanguageNavigation.this.recyclerAdapterLanguage.updateAdapter(PickerLanguageNavigation.this.arrayList);
                    PickerLanguageNavigation.this.view.findViewById(R.id.id_image_clear).setVisibility(8);
                } else {
                    PickerLanguageNavigation.this.searchData = PickerLanguageNavigation.this.utilityClass.fixText(s.toString());
                    PickerLanguageNavigation.this.view.findViewById(R.id.id_image_clear).setVisibility(0);
                    newArrayListParent.clear();
                    for (ModelLanguageParent modelLanguageParent : PickerLanguageNavigation.this.arrayList) {
                        ArrayList<ModelLanguage> newArrayList = new ArrayList<ModelLanguage>();
                        for (ModelLanguage modelLanguage : modelLanguageParent.getArrayList()) {
                            if (!modelLanguage.getTitle().contains(PickerLanguageNavigation.this.searchData)) continue;
                            ModelLanguage modelLanguageNew = new ModelLanguage();
                            modelLanguageNew.setId(modelLanguage.getId());
                            modelLanguageNew.setLanguage(modelLanguage.getLanguage());
                            modelLanguageNew.setSelected(modelLanguage.isSelected());
                            PickerLanguageNavigation.this.found = true;
                            modelLanguageNew.setTitle(PickerLanguageNavigation.this.utilityClass.implementThingsForSearch(modelLanguage.getTitle(), PickerLanguageNavigation.this.searchData));
                            newArrayList.add(modelLanguageNew);
                        }
                        if (!PickerLanguageNavigation.this.found) continue;
                        newArrayListParent.add(new ModelLanguageParent(newArrayList, modelLanguageParent.getTitle()));
                        PickerLanguageNavigation.this.found = false;
                    }
                    PickerLanguageNavigation.this.recyclerAdapterLanguage.updateAdapter(newArrayListParent);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.view.findViewById(R.id.id_image_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)PickerLanguageNavigation.this.editText.getText())) {
                    PickerLanguageNavigation.this.editText.setText((CharSequence)"");
                    PickerLanguageNavigation.this.searchData = "";
                } else if (PickerLanguageNavigation.this.selectionModeMulti && PickerLanguageNavigation.this.arrayListSelected != null && !PickerLanguageNavigation.this.arrayListSelected.isEmpty()) {
                    new AlertDialog.Builder(PickerLanguageNavigation.this.getContext()).setMessage(R.string.library_string_are_you_sure).setCancelable(true).setPositiveButton(R.string.library_string_button_name_yes, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PickerLanguageNavigation.this.closeDrawer();
                        }
                    }).setNegativeButton(R.string.library_string_button_name_no, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).show();
                } else {
                    PickerLanguageNavigation.this.closeDrawer();
                }
            }
        });
        this.view.findViewById(R.id.id_image_clear).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickerLanguageNavigation.this.editText.setText((CharSequence)"");
            }
        });
        this.recyclerAdapterLanguage.updateAdapter(this.arrayList);
    }

    private void closeDrawer() {
        if (this.drawerLayout != null) {
            if (this.lockMode) {
                this.drawerLayout.setDrawerLockMode(0);
            }
            this.drawerLayout.closeDrawer(this.closeDrawerGravity);
        } else {
            this.getActivity().finish();
        }
    }

    public void setSelectionModeMulti(boolean selectionModeMulti) {
        this.selectionModeMulti = selectionModeMulti;
        if (selectionModeMulti) {
            this.arrayListSelected = new ArrayList();
        }
    }

    private void closeEverything() {
        if (this.arrayList != null) {
            this.arrayList.clear();
        }
    }

    public void setData(ArrayList<ModelLanguageParent> arrayList) {
        this.arrayList = arrayList;
        if (this.recyclerAdapterLanguage != null) {
            this.recyclerAdapterLanguage.notifyDataSetChanged();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.closeEverything();
    }

    public void setUpDrawer(final DrawerLayout drawerLayout, Toolbar toolbar, final boolean enableLockMode, PickerListenerLanguage pickerListener, int mode, int drawerGravity) {
        this.drawerLayout = drawerLayout;
        this.actionBarDrawerToggle = new ActionBarDrawerToggle((Activity)this.getActivity(), drawerLayout, toolbar, R.string.library_drawer_open, R.string.library_drawer_close){

            public void onDrawerOpened(View drawerView) {
                super.onDrawerOpened(drawerView);
                if (enableLockMode) {
                    drawerLayout.setDrawerLockMode(2);
                }
            }

            public void onDrawerClosed(View drawerView) {
                super.onDrawerClosed(drawerView);
                if (enableLockMode) {
                    drawerLayout.setDrawerLockMode(1);
                }
            }
        };
        this.actionBarDrawerToggle.setDrawerIndicatorEnabled(false);
        drawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this.actionBarDrawerToggle);
        drawerLayout.post(new Runnable(){

            @Override
            public void run() {
                PickerLanguageNavigation.this.actionBarDrawerToggle.syncState();
            }
        });
        drawerLayout.setDrawerLockMode(1);
        this.closeDrawerGravity = drawerGravity;
        if (drawerGravity == 0x800005) {
            AppCompatImageView appCompatImageViewArrow = (AppCompatImageView)this.view.findViewById(R.id.id_image_back);
            appCompatImageViewArrow.setImageResource(R.drawable.library_icon_vd_arrow_forword);
        }
        this.lockMode = enableLockMode;
        this.bindListener(pickerListener);
        this.utilityClass.initializeData(this.arrayList, this.getContext(), mode);
        this.initializeView(false);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.actionBarDrawerToggle != null) {
            this.actionBarDrawerToggle.onConfigurationChanged(newConfig);
        }
    }

    public void bindListener(PickerListenerLanguage pickerListener) {
        this.pickerListener = pickerListener;
    }
}

