/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.intents;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.FileProvider;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.models.ModelShareFiles;

public class PickerShareFiles
extends BottomSheetDialogFragment {
    int ACTION_REQUEST_ACTIVITY = 11;
    private Context context;
    private ArrayList<ModelShareFiles> arrayList = new ArrayList();
    private PackageManager packageManager;
    private String text;
    private File file;
    private String subject;
    private String storageProvider;
    private Drawable copyIcon;
    private boolean enableCopyToClipboard;
    private RecyclerAdapterCountry recyclerAdapter;
    private CopyToClipboard copyToClipboard;
    private String title;

    public PickerShareFiles() {
        this.setStyle(0, R.style.LibraryBottomSheetDialogTheme);
    }

    public void setStorageProvider(String storageProvider) {
        this.storageProvider = storageProvider;
    }

    public void enableCopyToClipboard(@NonNull Drawable copyIcon, CopyToClipboard copyToClipboard) {
        this.copyIcon = copyIcon;
        this.copyToClipboard = copyToClipboard;
        this.enableCopyToClipboard = true;
    }

    public PickerShareFiles setThings(@NonNull Context context, @NonNull String storageProvider) {
        this.context = context;
        this.storageProvider = storageProvider;
        this.packageManager = context.getPackageManager();
        return this;
    }

    public PickerShareFiles setTitle(String title) {
        this.title = title;
        return this;
    }

    public PickerShareFiles setThings(@NonNull Context context) {
        this.context = context;
        this.packageManager = context.getPackageManager();
        return this;
    }

    public void shareThings(@NonNull FragmentManager fragmentManager, File file, @NonNull String description, @NonNull String subject) {
        this.subject = subject;
        this.text = this.text;
        this.file = file;
        this.show(fragmentManager, this.getTag());
    }

    public void shareThings(@NonNull FragmentManager fragmentManager, @NonNull String description, @NonNull String subject) {
        this.subject = subject;
        this.text = this.text;
        this.show(fragmentManager, this.getTag());
    }

    @SuppressLint(value={"RestrictedApi"})
    public void setupDialog(Dialog dialog, int style2) {
        super.setupDialog(dialog, style2);
        View view = View.inflate((Context)this.getContext(), (int)R.layout.library_intent_share_files, null);
        dialog.setContentView(view);
        TextView textView = (TextView)view.findViewById(R.id.id_text_title);
        if (this.title != null) {
            textView.setText((CharSequence)this.title);
        }
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 3));
        if (this.arrayList.isEmpty()) {
            new LoadApplications().execute(new Void[0]);
        }
        this.recyclerAdapter = new RecyclerAdapterCountry();
        recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapter);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private class LoadApplications
    extends AsyncTask<Void, Void, Void> {
        private LoadApplications() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        private void checkForLaunchIntent(List<ApplicationInfo> list) {
            for (ApplicationInfo info : list) {
                try {
                    String name = info.packageName;
                    if (null != PickerShareFiles.this.packageManager.getLaunchIntentForPackage(name) && (name.equals("com.whatsapp") || name.equals("com.android.bluetooth") || name.equals("com.twitter.android") || name.equals("com.bsb.hike") || name.equals("com.google.android.talk") || name.equals("com.lenovo.anyshare.gps") || name.equals("com.google.android.gm") || name.equals("com.google.android.apps.docs") || name.equals("com.facebook.katana") || name.equals("com.facebook.orca") || name.equals("com.facebook.lite") || name.equals("com.google.android.apps.plus") || name.equals("com.pinterest") || name.equals("com.textedin.android") || name.equals("com.reddit.frontpage") || name.equals("com.tumblr") || name.equals("com.imo.android.imoim") || name.equals("jp.naver.line.android") || name.equals("com.tencent.mm") || name.equals("kik.android") || name.equals("com.skype.m2") || name.equals("org.telegram.messenger") || name.equals("com.snapchat.android") || name.equals("com.instagram.android") || name.equals("org.telegram.messenger") || name.equals("com.android.email") || name.equals("com.android.mms"))) {
                        PickerShareFiles.this.arrayList.add(new ModelShareFiles(info.loadLabel(PickerShareFiles.this.packageManager).toString(), name, info.loadIcon(PickerShareFiles.this.packageManager)));
                    }
                    if (!PickerShareFiles.this.enableCopyToClipboard) continue;
                    PickerShareFiles.this.arrayList.add(new ModelShareFiles("Copy to\nClipboard", null, PickerShareFiles.this.copyIcon));
                }
                catch (Exception exception) {}
            }
        }

        protected Void doInBackground(Void ... params) {
            this.checkForLaunchIntent(PickerShareFiles.this.packageManager.getInstalledApplications(1024));
            return null;
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute((Object)result);
            PickerShareFiles.this.recyclerAdapter.updateAdapter();
        }
    }

    private class RecyclerAdapterCountry
    extends RecyclerView.Adapter<ViewHolder> {
        private int size;

        public RecyclerAdapterCountry() {
            this.size = PickerShareFiles.this.arrayList.size();
        }

        private void updateAdapter() {
            this.size = PickerShareFiles.this.arrayList.size();
            this.notifyDataSetChanged();
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.library_intent_share_recycler, parent, false));
        }

        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            ModelShareFiles modelShareFiles = (ModelShareFiles)PickerShareFiles.this.arrayList.get(position);
            holder.textViewName.setText((CharSequence)modelShareFiles.getName());
            holder.imageView.setImageDrawable(modelShareFiles.getDrawable());
        }

        public int getItemCount() {
            return PickerShareFiles.this.arrayList.size();
        }

        class ViewHolder
        extends RecyclerView.ViewHolder
        implements View.OnClickListener {
            TextView textViewName;
            AppCompatImageView imageView;

            ViewHolder(View v) {
                super(v);
                this.textViewName = (TextView)v.findViewById(R.id.id_text);
                this.imageView = (AppCompatImageView)v.findViewById(R.id.id_image);
                v.setOnClickListener((View.OnClickListener)this);
            }

            public void onClick(View view) {
                int adapterPosition = this.getAdapterPosition();
                if (PickerShareFiles.this.enableCopyToClipboard && adapterPosition == RecyclerAdapterCountry.this.size - 1) {
                    if (PickerShareFiles.this.copyToClipboard != null) {
                        PickerShareFiles.this.copyToClipboard.getTextToCopy(PickerShareFiles.this.text);
                    }
                } else {
                    ModelShareFiles modelShareFiles = (ModelShareFiles)PickerShareFiles.this.arrayList.get(adapterPosition);
                    try {
                        Intent shareIntent = new Intent();
                        shareIntent.setAction("android.intent.action.SEND");
                        if (PickerShareFiles.this.file != null) {
                            Uri imageUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)PickerShareFiles.this.context, (String)PickerShareFiles.this.storageProvider, (File)PickerShareFiles.this.file) : Uri.fromFile((File)PickerShareFiles.this.file);
                            shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imageUri);
                            shareIntent.setType("* @author Jatin Sahgal */*");
                        } else {
                            shareIntent.setType("text/plain");
                        }
                        shareIntent.putExtra("android.intent.extra.TEXT", PickerShareFiles.this.text);
                        shareIntent.putExtra("android.intent.extra.SUBJECT", PickerShareFiles.this.subject);
                        shareIntent.setPackage(modelShareFiles.getPackageName());
                        PickerShareFiles.this.startActivityForResult(shareIntent, PickerShareFiles.this.ACTION_REQUEST_ACTIVITY);
                    }
                    catch (Exception e) {
                        Log.e((String)PickerShareFiles.class.getSimpleName(), (String)(e.getMessage() + " "));
                    }
                }
                PickerShareFiles.this.dismiss();
            }
        }
    }

    public static interface CopyToClipboard {
        public void getTextToCopy(String var1);
    }
}

