/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.country;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import java.util.ArrayList;
import org.json.JSONArray;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.adapters.RecyclerAdapterCountry;
import tk.jamun.ui.pickers.database.DBCountry;
import tk.jamun.ui.pickers.extras.InterfaceCountryListener;
import tk.jamun.ui.pickers.extras.PickerListenerCountry;
import tk.jamun.ui.pickers.extras.UtilityClassCountry;
import tk.jamun.ui.pickers.models.ModelCountry;
import tk.jamun.ui.pickers.models.ModelCountryDetails;
import tk.jamun.volley.classes.VolleyJsonArrayRequest;
import tk.jamun.volley.helpers.VolleyCancel;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.main.VolleySingleton;

public class PickerCountryBottom
extends BottomSheetDialogFragment {
    private DBCountry dbCountry;
    private ArrayList<ModelCountry> arrayList = new ArrayList();
    private VolleyJsonArrayRequest jsonArrayRequest;
    private String searchData = "";
    private InterfaceCountryListener pickerListener;
    private RecyclerAdapterCountry recyclerAdapterCountry;
    private EditText editText;
    private UtilityClassCountry utilityClass = new UtilityClassCountry();
    private ModelCountryDetails modelCountryDetails = new ModelCountryDetails();
    private ArrayList<ModelCountry> arrayListSelectedCountry;
    private boolean selectionModeMulti;
    private String editTextHint;

    public PickerCountryBottom() {
        this.utilityClass.initializeData(this.modelCountryDetails);
        this.setStyle(0, R.style.LibraryBottomSheetDialogTheme);
    }

    public PickerCountryBottom setSelectionModeMulti(boolean selectionModeMulti) {
        this.selectionModeMulti = selectionModeMulti;
        if (selectionModeMulti) {
            this.arrayListSelectedCountry = new ArrayList();
        }
        return this;
    }

    public PickerCountryBottom setTags(ModelCountryDetails modelCountryDetailsNew) {
        this.utilityClass.validateData(this.modelCountryDetails, modelCountryDetailsNew);
        return this;
    }

    public PickerCountryBottom setEditTextHint(String editTextHint) {
        this.editTextHint = editTextHint;
        return this;
    }

    public PickerCountryBottom setThings(Context context) {
        VolleySingleton.setInstance((Context)context);
        this.dbCountry = new DBCountry();
        this.arrayList = this.dbCountry.getAllCountry(this.arrayList);
        return this;
    }

    @SuppressLint(value={"RestrictedApi"})
    public void setupDialog(Dialog dialog, int style2) {
        super.setupDialog(dialog, style2);
        View view = View.inflate((Context)this.getContext(), (int)R.layout.library_country_bottom, null);
        dialog.setContentView(view);
        this.initializeView(view);
    }

    private void initializeView(final View view) {
        this.utilityClass.setView(view);
        if (this.selectionModeMulti) {
            view.findViewById(R.id.id_float).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PickerCountryBottom.this.pickerListener.multiModeData(PickerCountryBottom.this.arrayListSelectedCountry);
                    PickerCountryBottom.this.dismiss();
                }
            });
        }
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.utilityClass.setRecyclerViewCache(recyclerView, 20, true);
        this.recyclerAdapterCountry = new RecyclerAdapterCountry(this.arrayList, this.modelCountryDetails.getUrlImageDownload(), new PickerListenerCountry(){

            @Override
            public void singleModeData(ModelCountry modelCountry) {
                super.singleModeData(modelCountry);
                if (PickerCountryBottom.this.selectionModeMulti) {
                    if (PickerCountryBottom.this.arrayListSelectedCountry.indexOf(modelCountry) == -1) {
                        PickerCountryBottom.this.arrayListSelectedCountry.add(modelCountry);
                    } else {
                        PickerCountryBottom.this.arrayListSelectedCountry.remove(modelCountry);
                    }
                    if (PickerCountryBottom.this.arrayListSelectedCountry.isEmpty()) {
                        view.findViewById(R.id.id_float).setVisibility(8);
                    } else {
                        view.findViewById(R.id.id_float).setVisibility(0);
                    }
                } else {
                    PickerCountryBottom.this.dismiss();
                    if (PickerCountryBottom.this.pickerListener != null) {
                        PickerCountryBottom.this.pickerListener.singleModeData(modelCountry);
                    }
                }
            }

            @Override
            public void apiError(int statusCode, String errorMessage) {
            }
        }, this.selectionModeMulti);
        recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapterCountry);
        this.editText = (EditText)view.findViewById(R.id.id_edit_search);
        if (this.editTextHint != null) {
            this.editText.setHint((CharSequence)this.editTextHint);
        }
        final ArrayList newArrayList = new ArrayList();
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    PickerCountryBottom.this.recyclerAdapterCountry.setDataChanged(PickerCountryBottom.this.arrayList);
                    view.findViewById(R.id.id_image_clear).setVisibility(8);
                } else {
                    view.findViewById(R.id.id_image_clear).setVisibility(0);
                    newArrayList.clear();
                    for (ModelCountry modelCountry : PickerCountryBottom.this.arrayList) {
                        if (!modelCountry.getCountryName().toLowerCase().contains(s.toString().toLowerCase())) continue;
                        newArrayList.add(modelCountry);
                    }
                    PickerCountryBottom.this.recyclerAdapterCountry.setDataChanged(newArrayList);
                }
                PickerCountryBottom.this.searchData = s.toString();
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    view.findViewById(R.id.id_view_keyboard).setVisibility(0);
                } else {
                    view.findViewById(R.id.id_view_keyboard).setVisibility(8);
                }
            }
        });
        this.editText.setText((CharSequence)this.searchData);
        view.findViewById(R.id.id_image_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)PickerCountryBottom.this.editText.getText())) {
                    PickerCountryBottom.this.editText.setText((CharSequence)"");
                    PickerCountryBottom.this.searchData = "";
                } else {
                    PickerCountryBottom.this.dismiss();
                }
            }
        });
        view.findViewById(R.id.id_image_clear).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickerCountryBottom.this.editText.setText((CharSequence)"");
            }
        });
        if (this.arrayList.isEmpty()) {
            this.getCountry();
        } else {
            this.recyclerAdapterCountry.update(this.arrayList);
        }
    }

    public PickerCountryBottom bindListener(InterfaceCountryListener pickerListener) {
        this.pickerListener = pickerListener;
        return this;
    }

    public void clearSelectedList() {
        if (this.arrayListSelectedCountry != null) {
            this.arrayListSelectedCountry.clear();
        }
    }

    public void clear() {
        VolleyCancel.closeDefaultObject((VolleyJsonArrayRequest)this.jsonArrayRequest);
        if (this.arrayList != null) {
            this.arrayList.clear();
        }
        this.arrayList = null;
        this.pickerListener = null;
    }

    public void showPicker(FragmentManager fragmentManager) {
        this.show(fragmentManager, this.getTag());
    }

    public ModelCountry findByCode(String isoCode) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (!modelCountry.getCountryISO().equals(isoCode)) continue;
                return modelCountry;
            }
        }
        return null;
    }

    public ModelCountry findByCode(int countryCode) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (modelCountry.getCountryCode() != countryCode) continue;
                return modelCountry;
            }
        }
        return null;
    }

    public ModelCountry findByName(String countryName) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (!modelCountry.getCountryName().equals(countryName)) continue;
                return modelCountry;
            }
        }
        return null;
    }

    private void getCountry() {
        if (this.dbCountry.IsEmpty()) {
            this.utilityClass.startProgressBar();
            this.startCountryApi();
        } else {
            this.arrayList = this.dbCountry.getAllCountry(this.arrayList);
            this.recyclerAdapterCountry.update(this.arrayList);
        }
    }

    private void startCountryApi() {
        this.editText.setEnabled(false);
        this.jsonArrayRequest = new VolleyJsonArrayRequest(0, this.modelCountryDetails.getUrlGetCountry(), null, (VolleyResponse.Listener)new VolleyResponse.Listener<JSONArray>(){

            public void onResponse(JSONArray response) {
                PickerCountryBottom.this.editText.setEnabled(true);
                PickerCountryBottom.this.utilityClass.parseJsonResponse(PickerCountryBottom.this.arrayList, response, PickerCountryBottom.this.dbCountry, PickerCountryBottom.this.modelCountryDetails);
                PickerCountryBottom.this.recyclerAdapterCountry.update(PickerCountryBottom.this.arrayList);
                PickerCountryBottom.this.utilityClass.closeProgressBar();
            }
        }, new VolleyResponse.ErrorListener(){

            public void onErrorResponse(int statusCode, String errorMessage) {
                PickerCountryBottom.this.utilityClass.closeProgressBar();
                if (PickerCountryBottom.this.pickerListener != null) {
                    PickerCountryBottom.this.pickerListener.apiError(statusCode, errorMessage);
                }
                PickerCountryBottom.this.dismiss();
            }
        });
        VolleyNeeds.getInstance().setVolleyExtraCalls(this.jsonArrayRequest);
    }

    public void refreshDatabase() {
        this.dbCountry.deleteAll();
        this.getCountry();
    }
}

