/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.elements.circularnetworkimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.volley.toolbox.NetworkImageView;
import tk.jamun.elements.circularnetworkimageview.R;

public class CircularNetworkImageView
extends NetworkImageView {
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLOR_DIMENSION = 2;
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final boolean DEFAULT_BORDER_OVERLAY = false;
    private final RectF dRect = new RectF();
    private final RectF bRect = new RectF();
    private final Matrix sMatrix = new Matrix();
    private final Paint bitmapPaint = new Paint();
    private final Paint bPaint = new Paint();
    private int bColor = -16777216;
    private int bWidth = 0;
    private Bitmap bitmap;
    private BitmapShader bShader;
    private int bitmapWidth;
    private int bitmapHeight;
    private float mDR;
    private float mBR;
    private ColorFilter mCF;
    private boolean mR;
    private boolean mSP;
    private boolean mBO;

    public CircularNetworkImageView(Context context) {
        super(context);
        this.init();
    }

    public CircularNetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularNetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularNetworkImageView, defStyle, 0);
        this.bWidth = a.getDimensionPixelSize(R.styleable.CircularNetworkImageView_library_border_width, 0);
        this.bColor = a.getColor(R.styleable.CircularNetworkImageView_library_border_color, -16777216);
        this.mBO = a.getBoolean(R.styleable.CircularNetworkImageView_library_border_overlay, false);
        a.recycle();
        this.init();
    }

    private void init() {
        super.setScaleType(SCALE_TYPE);
        this.mR = true;
        if (this.mSP) {
            this.setup();
            this.mSP = false;
        }
    }

    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != SCALE_TYPE) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (adjustViewBounds) {
            throw new IllegalArgumentException("adjustViewBounds not supported.");
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.mDR, this.bitmapPaint);
        if (this.bWidth != 0) {
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.mBR, this.bPaint);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setup();
    }

    public int getBorderColor() {
        return this.bColor;
    }

    public void setBorderColor(int borderColor) {
        if (borderColor == this.bColor) {
            return;
        }
        this.bColor = borderColor;
        this.bPaint.setColor(this.bColor);
        this.invalidate();
    }

    public void setBorderColorResource(@ColorRes int borderColorRes) {
        this.setBorderColor(this.getContext().getResources().getColor(borderColorRes));
    }

    public int getBorderWidth() {
        return this.bWidth;
    }

    public void setBorderWidth(int borderWidth) {
        if (borderWidth == this.bWidth) {
            return;
        }
        this.bWidth = borderWidth;
        this.setup();
    }

    public boolean isBorderOverlay() {
        return this.mBO;
    }

    public void setBorderOverlay(boolean borderOverlay) {
        if (borderOverlay == this.mBO) {
            return;
        }
        this.mBO = borderOverlay;
        this.setup();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.bitmap = bm;
        this.setup();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.bitmap = this.getBitmapFromDrawable(drawable);
        this.setup();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.bitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.bitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf == this.mCF) {
            return;
        }
        this.mCF = cf;
        this.bitmapPaint.setColorFilter(this.mCF);
        this.invalidate();
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    private void setup() {
        if (!this.mR) {
            this.mSP = true;
            return;
        }
        if (this.bitmap == null) {
            return;
        }
        this.bShader = new BitmapShader(this.bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.bitmapPaint.setAntiAlias(true);
        this.bitmapPaint.setShader((Shader)this.bShader);
        this.bPaint.setStyle(Paint.Style.STROKE);
        this.bPaint.setAntiAlias(true);
        this.bPaint.setColor(this.bColor);
        this.bPaint.setStrokeWidth((float)this.bWidth);
        this.bitmapHeight = this.bitmap.getHeight();
        this.bitmapWidth = this.bitmap.getWidth();
        this.bRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.mBR = Math.min((this.bRect.height() - (float)this.bWidth) / 2.0f, (this.bRect.width() - (float)this.bWidth) / 2.0f);
        this.dRect.set(this.bRect);
        if (!this.mBO) {
            this.dRect.inset((float)this.bWidth, (float)this.bWidth);
        }
        this.mDR = Math.min(this.dRect.height() / 2.0f, this.dRect.width() / 2.0f);
        this.updateShaderMatrix();
        this.invalidate();
    }

    private void updateShaderMatrix() {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        this.sMatrix.set(null);
        if ((float)this.bitmapWidth * this.dRect.height() > this.dRect.width() * (float)this.bitmapHeight) {
            scale = this.dRect.height() / (float)this.bitmapHeight;
            dx = (this.dRect.width() - (float)this.bitmapWidth * scale) * 0.5f;
        } else {
            scale = this.dRect.width() / (float)this.bitmapWidth;
            dy = (this.dRect.height() - (float)this.bitmapHeight * scale) * 0.5f;
        }
        this.sMatrix.setScale(scale, scale);
        this.sMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.dRect.left, (float)((int)(dy + 0.5f)) + this.dRect.top);
        this.bShader.setLocalMatrix(this.sMatrix);
    }
}

