/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.content.Context;
import android.media.AudioManager;
import android.media.SoundPool;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;

public class RTCSoundPool {
    private boolean playing = false;
    private boolean loaded = false;
    private boolean playingCalled = false;
    private float volume = 0.0f;
    private SoundPool soundPool;
    private int ringingSoundId;
    private int ringingStreamId;
    private int loopValue = -1;

    private RTCSoundPool(@NonNull Context context, int resId, boolean loop) {
        AudioManager audioManager;
        Preconditions.checkNotNull((Object)context);
        if (!loop) {
            this.loopValue = 0;
        }
        if ((audioManager = (AudioManager)context.getSystemService("audio")) != null) {
            float actualVolume = audioManager.getStreamVolume(3);
            float maxVolume = audioManager.getStreamMaxVolume(3);
            this.volume = actualVolume / maxVolume;
        }
        int maxStreams = 1;
        this.soundPool = new SoundPool.Builder().setMaxStreams(maxStreams).build();
        this.soundPool.setOnLoadCompleteListener((soundPool, sampleId, status) -> {
            this.loaded = true;
            if (this.playingCalled) {
                this.play();
                this.playingCalled = false;
            }
        });
        this.ringingSoundId = this.soundPool.load(context, resId, 1);
    }

    public static RTCSoundPool create(Context context, int resId, boolean loop) {
        return new RTCSoundPool(context, resId, loop);
    }

    public void play() {
        if (this.loaded && !this.playing) {
            this.ringingStreamId = this.soundPool.play(this.ringingSoundId, this.volume, this.volume, 1, this.loopValue, 1.0f);
            this.playing = true;
        } else {
            this.playingCalled = true;
        }
    }

    public void stop() {
        if (this.playing) {
            this.soundPool.stop(this.ringingStreamId);
            this.playing = false;
        }
    }

    public void release() {
        if (this.soundPool != null) {
            this.soundPool.unload(this.ringingSoundId);
            this.soundPool.release();
        }
    }
}

