/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.util.Preconditions;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.webrtc.R;
import threads.webrtc.RTCSession;
import threads.webrtc.RTCSoundPool;

public class RTCCallDialogFragment
extends DialogFragment {
    public static final String TAG = RTCCallDialogFragment.class.getSimpleName();
    private static final String TOPIC = "TOPIC";
    private static final String VIDEO = "VIDEO";
    private final AtomicBoolean dismissed = new AtomicBoolean(false);
    private ActionListener mListener;
    private Context mContext;
    private RTCSoundPool soundPoolManager;

    static RTCCallDialogFragment newInstance(@NonNull String topic, boolean video) {
        Preconditions.checkNotNull((Object)topic);
        Bundle bundle = new Bundle();
        bundle.putString(TOPIC, topic);
        bundle.putBoolean(VIDEO, video);
        RTCCallDialogFragment fragment = new RTCCallDialogFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onDetach() {
        super.onDetach();
        this.mContext = null;
        this.dismissed.set(true);
        this.soundPoolManager.release();
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.mContext = context;
        try {
            this.mListener = (ActionListener)this.getActivity();
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
        this.soundPoolManager = RTCSoundPool.create(this.mContext, R.raw.outgoing, true);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity activity = this.getActivity();
        Preconditions.checkNotNull((Object)activity);
        Bundle args = this.getArguments();
        Preconditions.checkNotNull((Object)args);
        String topic = args.getString(TOPIC);
        Preconditions.checkNotNull((Object)topic);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        boolean video = args.getBoolean(VIDEO);
        if (video) {
            builder.setIcon(R.drawable.text_video_call);
        } else {
            builder.setIcon(R.drawable.text_phone);
        }
        builder.setTitle((CharSequence)this.getString(R.string.outgoing_call));
        builder.setPositiveButton((CharSequence)this.getString(R.string.abort), (dialog, which) -> {
            this.soundPoolManager.stop();
            this.mListener.abortCall(topic);
            dialog.dismiss();
        });
        AlertDialog dialog2 = builder.create();
        dialog2.setCancelable(false);
        dialog2.setCanceledOnTouchOutside(false);
        dialog2.requestWindowFeature(1);
        Preconditions.checkNotNull((Object)dialog2.getWindow());
        dialog2.getWindow().setFlags(1024, 1024);
        dialog2.getWindow().addFlags(0x400000);
        dialog2.getWindow().addFlags(524288);
        dialog2.getWindow().addFlags(1024);
        dialog2.getWindow().getDecorView().getRootView().setSystemUiVisibility(3846);
        dialog2.getWindow().addFlags(8);
        dialog2.setOnShowListener(dialogInterface -> {
            Button positive = dialog2.getButton(-1);
            positive.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.phone_reject, 0, 0, 0);
            positive.setCompoundDrawablePadding(16);
        });
        dialog2.setOnDismissListener(arg -> this.dismissed.set(true));
        int timeout = Preferences.getConnectionTimeout((Context)this.mContext) * 1000;
        long start = System.currentTimeMillis();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(() -> {
                block13: {
                    try {
                        boolean connected = Singleton.getInstance((Context)this.mContext).connectPubsubTopic(this.mContext, topic);
                        if (!connected) {
                            try {
                                Thread.sleep(6000L);
                            }
                            catch (Throwable e) {
                                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
                            }
                        }
                        RTCSession.getInstance().emitSessionAlive(this.mContext, topic);
                        if (video) {
                            RTCSession.getInstance().emitSessionVideoCall(this.mContext, topic);
                        } else {
                            RTCSession.getInstance().emitSessionCall(this.mContext, topic);
                        }
                        long rest = System.currentTimeMillis() - (start - (long)timeout);
                        if (rest <= 0L) break block13;
                        try {
                            Thread.sleep(rest);
                            if (!this.dismissed.get()) {
                                this.mListener.timeoutCall(topic);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.soundPoolManager.stop();
                        dialog2.dismiss();
                    }
                }
            });
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
        this.soundPoolManager.play();
        return dialog2;
    }

    public void onDismiss(@NonNull DialogInterface dialog) {
        super.onDismiss(dialog);
        this.dismissed.set(true);
    }

    public static interface ActionListener {
        public void abortCall(@NonNull String var1);

        public void timeoutCall(@NonNull String var1);
    }
}

