/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import org.webrtc.ThreadUtils;

public class RTCProximitySensor
implements SensorEventListener {
    private static final String TAG = "RTCProximitySensor";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final Runnable onSensorStateListener;
    private final SensorManager sensorManager;
    @Nullable
    private Sensor proximitySensor;
    private boolean lastStateReportIsNear;

    private RTCProximitySensor(Context context, Runnable sensorStateListener) {
        Log.d((String)TAG, (String)TAG);
        this.onSensorStateListener = sensorStateListener;
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
    }

    static RTCProximitySensor create(Context context, Runnable sensorStateListener) {
        return new RTCProximitySensor(context, sensorStateListener);
    }

    public boolean start() {
        this.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)"start");
        if (!this.initDefaultSensor()) {
            return false;
        }
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
        return true;
    }

    public void stop() {
        this.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)"stop");
        if (this.proximitySensor == null) {
            return;
        }
        this.sensorManager.unregisterListener((SensorEventListener)this, this.proximitySensor);
    }

    public boolean sensorReportsNearState() {
        this.threadChecker.checkIsOnValidThread();
        return this.lastStateReportIsNear;
    }

    public final void onAccuracyChanged(Sensor sensor, int accuracy) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkArgument((sensor.getType() == 8 ? 1 : 0) != 0);
        if (accuracy == 0) {
            Log.e((String)TAG, (String)"The values returned by this sensor cannot be trusted");
        }
    }

    public final void onSensorChanged(SensorEvent event) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkArgument((event.sensor.getType() == 8 ? 1 : 0) != 0);
        float distanceInCentimeters = event.values[0];
        if (distanceInCentimeters < this.proximitySensor.getMaximumRange()) {
            Log.d((String)TAG, (String)"Proximity sensor => NEAR state");
            this.lastStateReportIsNear = true;
        } else {
            Log.d((String)TAG, (String)"Proximity sensor => FAR state");
            this.lastStateReportIsNear = false;
        }
        if (this.onSensorStateListener != null) {
            this.onSensorStateListener.run();
        }
        Log.d((String)TAG, (String)("onSensorChanged: accuracy=" + event.accuracy + ", timestamp=" + event.timestamp + ", distance=" + event.values[0]));
    }

    private boolean initDefaultSensor() {
        if (this.proximitySensor != null) {
            return true;
        }
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        if (this.proximitySensor == null) {
            return false;
        }
        this.logProximitySensorInfo();
        return true;
    }

    private void logProximitySensorInfo() {
        if (this.proximitySensor == null) {
            return;
        }
        StringBuilder info = new StringBuilder("Proximity sensor: ");
        info.append("name=").append(this.proximitySensor.getName());
        info.append(", vendor: ").append(this.proximitySensor.getVendor());
        info.append(", power: ").append(this.proximitySensor.getPower());
        info.append(", resolution: ").append(this.proximitySensor.getResolution());
        info.append(", max range: ").append(this.proximitySensor.getMaximumRange());
        info.append(", min delay: ").append(this.proximitySensor.getMinDelay());
        info.append(", type: ").append(this.proximitySensor.getStringType());
        info.append(", max delay: ").append(this.proximitySensor.getMaxDelay());
        info.append(", reporting mode: ").append(this.proximitySensor.getReportingMode());
        info.append(", isWakeUpSensor: ").append(this.proximitySensor.isWakeUpSensor());
        Log.d((String)TAG, (String)info.toString());
    }
}

