/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.widget.Chronometer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.app.TaskStackBuilder;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SessionDescription;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.mdl.EventViewModel;
import threads.webrtc.R;
import threads.webrtc.RTCAudioManager;
import threads.webrtc.RTCCallDialogFragment;
import threads.webrtc.RTCCallingDialogFragment;
import threads.webrtc.RTCClient;
import threads.webrtc.RTCPeerConnection;
import threads.webrtc.RTCSession;

public class RTCCallActivity
extends AppCompatActivity
implements RTCClient.SignalingEvents,
RTCPeerConnection.PeerConnectionEvents,
RTCCallingDialogFragment.ActionListener,
RTCCallDialogFragment.ActionListener {
    public static final String ACTION_INCOMING_CALL = "ACTION_INCOMING_CALL";
    public static final String ACTION_OUTGOING_CALL = "ACTION_OUTGOING_CALL";
    public static final String EXTRA_VIDEO_WIDTH = "VIDEO_WIDTH";
    public static final String EXTRA_VIDEO_HEIGHT = "VIDEO_HEIGHT";
    public static final String EXTRA_VIDEO_FPS = "VIDEO_FPS";
    public static final String EXTRA_VIDEO_BITRATE = "VIDEO_BITRATE";
    public static final String EXTRA_AUDIO_BITRATE = "AUDIO_BITRATE";
    private static final String TAG = RTCCallActivity.class.getSimpleName();
    private static final String TOPIC = "TOPIC";
    private static final String CALL_ICES = "CALL_ICES";
    private static final String INITIATOR = "INITIATOR";
    private static final int DISCONNECT_TIMEOUT = 2500;
    private static final int REQUEST_AUDIO_CAPTURE = 2;
    private static final int REQUEST_MODIFY_AUDIO_SETTINGS = 3;
    private final AtomicBoolean disconnect = new AtomicBoolean(false);
    private final ProxyVideoSink remoteProxyRenderer = new ProxyVideoSink();
    private final ProxyVideoSink localProxyVideoSink = new ProxyVideoSink();
    private final List<VideoSink> remoteSinks = new ArrayList<VideoSink>();
    FloatingActionButton fab_toggle_mic;
    @Nullable
    private RTCPeerConnection peerConnectionClient;
    @Nullable
    private RTCClient appRtcClient;
    @Nullable
    private RTCAudioManager audioManager;
    private RTCPeerConnection.PeerConnectionParameters peerConnectionParameters;
    private boolean micEnabled = true;
    private boolean speakerEnabled = true;
    private boolean initiator;
    private long mLastClickTime = 0L;
    private String topic;
    private List<PeerConnection.IceServer> peerIceServers = new ArrayList<PeerConnection.IceServer>();
    private FloatingActionButton fab_toggle_speaker;
    private FloatingActionButton fab_hangup;
    private RTCCallDialogFragment callDialog;
    private Chronometer chronometer;

    public static void createCallNotification(@NonNull Context context, @NonNull String topic, @Nullable String[] ices) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, "RTC_CHANNEL_ID");
        builder.setContentTitle((CharSequence)context.getString(R.string.incoming_call));
        builder.setSmallIcon(R.drawable.phone);
        builder.setPriority(1);
        Intent intent = RTCCallActivity.createIntent(context, topic, ices, false);
        intent.setAction(ACTION_INCOMING_CALL);
        intent.setFlags(0x10000000);
        TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)context);
        stackBuilder.addNextIntentWithParentStack(intent);
        int requestID = (int)System.currentTimeMillis();
        PendingIntent pendingIntent = stackBuilder.getPendingIntent(requestID, 0x8000000);
        int timeout = Preferences.getConnectionTimeout((Context)context) * 1000;
        builder.setTimeoutAfter((long)timeout);
        builder.setContentIntent(pendingIntent);
        builder.setVisibility(1);
        builder.setAutoCancel(true);
        builder.setCategory("call");
        builder.setFullScreenIntent(pendingIntent, true);
        Notification notification = builder.build();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.notify(100, notification);
        }
    }

    public static Intent createIntent(@NonNull Context context, @NonNull String topic, @Nullable String[] ices, boolean initiator) {
        Preconditions.checkNotNull((Object)context);
        Intent intent = new Intent(context, RTCCallActivity.class);
        intent.putExtra(TOPIC, topic);
        intent.putExtra(INITIATOR, initiator);
        intent.putExtra(CALL_ICES, ices);
        intent.putExtra(EXTRA_VIDEO_WIDTH, 0);
        intent.putExtra(EXTRA_VIDEO_HEIGHT, 0);
        intent.putExtra(EXTRA_VIDEO_FPS, 0);
        intent.putExtra(EXTRA_VIDEO_BITRATE, 0);
        intent.putExtra(EXTRA_AUDIO_BITRATE, 0);
        return intent;
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.handleActionIntents(intent);
    }

    protected void onResume() {
        super.onResume();
        this.hideSystemUI();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.hideSystemUI();
        this.setContentView(R.layout.activity_call);
        Intent intent = this.getIntent();
        this.topic = intent.getStringExtra(TOPIC);
        String[] ices = intent.getStringArrayExtra(CALL_ICES);
        PeerConnection.IceServer peerIceServer = PeerConnection.IceServer.builder((String)"stun:stun.l.google.com:19302").createIceServer();
        this.peerIceServers.add(peerIceServer);
        if (ices != null) {
            for (String turn : ices) {
                this.peerIceServers.add(PeerConnection.IceServer.builder((String)turn).createIceServer());
            }
        }
        this.initiator = intent.getBooleanExtra(INITIATOR, true);
        this.chronometer = (Chronometer)this.findViewById(R.id.chronometer);
        this.remoteSinks.add(this.remoteProxyRenderer);
        EglBase eglBase = EglBase.create();
        int videoWidth = intent.getIntExtra(EXTRA_VIDEO_WIDTH, 0);
        int videoHeight = intent.getIntExtra(EXTRA_VIDEO_HEIGHT, 0);
        String audioCodec = Preferences.getAudioCodec((Context)this.getApplicationContext());
        String videoCodec = Preferences.getVideoCodec((Context)this.getApplicationContext());
        boolean audioProcessingEnabled = Preferences.isAudioProcessingEnabled((Context)this.getApplicationContext());
        boolean openSlES = Preferences.isOpenSlESEnabled((Context)this.getApplicationContext());
        boolean aec = Preferences.isAcousticEchoCancelerEnabled((Context)this.getApplicationContext());
        boolean agc = Preferences.isAutomaticGainControlEnabled((Context)this.getApplicationContext());
        boolean hns = Preferences.isHardwareNoiseSuppressorEnabled((Context)this.getApplicationContext());
        this.peerConnectionParameters = new RTCPeerConnection.PeerConnectionParameters(false, false, false, videoWidth, videoHeight, intent.getIntExtra(EXTRA_VIDEO_FPS, 0), intent.getIntExtra(EXTRA_VIDEO_BITRATE, 0), videoCodec, false, false, intent.getIntExtra(EXTRA_AUDIO_BITRATE, 0), audioCodec, !audioProcessingEnabled, false, openSlES, !aec, !agc, !hns, !agc, false, null);
        this.appRtcClient = new RTCClient(this.topic, this);
        this.peerConnectionClient = new RTCPeerConnection(this.getApplicationContext(), eglBase, this.peerConnectionParameters, this);
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        this.peerConnectionClient.createPeerConnectionFactory(options);
        this.audioManager = RTCAudioManager.create(this.getApplicationContext(), RTCAudioManager.AudioDevice.SPEAKER_PHONE);
        this.audioManager.start((audioDevice, availableAudioDevices) -> {});
        this.fab_hangup = (FloatingActionButton)this.findViewById(R.id.fab_hangup);
        this.fab_hangup.setOnClickListener(view -> {
            if (SystemClock.elapsedRealtime() - this.mLastClickTime < 1000L) {
                return;
            }
            this.mLastClickTime = SystemClock.elapsedRealtime();
            Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
            Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.disconnect));
            RTCSession.getInstance().emitSessionClose(this.getApplicationContext(), this.topic);
            this.disconnect(2500L, true);
        });
        this.fab_toggle_speaker = (FloatingActionButton)this.findViewById(R.id.fab_toggle_speaker);
        this.fab_toggle_speaker.setOnClickListener(view -> {
            if (SystemClock.elapsedRealtime() - this.mLastClickTime < 1000L) {
                return;
            }
            this.mLastClickTime = SystemClock.elapsedRealtime();
            this.onToggleSpeaker();
        });
        if (this.speakerEnabled) {
            this.audioManager.setDefaultAudioDevice(RTCAudioManager.AudioDevice.SPEAKER_PHONE);
            this.fab_toggle_speaker.setImageResource(R.drawable.volume_high);
        } else {
            this.audioManager.setDefaultAudioDevice(RTCAudioManager.AudioDevice.EARPIECE);
            this.fab_toggle_speaker.setImageResource(R.drawable.volume_medium);
        }
        this.fab_toggle_mic = (FloatingActionButton)this.findViewById(R.id.fab_toggle_mic);
        this.fab_toggle_mic.setOnClickListener(view -> {
            if (SystemClock.elapsedRealtime() - this.mLastClickTime < 1000L) {
                return;
            }
            this.mLastClickTime = SystemClock.elapsedRealtime();
            boolean enabled = this.onToggleMic();
            if (enabled) {
                this.fab_toggle_mic.setImageResource(R.drawable.microphone);
            } else {
                this.fab_toggle_mic.setImageResource(R.drawable.microphone_off);
            }
        });
        EventViewModel eventViewModel = (EventViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(EventViewModel.class);
        eventViewModel.getInfo().observe((LifecycleOwner)this, event -> {
            try {
                if (event != null) {
                    eventViewModel.removeEvent(event);
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        });
        this.handleActionIntents(intent);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.cancel(100);
        }
        this.onEnableFabs(false);
    }

    private void handleActionIntents(Intent intent) {
        if (intent != null && intent.getAction() != null) {
            String topic;
            if (intent.getAction().equals(ACTION_INCOMING_CALL) && (topic = intent.getStringExtra(TOPIC)) != null && !topic.isEmpty()) {
                this.receiveUserCall();
                intent.removeExtra(TOPIC);
            }
            if (intent.getAction().equals(ACTION_OUTGOING_CALL) && (topic = intent.getStringExtra(TOPIC)) != null && !topic.isEmpty()) {
                this.userCall();
                intent.removeExtra(TOPIC);
            }
        }
    }

    private void userCall() {
        RTCSession.getInstance().setBusy(true);
        RTCSession.connectTopic(this.getApplicationContext(), this.topic);
        this.callDialog = RTCCallDialogFragment.newInstance(this.topic, false);
        this.callDialog.show(this.getSupportFragmentManager(), RTCCallDialogFragment.TAG);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.hideSystemUI();
    }

    private void hideSystemUI() {
        this.getWindow().getDecorView().setSystemUiVisibility(3846);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 2: {
                int len = permissions.length;
                for (int i = 0; i < len; ++i) {
                    if (grantResults[i] == -1) {
                        Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
                        Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.permission_audio_denied));
                        RTCSession.getInstance().emitSessionClose(this.getApplicationContext(), this.topic);
                        this.disconnect(2500L, true);
                    }
                    if (grantResults[i] != 0) continue;
                    this.receiveUserCall();
                }
                break;
            }
            case 3: {
                int len = permissions.length;
                for (int i = 0; i < len; ++i) {
                    if (grantResults[i] == -1) {
                        Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
                        Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.permission_audio_settings_denied));
                        RTCSession.getInstance().emitSessionClose(this.getApplicationContext(), this.topic);
                        this.disconnect(2500L, true);
                    }
                    if (grantResults[i] != 0) continue;
                    this.receiveUserCall();
                }
                break;
            }
        }
    }

    public void receiveUserCall() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.RECORD_AUDIO") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.RECORD_AUDIO"}, (int)2);
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.MODIFY_AUDIO_SETTINGS") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.MODIFY_AUDIO_SETTINGS"}, (int)3);
            return;
        }
        RTCCallingDialogFragment.newInstance(this.topic, false).show(this.getSupportFragmentManager(), RTCCallingDialogFragment.TAG);
    }

    public void onStop() {
        super.onStop();
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.stopVideoSource();
        }
    }

    public void onStart() {
        super.onStart();
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.startVideoSource();
        }
    }

    protected void onDestroy() {
        if (!this.disconnect.get()) {
            RTCSession.getInstance().emitSessionClose(this.getApplicationContext(), this.topic);
            this.disconnect(0L, true);
        }
        super.onDestroy();
    }

    public boolean onToggleMic() {
        if (this.peerConnectionClient != null) {
            this.micEnabled = !this.micEnabled;
            this.peerConnectionClient.setAudioEnabled(this.micEnabled);
        }
        return this.micEnabled;
    }

    public void onEnableFabs(boolean enabled) {
        this.fab_toggle_speaker.setEnabled(enabled);
        this.fab_hangup.setEnabled(enabled);
        this.fab_toggle_mic.setEnabled(enabled);
    }

    public void onToggleSpeaker() {
        if (this.audioManager != null) {
            boolean bl = this.speakerEnabled = !this.speakerEnabled;
            if (this.speakerEnabled) {
                this.audioManager.setDefaultAudioDevice(RTCAudioManager.AudioDevice.SPEAKER_PHONE);
                this.fab_toggle_speaker.setImageResource(R.drawable.volume_high);
            } else {
                this.audioManager.setDefaultAudioDevice(RTCAudioManager.AudioDevice.EARPIECE);
                this.fab_toggle_speaker.setImageResource(R.drawable.volume_medium);
            }
        }
    }

    private void disconnect(long timeout, boolean closeCallDialog) {
        this.onEnableFabs(false);
        this.chronometer.stop();
        if (!this.disconnect.getAndSet(true)) {
            if (closeCallDialog) {
                this.closeCallDialog();
            }
            this.remoteProxyRenderer.setTarget(null);
            this.localProxyVideoSink.setTarget(null);
            if (this.appRtcClient != null) {
                this.appRtcClient = null;
            }
            if (this.peerConnectionClient != null) {
                this.peerConnectionClient.close();
                this.peerConnectionClient = null;
            }
            if (this.audioManager != null) {
                this.audioManager.stop();
                this.audioManager = null;
            }
            RTCSession.getInstance().setBusy(false);
            if (timeout > 0L) {
                new Handler().postDelayed(() -> ((RTCCallActivity)this).finish(), timeout);
            } else {
                this.finish();
            }
        }
    }

    private void closeCallDialog() {
        try {
            if (this.callDialog != null) {
                this.callDialog.dismiss();
                this.callDialog = null;
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void onChannelOffer(@NonNull SessionDescription offerSdp) {
        Preconditions.checkNotNull((Object)offerSdp);
        this.runOnUiThread(() -> {
            try {
                Preconditions.checkNotNull((Object)this.peerConnectionClient);
                this.peerConnectionClient.createPeerConnection((VideoSink)this.localProxyVideoSink, this.remoteSinks, null, this.peerIceServers);
                this.peerConnectionClient.setRemoteDescription(offerSdp);
                this.peerConnectionClient.createAnswer();
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    @Override
    public void onRemoteDescription(@NonNull SessionDescription sdp) {
        this.runOnUiThread(() -> {
            if (this.peerConnectionClient == null) {
                return;
            }
            this.peerConnectionClient.setRemoteDescription(sdp);
            if (!this.initiator) {
                this.peerConnectionClient.createAnswer();
            }
        });
    }

    @Override
    public void onRemoteIceCandidate(IceCandidate candidate) {
        this.runOnUiThread(() -> {
            if (this.peerConnectionClient != null) {
                this.peerConnectionClient.addRemoteIceCandidate(candidate);
            }
        });
    }

    @Override
    public void onRemoteIceCandidateRemoved(IceCandidate candidate) {
        this.runOnUiThread(() -> {
            if (this.peerConnectionClient != null) {
                IceCandidate[] candidates = new IceCandidate[]{candidate};
                this.peerConnectionClient.removeRemoteIceCandidates(candidates);
            }
        });
    }

    @Override
    public void onChannelClose() {
        Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
        Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.disconnect));
        this.runOnUiThread(() -> this.disconnect(2500L, true));
    }

    @Override
    public void onChannelBusy() {
        Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
        Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.call_busy));
        this.runOnUiThread(() -> this.disconnect(2500L, true));
    }

    @Override
    public void onChannelTimeout() {
        Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
        Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.call_timeout));
        this.runOnUiThread(() -> this.disconnect(2500L, true));
    }

    @Override
    public void onChannelReject() {
        Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
        Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.call_busy));
        this.runOnUiThread(() -> this.disconnect(2500L, true));
    }

    @Override
    public void onChannelAccepted(@Nullable String[] ices) {
        this.runOnUiThread(() -> {
            try {
                if (ices != null) {
                    for (String turn : ices) {
                        this.peerIceServers.add(PeerConnection.IceServer.builder((String)turn).createIceServer());
                    }
                }
                Preconditions.checkNotNull((Object)this.peerConnectionClient);
                this.peerConnectionClient.createPeerConnection((VideoSink)this.localProxyVideoSink, this.remoteSinks, null, this.peerIceServers);
                this.peerConnectionClient.createOffer();
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    @Override
    public void onLocalDescription(SessionDescription sdp) {
        if (this.appRtcClient != null) {
            if (this.initiator) {
                this.appRtcClient.sendOfferSdp(this.getApplicationContext(), sdp);
            } else {
                this.appRtcClient.sendAnswerSdp(this.getApplicationContext(), sdp);
            }
        }
        this.runOnUiThread(() -> {
            if (this.peerConnectionParameters.videoMaxBitrate > 0 && this.peerConnectionClient != null) {
                this.peerConnectionClient.setVideoMaxBitrate(this.peerConnectionParameters.videoMaxBitrate);
            }
        });
    }

    @Override
    public void onIceCandidate(IceCandidate candidate) {
        if (this.appRtcClient != null) {
            this.appRtcClient.sendLocalIceCandidate(this.getApplicationContext(), candidate);
        }
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
        if (this.appRtcClient != null) {
            this.appRtcClient.sendLocalIceCandidateRemovals(this.getApplicationContext(), candidates);
        }
    }

    @Override
    public void onIceConnected() {
    }

    @Override
    public void onIceDisconnected() {
    }

    @Override
    public void onConnected() {
        this.runOnUiThread(() -> {
            this.onEnableFabs(true);
            this.onToggleSpeaker();
            this.closeCallDialog();
            this.chronometer.setVisibility(0);
            this.chronometer.setBase(SystemClock.elapsedRealtime());
            this.chronometer.start();
        });
    }

    @Override
    public void onDisconnected() {
        this.runOnUiThread(() -> this.disconnect(2500L, true));
    }

    @Override
    public void onPeerConnectionClosed() {
        this.runOnUiThread(() -> this.disconnect(2500L, true));
    }

    @Override
    public void onPeerConnectionError(String description) {
    }

    @Override
    public void acceptCall(@NonNull String topic) {
        Preconditions.checkNotNull((Object)topic);
        try {
            this.runOnUiThread(() -> this.onEnableFabs(true));
            RTCSession.getInstance().emitSessionAccept(this.getApplicationContext(), topic);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void rejectCall(@NonNull String topic) {
        Preconditions.checkNotNull((Object)topic);
        try {
            this.runOnUiThread(() -> this.onEnableFabs(true));
            Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
            Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.disconnect));
            RTCSession.getInstance().emitSessionReject(this.getApplicationContext(), topic);
            this.disconnect(2500L, true);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
        finally {
            RTCSession.getInstance().setBusy(false);
        }
    }

    @Override
    public void abortCall(@NonNull String topic) {
        Preconditions.checkNotNull((Object)topic);
        try {
            this.runOnUiThread(() -> this.onEnableFabs(true));
            Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
            Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.disconnect));
            RTCSession.getInstance().emitSessionClose(this.getApplicationContext(), topic);
            this.disconnect(2500L, false);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
        finally {
            RTCSession.getInstance().setBusy(false);
        }
    }

    @Override
    public void timeoutCall(@NonNull String topic) {
        Preconditions.checkNotNull((Object)topic);
        try {
            this.runOnUiThread(() -> this.onEnableFabs(true));
            Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
            Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.timeout_call));
            RTCSession.getInstance().emitSessionTimeout(this.getApplicationContext(), topic);
            this.runOnUiThread(() -> this.disconnect(2500L, false));
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void failCall(@NonNull String topic) {
        Preconditions.checkNotNull((Object)topic);
        try {
            this.runOnUiThread(() -> this.onEnableFabs(true));
            Singleton singleton = Singleton.getInstance((Context)this.getApplicationContext());
            Preferences.info((THREADS)singleton.getThreads(), (String)this.getString(R.string.call_fail));
            this.runOnUiThread(() -> this.disconnect(2500L, false));
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static class ProxyVideoSink
    implements VideoSink {
        private VideoSink target;

        private ProxyVideoSink() {
        }

        public synchronized void onFrame(VideoFrame frame) {
            if (this.target == null) {
                return;
            }
            this.target.onFrame(frame);
        }

        synchronized void setTarget(VideoSink target) {
            this.target = target;
        }
    }
}

