/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;
import threads.webrtc.RTCSession;

public class RTCClient
implements RTCSession.Listener {
    private final SignalingEvents events;
    private final String topic;

    public RTCClient(@NonNull String topic, @NonNull SignalingEvents events) {
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)events);
        this.events = events;
        this.topic = topic;
        RTCSession.getInstance().setListener(this);
    }

    @Override
    public void busy(@NonNull String pid) {
        this.events.onChannelBusy();
    }

    @Override
    public void accept(@NonNull String pid, @Nullable String[] ices) {
        this.events.onChannelAccepted(ices);
    }

    @Override
    public void reject(@NonNull String pid) {
        this.events.onChannelReject();
    }

    @Override
    public void offer(@NonNull String pid, @NonNull String sdp) {
        Preconditions.checkNotNull((Object)sdp);
        this.events.onChannelOffer(new SessionDescription(SessionDescription.Type.OFFER, sdp));
    }

    @Override
    public void answer(@NonNull String pid, @NonNull String sdp, @NonNull String type) {
        Preconditions.checkNotNull((Object)sdp);
        Preconditions.checkNotNull((Object)type);
        this.events.onRemoteDescription(new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), sdp));
    }

    @Override
    public void candidate(@NonNull String pid, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        Preconditions.checkNotNull((Object)sdp);
        Preconditions.checkNotNull((Object)mid);
        Preconditions.checkNotNull((Object)index);
        this.events.onRemoteIceCandidate(new IceCandidate(mid, Integer.valueOf(index).intValue(), sdp));
    }

    @Override
    public void candidate_remove(@NonNull String topic, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        Preconditions.checkNotNull((Object)sdp);
        Preconditions.checkNotNull((Object)mid);
        Preconditions.checkNotNull((Object)index);
        this.events.onRemoteIceCandidateRemoved(new IceCandidate(mid, Integer.valueOf(index).intValue(), sdp));
    }

    @Override
    public void close(@NonNull String pid) {
        this.events.onChannelClose();
    }

    @Override
    public void timeout(@NonNull String pid) {
        this.events.onChannelTimeout();
    }

    public void sendOfferSdp(@NonNull Context context, @NonNull SessionDescription sdp) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)sdp);
        RTCSession.getInstance().emitSessionOffer(context, this.topic, sdp);
    }

    public void sendAnswerSdp(@NonNull Context context, @NonNull SessionDescription sdp) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)sdp);
        RTCSession.getInstance().emitSessionAnswer(context, this.topic, sdp);
    }

    public void sendLocalIceCandidate(@NonNull Context context, @NonNull IceCandidate candidate) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)candidate);
        RTCSession.getInstance().emitIceCandidate(context, this.topic, candidate);
    }

    public void sendLocalIceCandidateRemovals(@NonNull Context context, @Nullable IceCandidate[] candidates) {
        Preconditions.checkNotNull((Object)context);
        if (candidates != null) {
            RTCSession.getInstance().emitIceCandidatesRemove(context, this.topic, candidates);
        }
    }

    public static interface SignalingEvents {
        public void onChannelOffer(SessionDescription var1);

        public void onRemoteDescription(SessionDescription var1);

        public void onRemoteIceCandidate(IceCandidate var1);

        public void onRemoteIceCandidateRemoved(IceCandidate var1);

        public void onChannelClose();

        public void onChannelBusy();

        public void onChannelTimeout();

        public void onChannelReject();

        public void onChannelAccepted(@Nullable String[] var1);
    }
}

