/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;
import threads.core.ConnectService;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.PeerInfo;
import threads.core.api.User;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.webrtc.R;
import threads.webrtc.RTCCallActivity;
import threads.webrtc.RTCVideoCallActivity;

public class RTCSession {
    public static final String RTC_CHANNEL_ID = "RTC_CHANNEL_ID";
    public static final int RTC_CALL_ID = 100;
    private static final int PUBSUB_TIMEOUT = 50;
    private static final String TAG = RTCSession.class.getSimpleName();
    private static final Gson gson = new Gson();
    private static RTCSession INSTANCE = new RTCSession();
    private final AtomicBoolean busy = new AtomicBoolean(false);
    @Nullable
    private Listener listener = null;

    private RTCSession() {
    }

    public static void createRTCChannel(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                String name = context.getString(R.string.rtc_channel_name);
                String description = context.getString(R.string.rtc_channel_description);
                int importance = 4;
                NotificationChannel mChannel = new NotificationChannel(RTC_CHANNEL_ID, (CharSequence)name, importance);
                mChannel.setDescription(description);
                mChannel.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + R.raw.incoming)), new AudioAttributes.Builder().setContentType(4).setLegacyStreamType(0).setUsage(2).build());
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                if (notificationManager != null) {
                    notificationManager.createNotificationChannel(mChannel);
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public static RTCSession getInstance() {
        return INSTANCE;
    }

    public static void handleContent(@NonNull Context context, @NonNull String aesKey, @NonNull PID senderPid, @NonNull Content content) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)senderPid);
        Preconditions.checkNotNull((Object)content);
        try {
            THREADS threadsAPI = Singleton.getInstance((Context)context).getThreads();
            String est = (String)content.get((Object)"est");
            Event type = Event.valueOf(est);
            switch (type) {
                case SESSION_VIDEO_CALL: {
                    if (RTCSession.getInstance().isBusy()) {
                        RTCSession.getInstance().emitSessionBusy(context, senderPid);
                        break;
                    }
                    User user = threadsAPI.getUserByPID(senderPid);
                    String name = senderPid.getPid();
                    if (user != null) {
                        name = user.getAlias();
                    }
                    String adds = (String)content.get((Object)"ices");
                    String[] ices = null;
                    if (adds != null) {
                        Addresses addresses = Addresses.toAddresses((String)adds);
                        ices = RTCSession.getInstance().turnUris(addresses);
                    }
                    RTCVideoCallActivity.createVideoCallNotification(context, aesKey, senderPid.getPid(), name, ices);
                    break;
                }
                case SESSION_CALL: {
                    if (RTCSession.getInstance().isBusy()) {
                        RTCSession.getInstance().emitSessionBusy(context, senderPid);
                        break;
                    }
                    User user = threadsAPI.getUserByPID(senderPid);
                    String name = senderPid.getPid();
                    if (user != null) {
                        name = user.getAlias();
                    }
                    String adds = (String)content.get((Object)"ices");
                    String[] ices = null;
                    if (adds != null) {
                        Addresses addresses = Addresses.toAddresses((String)adds);
                        ices = RTCSession.getInstance().turnUris(addresses);
                    }
                    RTCCallActivity.createCallNotification(context, aesKey, senderPid.getPid(), name, ices);
                    break;
                }
                case SESSION_TIMEOUT: {
                    RTCSession.getInstance().timeout(senderPid);
                    NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                    if (notificationManager == null) break;
                    notificationManager.cancel(100);
                    break;
                }
                case SESSION_BUSY: {
                    RTCSession.getInstance().busy(senderPid);
                    NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                    if (notificationManager == null) break;
                    notificationManager.cancel(100);
                    break;
                }
                case SESSION_ACCEPT: {
                    String[] ices = null;
                    String adds = (String)content.get((Object)"ices");
                    if (adds != null) {
                        Addresses addresses = Addresses.toAddresses((String)adds);
                        ices = RTCSession.getInstance().turnUris(addresses);
                    }
                    RTCSession.getInstance().accept(senderPid, ices);
                    break;
                }
                case SESSION_REJECT: {
                    RTCSession.getInstance().reject(senderPid);
                    break;
                }
                case SESSION_OFFER: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    RTCSession.getInstance().offer(senderPid, sdp);
                    break;
                }
                case SESSION_ANSWER: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    String esk = (String)content.get((Object)"type");
                    Preconditions.checkNotNull((Object)esk);
                    RTCSession.getInstance().answer(senderPid, sdp, esk);
                    break;
                }
                case SESSION_CANDIDATE_REMOVE: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    String mid = (String)content.get((Object)"MID");
                    Preconditions.checkNotNull((Object)mid);
                    String index = (String)content.get((Object)"INDEX");
                    Preconditions.checkNotNull((Object)index);
                    RTCSession.getInstance().candidate_remove(senderPid, sdp, mid, index);
                    break;
                }
                case SESSION_CANDIDATE: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    String mid = (String)content.get((Object)"MID");
                    Preconditions.checkNotNull((Object)mid);
                    String index = (String)content.get((Object)"INDEX");
                    Preconditions.checkNotNull((Object)index);
                    RTCSession.getInstance().candidate(senderPid, sdp, mid, index);
                    break;
                }
                case SESSION_CLOSE: {
                    RTCSession.getInstance().close(senderPid);
                    NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                    if (notificationManager == null) break;
                    notificationManager.cancel(100);
                    break;
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static boolean shouldRun(long start, long timeout) {
        Preconditions.checkArgument((start > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        long passedTime = System.currentTimeMillis() - start;
        return passedTime < timeout;
    }

    public static boolean connectUserTimeout(@NonNull Context context, @NonNull PID user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        int timeout = Preferences.getConnectionTimeout((Context)context);
        return ConnectService.connectPeer((Context)context, (PID)user, (String)aesKey, (boolean)true, (boolean)true, (int)timeout);
    }

    @Nullable
    public String[] turnUris(@Nullable Addresses addresses) {
        if (addresses == null) {
            return null;
        }
        Collection values = addresses.values();
        ArrayList<String> uris = new ArrayList<String>();
        for (String address : values) {
            try {
                String[] parts = address.split("/");
                String protocol = parts[3];
                if (protocol.equals("udp")) {
                    uris.add("stun:" + parts[2] + ":" + parts[4] + "?transport=udp");
                    continue;
                }
                uris.add("stun:" + parts[2] + ":" + parts[4]);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()));
            }
        }
        return uris.toArray(new String[uris.size()]);
    }

    public void emitSessionAnswer(@NonNull Context context, @NonNull PID user, @NonNull SessionDescription message) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)message);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_ANSWER.name());
                map.put("SDP", message.description);
                map.put("type", message.type.name());
                ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void busy(@NonNull PID pid) {
        if (this.listener != null) {
            this.listener.busy(pid);
        }
    }

    public void accept(@NonNull PID pid, @Nullable String[] ices) {
        if (this.listener != null) {
            this.listener.accept(pid, ices);
        }
    }

    public void close(@NonNull PID pid) {
        if (this.listener != null) {
            this.listener.close(pid);
        }
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void reject(@NonNull PID pid) {
        if (this.listener != null) {
            this.listener.reject(pid);
        }
    }

    public void offer(@NonNull PID pid, @NonNull String sdp) {
        if (this.listener != null) {
            this.listener.offer(pid, sdp);
        }
    }

    public void answer(@NonNull PID pid, @NonNull String sdp, @NonNull String type) {
        if (this.listener != null) {
            this.listener.answer(pid, sdp, type);
        }
    }

    public void candidate(@NonNull PID pid, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        if (this.listener != null) {
            this.listener.candidate(pid, sdp, mid, index);
        }
    }

    public void candidate_remove(@NonNull PID pid, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        if (this.listener != null) {
            this.listener.candidate_remove(pid, sdp, mid, index);
        }
    }

    public void timeout(PID pid) {
        if (this.listener != null) {
            this.listener.timeout(pid);
        }
    }

    public void emitSessionOffer(@NonNull Context context, @NonNull PID user, @NonNull SessionDescription message) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)message);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_OFFER.name());
                map.put("SDP", message.description);
                ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void emitSessionVideoCall(@NonNull Context context, @NonNull PID host, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)user);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            THREADS threads = Singleton.getInstance((Context)context).getThreads();
            Preconditions.checkNotNull((Object)ipfs);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_VIDEO_CALL.name());
            PeerInfo peer = threads.getPeerInfoByPID(host);
            if (peer != null) {
                String addresses = Addresses.toString((Addresses)peer.getAddresses());
                map.put("ices", addresses);
            }
            ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionAlive(@NonNull Context context, @NonNull PID host, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)user);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_ALIVE.name());
            ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionCall(@NonNull Context context, @NonNull PID host, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)user);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            THREADS threads = Singleton.getInstance((Context)context).getThreads();
            Preconditions.checkNotNull((Object)ipfs);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_CALL.name());
            PeerInfo peer = threads.getPeerInfoByPID(host);
            if (peer != null) {
                String addresses = Addresses.toString((Addresses)peer.getAddresses());
                map.put("ices", addresses);
            }
            ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionBusy(@NonNull Context context, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_BUSY.name());
                ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void emitSessionTimeout(@NonNull Context context, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_TIMEOUT.name());
                ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void emitSessionReject(@NonNull Context context, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(() -> {
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("est", Event.SESSION_REJECT.name());
                    ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
                }
            });
        }
    }

    public void emitSessionAccept(@NonNull Context context, @NonNull PID host, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)user);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        THREADS threads = Singleton.getInstance((Context)context).getThreads();
        if (ipfs != null) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(() -> {
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("est", Event.SESSION_ACCEPT.name());
                    PeerInfo peer = threads.getPeerInfoByPID(host);
                    if (peer != null) {
                        String addresses = Addresses.toString((Addresses)peer.getAddresses());
                        map.put("ices", addresses);
                    }
                    ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
                }
            });
        }
    }

    public void emitSessionClose(@NonNull Context context, @NonNull PID user) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_CLOSE.name());
                ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void emitIceCandidatesRemove(@NonNull Context context, @NonNull PID user, @NonNull IceCandidate[] candidates) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)candidates);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                for (IceCandidate candidate : candidates) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("est", Event.SESSION_CANDIDATE_REMOVE.name());
                    map.put("SDP", candidate.sdp);
                    map.put("MID", candidate.sdpMid);
                    map.put("INDEX", String.valueOf(candidate.sdpMLineIndex));
                    ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void emitIceCandidate(@NonNull Context context, @NonNull PID user, @NonNull IceCandidate candidate) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)candidate);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_CANDIDATE.name());
                map.put("SDP", candidate.sdp);
                map.put("MID", candidate.sdpMid);
                map.put("INDEX", String.valueOf(candidate.sdpMLineIndex));
                ipfs.pubsubPub(user.getPid(), gson.toJson(map), 50);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public boolean isBusy() {
        return this.busy.get();
    }

    public void setBusy(boolean flag) {
        this.busy.set(flag);
    }

    public static interface Listener {
        public void busy(@NonNull PID var1);

        public void accept(@NonNull PID var1, @Nullable String[] var2);

        public void reject(@NonNull PID var1);

        public void offer(@NonNull PID var1, @NonNull String var2);

        public void answer(@NonNull PID var1, @NonNull String var2, @NonNull String var3);

        public void candidate(@NonNull PID var1, @NonNull String var2, @NonNull String var3, @NonNull String var4);

        public void candidate_remove(@NonNull PID var1, @NonNull String var2, @NonNull String var3, @NonNull String var4);

        public void close(@NonNull PID var1);

        public void timeout(@NonNull PID var1);
    }

    public static enum Event {
        SESSION_CALL,
        SESSION_VIDEO_CALL,
        SESSION_ACCEPT,
        SESSION_BUSY,
        SESSION_REJECT,
        SESSION_OFFER,
        SESSION_TIMEOUT,
        SESSION_ANSWER,
        SESSION_CANDIDATE,
        SESSION_ALIVE,
        SESSION_CLOSE,
        SESSION_CANDIDATE_REMOVE;

    }
}

