/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import androidx.annotation.Nullable;
import java.util.List;
import java.util.Set;
import org.webrtc.ThreadUtils;
import threads.webrtc.RTCAudioManager;

public class RTCBluetoothManager {
    private static final String TAG = "RTCBluetoothManager";
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 2;
    private final Context apprtcContext;
    private final RTCAudioManager apprtcAudioManager;
    @Nullable
    private final AudioManager audioManager;
    private final Handler handler;
    private final BluetoothProfile.ServiceListener bluetoothServiceListener;
    private final BroadcastReceiver bluetoothHeadsetReceiver;
    int scoConnectionAttempts;
    private State bluetoothState;
    @Nullable
    private BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothHeadset bluetoothHeadset;
    @Nullable
    private BluetoothDevice bluetoothDevice;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            RTCBluetoothManager.this.bluetoothTimeout();
        }
    };

    protected RTCBluetoothManager(Context context, RTCAudioManager audioManager) {
        Log.d((String)TAG, (String)"ctor");
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.apprtcAudioManager = audioManager;
        this.audioManager = this.getAudioManager(context);
        this.bluetoothState = State.UNINITIALIZED;
        this.bluetoothServiceListener = new BluetoothServiceListener();
        this.bluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.handler = new Handler(Looper.getMainLooper());
    }

    static RTCBluetoothManager create(Context context, RTCAudioManager audioManager) {
        Log.d((String)TAG, (String)"create");
        return new RTCBluetoothManager(context, audioManager);
    }

    public State getState() {
        ThreadUtils.checkIsOnMainThread();
        return this.bluetoothState;
    }

    public void start() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"start");
        if (!this.hasPermission(this.apprtcContext, "android.permission.BLUETOOTH")) {
            Log.w((String)TAG, (String)("Process (pid=" + Process.myPid() + ") lacks BLUETOOTH permission"));
            return;
        }
        if (this.bluetoothState != State.UNINITIALIZED) {
            Log.w((String)TAG, (String)"Invalid BT state");
            return;
        }
        this.bluetoothHeadset = null;
        this.bluetoothDevice = null;
        this.scoConnectionAttempts = 0;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            Log.w((String)TAG, (String)"Device does not support Bluetooth");
            return;
        }
        if (!this.audioManager.isBluetoothScoAvailableOffCall()) {
            Log.e((String)TAG, (String)"Bluetooth SCO audio is not available off call");
            return;
        }
        this.logBluetoothAdapterInfo(this.bluetoothAdapter);
        if (!this.getBluetoothProfileProxy(this.apprtcContext, this.bluetoothServiceListener, 1)) {
            Log.e((String)TAG, (String)"BluetoothAdapter.getProfileProxy(HEADSET) failed");
            return;
        }
        IntentFilter bluetoothHeadsetFilter = new IntentFilter();
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        this.registerReceiver(this.bluetoothHeadsetReceiver, bluetoothHeadsetFilter);
        Log.d((String)TAG, (String)("HEADSET profile state: " + this.stateToString(this.bluetoothAdapter.getProfileConnectionState(1))));
        Log.d((String)TAG, (String)"Bluetooth proxy for headset profile has started");
        this.bluetoothState = State.HEADSET_UNAVAILABLE;
        Log.d((String)TAG, (String)("start done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    public void stop() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)("stop: BT state=" + (Object)((Object)this.bluetoothState)));
        if (this.bluetoothAdapter == null) {
            return;
        }
        this.stopScoAudio();
        if (this.bluetoothState == State.UNINITIALIZED) {
            return;
        }
        this.unregisterReceiver(this.bluetoothHeadsetReceiver);
        this.cancelTimer();
        if (this.bluetoothHeadset != null) {
            this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
            this.bluetoothHeadset = null;
        }
        this.bluetoothAdapter = null;
        this.bluetoothDevice = null;
        this.bluetoothState = State.UNINITIALIZED;
        Log.d((String)TAG, (String)("stop done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    public boolean startScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)("startSco: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn()));
        if (this.scoConnectionAttempts >= 2) {
            Log.e((String)TAG, (String)"BT SCO connection fails - no more attempts");
            return false;
        }
        if (this.bluetoothState != State.HEADSET_AVAILABLE) {
            Log.e((String)TAG, (String)"BT SCO connection fails - no headset available");
            return false;
        }
        Log.d((String)TAG, (String)"Starting Bluetooth SCO and waits for ACTION_AUDIO_STATE_CHANGED...");
        this.bluetoothState = State.SCO_CONNECTING;
        this.audioManager.startBluetoothSco();
        this.audioManager.setBluetoothScoOn(true);
        ++this.scoConnectionAttempts;
        this.startTimer();
        Log.d((String)TAG, (String)("startScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
        return true;
    }

    public void stopScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)("stopScoAudio: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
        if (this.bluetoothState != State.SCO_CONNECTING && this.bluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        this.audioManager.stopBluetoothSco();
        this.audioManager.setBluetoothScoOn(false);
        this.bluetoothState = State.SCO_DISCONNECTING;
        Log.d((String)TAG, (String)("stopScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
    }

    public void updateDevice() {
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d((String)TAG, (String)"updateDevice");
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.bluetoothDevice = null;
            this.bluetoothState = State.HEADSET_UNAVAILABLE;
            Log.d((String)TAG, (String)"No connected bluetooth headset");
        } else {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            this.bluetoothState = State.HEADSET_AVAILABLE;
            Log.d((String)TAG, (String)("Connected bluetooth headset: name=" + this.bluetoothDevice.getName() + ", state=" + this.stateToString(this.bluetoothHeadset.getConnectionState(this.bluetoothDevice)) + ", SCO audio=" + this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice)));
        }
        Log.d((String)TAG, (String)("updateDevice done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    @Nullable
    protected AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    protected void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    protected void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    protected boolean getBluetoothProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        return this.bluetoothAdapter.getProfileProxy(context, listener, profile);
    }

    protected boolean hasPermission(Context context, String permission2) {
        return this.apprtcContext.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @SuppressLint(value={"HardwareIds"})
    protected void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        Log.d((String)TAG, (String)("BluetoothAdapter: enabled=" + localAdapter.isEnabled() + ", state=" + this.stateToString(localAdapter.getState()) + ", name=" + localAdapter.getName() + ", address=" + localAdapter.getAddress()));
        Set pairedDevices = localAdapter.getBondedDevices();
        if (!pairedDevices.isEmpty()) {
            Log.d((String)TAG, (String)"paired devices:");
            for (BluetoothDevice device : pairedDevices) {
                Log.d((String)TAG, (String)(" name=" + device.getName() + ", address=" + device.getAddress()));
            }
        }
    }

    private void updateAudioDeviceState() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"updateAudioDeviceState");
        this.apprtcAudioManager.updateAudioDeviceState();
    }

    private void startTimer() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"startTimer");
        this.handler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    private void cancelTimer() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"cancelTimer");
        this.handler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private void bluetoothTimeout() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d((String)TAG, (String)("bluetoothTimeout: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn()));
        if (this.bluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.size() > 0) {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            if (this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice)) {
                Log.d((String)TAG, (String)("SCO connected with " + this.bluetoothDevice.getName()));
                scoConnected = true;
            } else {
                Log.d((String)TAG, (String)("SCO is not connected with " + this.bluetoothDevice.getName()));
            }
        }
        if (scoConnected) {
            this.bluetoothState = State.SCO_CONNECTED;
            this.scoConnectionAttempts = 0;
        } else {
            Log.w((String)TAG, (String)"BT failed to connect after timeout");
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
        Log.d((String)TAG, (String)("bluetoothTimeout done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    private boolean isScoOn() {
        return this.audioManager.isBluetoothScoOn();
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 3: {
                return "DISCONNECTING";
            }
            case 10: {
                return "OFF";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
        }
        return "INVALID";
    }

    private class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothHeadsetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (RTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                Log.d((String)RTCBluetoothManager.TAG, (String)("BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_CONNECTION_STATE_CHANGED, s=" + RTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)RTCBluetoothManager.this.bluetoothState)));
                if (state == 2) {
                    RTCBluetoothManager.this.scoConnectionAttempts = 0;
                    RTCBluetoothManager.this.updateAudioDeviceState();
                } else if (state != 1 && state != 3 && state == 0) {
                    RTCBluetoothManager.this.stopScoAudio();
                    RTCBluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                Log.d((String)RTCBluetoothManager.TAG, (String)("BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_AUDIO_STATE_CHANGED, s=" + RTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)RTCBluetoothManager.this.bluetoothState)));
                if (state == 12) {
                    RTCBluetoothManager.this.cancelTimer();
                    if (RTCBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                        Log.d((String)RTCBluetoothManager.TAG, (String)"+++ Bluetooth audio SCO is now connected");
                        RTCBluetoothManager.this.bluetoothState = State.SCO_CONNECTED;
                        RTCBluetoothManager.this.scoConnectionAttempts = 0;
                        RTCBluetoothManager.this.updateAudioDeviceState();
                    } else {
                        Log.w((String)RTCBluetoothManager.TAG, (String)"Unexpected state BluetoothHeadset.STATE_AUDIO_CONNECTED");
                    }
                } else if (state == 11) {
                    Log.d((String)RTCBluetoothManager.TAG, (String)"+++ Bluetooth audio SCO is now connecting...");
                } else if (state == 10) {
                    Log.d((String)RTCBluetoothManager.TAG, (String)"+++ Bluetooth audio SCO is now disconnected");
                    if (this.isInitialStickyBroadcast()) {
                        Log.d((String)RTCBluetoothManager.TAG, (String)"Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.");
                        return;
                    }
                    RTCBluetoothManager.this.updateAudioDeviceState();
                }
            }
            Log.d((String)RTCBluetoothManager.TAG, (String)("onReceive done: BT state=" + (Object)((Object)RTCBluetoothManager.this.bluetoothState)));
        }
    }

    private class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothServiceListener() {
        }

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1 || RTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            Log.d((String)RTCBluetoothManager.TAG, (String)("BluetoothServiceListener.onServiceConnected: BT state=" + (Object)((Object)RTCBluetoothManager.this.bluetoothState)));
            RTCBluetoothManager.this.bluetoothHeadset = (BluetoothHeadset)proxy;
            RTCBluetoothManager.this.updateAudioDeviceState();
            Log.d((String)RTCBluetoothManager.TAG, (String)("onServiceConnected done: BT state=" + (Object)((Object)RTCBluetoothManager.this.bluetoothState)));
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || RTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            Log.d((String)RTCBluetoothManager.TAG, (String)("BluetoothServiceListener.onServiceDisconnected: BT state=" + (Object)((Object)RTCBluetoothManager.this.bluetoothState)));
            RTCBluetoothManager.this.stopScoAudio();
            RTCBluetoothManager.this.bluetoothHeadset = null;
            RTCBluetoothManager.this.bluetoothDevice = null;
            RTCBluetoothManager.this.bluetoothState = State.HEADSET_UNAVAILABLE;
            RTCBluetoothManager.this.updateAudioDeviceState();
            Log.d((String)RTCBluetoothManager.TAG, (String)("onServiceDisconnected done: BT state=" + (Object)((Object)RTCBluetoothManager.this.bluetoothState)));
        }
    }

    public static enum State {
        UNINITIALIZED,
        ERROR,
        HEADSET_UNAVAILABLE,
        HEADSET_AVAILABLE,
        SCO_DISCONNECTING,
        SCO_CONNECTING,
        SCO_CONNECTED;

    }
}

