package threads.iota;

import androidx.annotation.NonNull;

import java.util.Objects;


public class Entity {

    @NonNull
    private final String hash;
    @NonNull
    private final String address;
    @NonNull
    private final String tag;
    @NonNull
    private final String content;

    Entity(@NonNull String hash,
           @NonNull String address,
           @NonNull String tag,
           @NonNull String content) {
        this.hash = hash;
        this.address = address;
        this.tag = tag;
        this.content = content;
    }


    @NonNull
    public String getContent() {
        return content;
    }

    @NonNull
    public String getTag() {
        return tag;
    }


    @NonNull
    public String getHash() {
        return hash;
    }


    @Override
    public int hashCode() {
        return Objects.hash(hash);
    }


    @NonNull
    public String getAddress() {
        return address;
    }


}