/*
 * Decompiled with CFR 0.152.
 */
package threads.iota;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.Room;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import threads.iota.Entity;
import threads.iota.Hash;
import threads.iota.HashDatabase;
import threads.iota.IOTA;

public class EntityService {
    private static final String TAG = EntityService.class.getSimpleName();
    private static EntityService SINGLETON = null;
    @NonNull
    private final HashDatabase hashDatabase;
    private static final String PREF_KEY = "prefKey";
    private static final String HOST_KEY = "hostKey";
    private static final String PORT_KEY = "portKey";
    private static final String PROTOCOL_KEY = "protocolKey";
    private static final String TANGLE_TIMEOUT_KEY = "tangleTimeoutKey";
    private static final String TANGLE_PROTOCOL = "https";
    private static final String TANGLE_HOST = "nodes.thetangle.org";
    private static final int TANGLE_PORT = 443;

    public static int getTanglePort(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(PORT_KEY, 443);
    }

    public static void setTanglePort(@NonNull Context context, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(PORT_KEY, timeout);
        editor.apply();
    }

    public static int getTangleTimeout(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(TANGLE_TIMEOUT_KEY, 30);
    }

    public static void setTangleTimeout(@NonNull Context context, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(TANGLE_TIMEOUT_KEY, timeout);
        editor.apply();
    }

    @NonNull
    public static String getTangleProtocol(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(PROTOCOL_KEY, TANGLE_PROTOCOL);
    }

    public static void setTangleProtocol(@NonNull Context context, @NonNull String token) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)token);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(PROTOCOL_KEY, token);
        editor.apply();
    }

    @NonNull
    public static String getTangleHost(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(HOST_KEY, TANGLE_HOST);
    }

    public static void setTangleHost(@NonNull Context context, @NonNull String token) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)token);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(HOST_KEY, token);
        editor.apply();
    }

    private EntityService(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        this.hashDatabase = (HashDatabase)Room.databaseBuilder((Context)context, HashDatabase.class, (String)HashDatabase.class.getSimpleName()).fallbackToDestructiveMigration().build();
    }

    @NonNull
    public static EntityService getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (SINGLETON == null) {
            SINGLETON = new EntityService(context);
        }
        return SINGLETON;
    }

    @NonNull
    public HashDatabase getHashDatabase() {
        return this.hashDatabase;
    }

    @NonNull
    public Entity insertData(@NonNull Context context, @NonNull String address, @NonNull String data) {
        int timeout = EntityService.getTangleTimeout(context);
        String protocol = EntityService.getTangleProtocol(context);
        int port = EntityService.getTanglePort(context);
        String host = EntityService.getTangleHost(context);
        IOTA iota = new IOTA.Builder().protocol(protocol).timeout(timeout).host(host).port(port).build();
        Entity entity = iota.insertTransaction(address, data);
        Hash transactionHash = this.createHash(entity.getHash());
        this.insertHash(transactionHash);
        return entity;
    }

    @NonNull
    public Entity insertData(@NonNull Context context, @NonNull String address, byte[] data) {
        int timeout = EntityService.getTangleTimeout(context);
        String protocol = EntityService.getTangleProtocol(context);
        int port = EntityService.getTanglePort(context);
        String host = EntityService.getTangleHost(context);
        IOTA iota = new IOTA.Builder().protocol(protocol).timeout(timeout).host(host).port(port).build();
        Entity entity = iota.setContent(address, data);
        Hash transactionHash = this.createHash(entity.getHash());
        this.insertHash(transactionHash);
        return entity;
    }

    @Nullable
    public Entity loadEntityByHash(@NonNull Context context, @NonNull String hash) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)hash);
        int timeout = EntityService.getTangleTimeout(context);
        String protocol = EntityService.getTangleProtocol(context);
        int port = EntityService.getTanglePort(context);
        String host = EntityService.getTangleHost(context);
        IOTA iota = new IOTA.Builder().protocol(protocol).timeout(timeout).host(host).port(port).build();
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        iota.loadHashTransactions(new IOTA.Filter(){

            @Override
            public boolean acceptHash(@NonNull String hash) {
                return true;
            }

            @Override
            public void invalidHash(@NonNull String hash) {
                Hash transactionHash = EntityService.this.createHash(hash);
                EntityService.this.insertHash(transactionHash);
            }

            @Override
            public boolean acceptEntity(@NonNull Entity entity) {
                boolean result2 = true;
                String hash = entity.getHash();
                if (EntityService.this.hasHash(hash)) {
                    result2 = false;
                } else {
                    Hash transactionHash = EntityService.this.createHash(hash);
                    EntityService.this.insertHash(transactionHash);
                }
                return result2;
            }

            @Override
            public void invalidEntity(@NonNull Entity entity) {
                Preconditions.checkNotNull((Object)entity);
                String hash = entity.getHash();
                Hash transactionHash = EntityService.this.createHash(hash);
                EntityService.this.insertHash(transactionHash);
            }

            @Override
            public void error(@NonNull Entity entity, @NonNull Throwable e) {
                String hash = entity.getHash();
                Hash transactionHash = EntityService.this.createHash(hash);
                EntityService.this.insertHash(transactionHash);
            }

            @Override
            public void loadEntity(@NonNull Entity entity) {
                result.set(entity);
            }
        }, hash);
        return result.get();
    }

    @NonNull
    public List<Entity> loadEntities(@NonNull Context context, @NonNull String address) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)address);
        int timeout = EntityService.getTangleTimeout(context);
        String protocol = EntityService.getTangleProtocol(context);
        int port = EntityService.getTanglePort(context);
        String host = EntityService.getTangleHost(context);
        IOTA iota = new IOTA.Builder().protocol(protocol).timeout(timeout).host(host).port(port).build();
        return this.loadEntities(iota, address);
    }

    @NonNull
    private List<Entity> loadEntities(@NonNull IOTA iota, @NonNull String address) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)address);
        final ArrayList<Entity> entities = new ArrayList<Entity>();
        iota.loadAddressTransactions(new IOTA.Filter(){

            @Override
            public boolean acceptHash(@NonNull String hash) {
                return !EntityService.this.hasHash(hash);
            }

            @Override
            public void invalidHash(@NonNull String hash) {
                Hash transactionHash = EntityService.this.createHash(hash);
                EntityService.this.insertHash(transactionHash);
            }

            @Override
            public boolean acceptEntity(@NonNull Entity entity) {
                boolean result = true;
                String hash = entity.getHash();
                if (EntityService.this.hasHash(hash)) {
                    result = false;
                } else {
                    Hash transactionHash = EntityService.this.createHash(hash);
                    EntityService.this.insertHash(transactionHash);
                }
                return result;
            }

            @Override
            public void loadEntity(@NonNull Entity entity) {
                entities.add(entity);
            }

            @Override
            public void invalidEntity(@NonNull Entity entity) {
                String hash = entity.getHash();
                Hash transactionHash = EntityService.this.createHash(hash);
                EntityService.this.insertHash(transactionHash);
            }

            @Override
            public void error(@NonNull Entity entity, @NonNull Throwable e) {
                String hash = entity.getHash();
                Hash transactionHash = EntityService.this.createHash(hash);
                EntityService.this.insertHash(transactionHash);
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }, address);
        return entities;
    }

    private boolean hasHash(@NonNull String hash) {
        return this.getHashDatabase().hashDao().hasHash(hash) > 0L;
    }

    private Hash createHash(@NonNull String hash) {
        Preconditions.checkNotNull((Object)hash);
        return new Hash(hash, System.currentTimeMillis());
    }

    private void insertHash(@NonNull Hash hash) {
        Preconditions.checkNotNull((Object)hash);
        this.getHashDatabase().hashDao().insertHash(hash);
    }
}

