/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Input;
import org.iota.jota.model.Transaction;
import org.iota.jota.pow.ICurl;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.InputValidator;
import org.iota.jota.utils.Signing;

public class IotaAPIUtils {
    public static String newAddress(String seed, int security, int index, boolean checksum, ICurl curl) throws ArgumentException {
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        Signing signing = new Signing(curl);
        int[] key = signing.key(Converter.trits(seed), index, security);
        int[] digests = signing.digests(key);
        int[] addressTrits = signing.address(digests);
        String address = Converter.trytes(addressTrits);
        if (checksum) {
            address = Checksum.addChecksum(address);
        }
        return address;
    }

    public static List<String> signInputsAndReturn(String seed, List<Input> inputs, Bundle bundle, List<String> signatureFragments, ICurl curl) throws ArgumentException {
        if (!InputValidator.isValidSeed(seed)) {
            throw new IllegalStateException("Invalid seed provided.");
        }
        if (!InputValidator.areValidInputsList(inputs)) {
            throw new ArgumentException("Invalid input provided.");
        }
        bundle.finalize(curl);
        bundle.addTrytes(signatureFragments);
        for (int i = bundle.getTransactions().size() - 1; i >= 0; --i) {
            if (bundle.getTransactions().get(i).getValue() >= 0L) continue;
            String thisAddress = bundle.getTransactions().get(i).getAddress();
            int keyIndex = 0;
            int keySecurity = 0;
            for (Input input : inputs) {
                if (!input.getAddress().subSequence(0, 81).equals(thisAddress.subSequence(0, 81))) continue;
                keyIndex = input.getKeyIndex();
                keySecurity = input.getSecurity();
            }
            String bundleHash = bundle.getTransactions().get(i).getBundle();
            int[] key = new Signing(curl).key(Converter.trits(seed), keyIndex, keySecurity);
            int[] normalizedBundleHash = bundle.normalizedBundle(bundleHash);
            for (int j = 0; j < keySecurity; ++j) {
                int hashPart = j % 3;
                if (!bundle.getTransactions().get(i + j).getAddress().equals(thisAddress)) {
                    throw new ArgumentException("Inconsistent security-level and transactions");
                }
                int[] keyFragment = Arrays.copyOfRange(key, 6561 * j, 6561 * (j + 1));
                int[] bundleFragment = Arrays.copyOfRange(normalizedBundleHash, 27 * hashPart, 27 * (hashPart + 1));
                int[] signedFragment = new Signing(curl).signatureFragment(bundleFragment, keyFragment);
                bundle.getTransactions().get(i + j).setSignatureFragments(Converter.trytes(signedFragment));
            }
        }
        ArrayList<String> bundleTrytes = new ArrayList<String>();
        for (Transaction tx : bundle.getTransactions()) {
            bundleTrytes.add(tx.toTrytes());
        }
        return bundleTrytes;
    }
}

