/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import java.util.ArrayList;
import java.util.Optional;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Transaction;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.Signing;

public class BundleValidator {
    public static boolean validateSignatures(Bundle bundle, ICurl customCurl) {
        for (int i = 0; i < bundle.getLength(); ++i) {
            Transaction tx = bundle.getTransactions().get(i);
            if (tx.getValue() >= 0L) continue;
            ArrayList<String> fragments = new ArrayList<String>();
            fragments.add(tx.getSignatureFragments());
            for (int j = i; j < bundle.getLength() - 1; ++j) {
                Transaction otherTx = bundle.getTransactions().get(j + 1);
                if (otherTx.getValue() != 0L || !otherTx.getAddress().equals(tx.getAddress())) continue;
                fragments.add(otherTx.getSignatureFragments());
            }
            boolean valid = new Signing(customCurl).validateSignatures(tx.getAddress(), fragments.toArray(new String[fragments.size()]), tx.getBundle());
            if (valid) continue;
            return false;
        }
        return true;
    }

    public static boolean isBundle(Bundle bundle) throws ArgumentException {
        return BundleValidator.isBundle(bundle, null);
    }

    public static boolean isBundle(Bundle bundle, Optional<SpongeFactory.Mode> customCurlMode) throws ArgumentException {
        ICurl curl = null;
        curl = null == customCurlMode || !customCurlMode.isPresent() ? SpongeFactory.create(SpongeFactory.Mode.KERL) : SpongeFactory.create(customCurlMode.get());
        int totalSum = 0;
        int lastIndex = bundle.getLength() - 1;
        for (int i = 0; i < bundle.getLength(); ++i) {
            Transaction tx = bundle.getTransactions().get(i);
            totalSum = (int)((long)totalSum + tx.getValue());
            if (tx.getCurrentIndex() != (long)i) {
                throw new ArgumentException("Invalid bundle.");
            }
            if (tx.getLastIndex() != (long)lastIndex) {
                throw new ArgumentException("Invalid bundle.");
            }
            int[] txTrits = Converter.trits(tx.toTrytes().substring(2187, 2349));
            curl.absorb(txTrits);
            if (tx.getValue() >= 0L) continue;
            ArrayList<String> fragments = new ArrayList<String>();
            fragments.add(tx.getSignatureFragments());
            for (int j = i; j < bundle.getLength() - 1; ++j) {
                Transaction tx2 = bundle.getTransactions().get(j + 1);
                if (!tx.getAddress().equals(tx2.getAddress()) || tx2.getValue() != 0L) continue;
                fragments.add(tx2.getSignatureFragments());
            }
            boolean valid = new Signing(curl.clone()).validateSignatures(tx.getAddress(), fragments.toArray(new String[fragments.size()]), tx.getBundle());
            if (valid) continue;
            throw new ArgumentException("Invalid signatures.");
        }
        if (totalSum != 0) {
            throw new ArgumentException("Invalid bundle sum.");
        }
        int[] bundleHashTrits = new int[243];
        curl.squeeze(bundleHashTrits, 0, 243);
        String bundleHash = Converter.trytes(bundleHashTrits);
        if (!bundleHash.equals(bundle.getTransactions().get(0).getBundle())) {
            throw new ArgumentException("Invalid bundle hash.");
        }
        return true;
    }
}

