/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.model;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.InputValidator;

public class Transaction {
    private transient ICurl customCurl;
    private String hash;
    private String signatureFragments;
    private String address;
    private long value;
    private String obsoleteTag;
    private long timestamp;
    private long currentIndex;
    private long lastIndex;
    private String bundle;
    private String trunkTransaction;
    private String branchTransaction;
    private String nonce;
    private Boolean persistence;
    private long attachmentTimestamp;
    private String tag;
    private long attachmentTimestampLowerBound;
    private long attachmentTimestampUpperBound;

    public Transaction(String signatureFragments, long currentIndex, long lastIndex, String nonce, String hash, String obsoleteTag, long timestamp, String trunkTransaction, String branchTransaction, String address, long value, String bundle, String tag, long attachmentTimestamp, long attachmentTimestampLowerBound, long attachmentTimestampUpperBound) {
        this();
        this.hash = hash;
        this.obsoleteTag = obsoleteTag;
        this.signatureFragments = signatureFragments;
        this.address = address;
        this.value = value;
        this.timestamp = timestamp;
        this.currentIndex = currentIndex;
        this.lastIndex = lastIndex;
        this.bundle = bundle;
        this.trunkTransaction = trunkTransaction;
        this.branchTransaction = branchTransaction;
        this.tag = tag;
        this.attachmentTimestamp = attachmentTimestamp;
        this.attachmentTimestampLowerBound = attachmentTimestampLowerBound;
        this.attachmentTimestampUpperBound = attachmentTimestampUpperBound;
        this.nonce = nonce;
    }

    public Transaction(String address, long value, String tag, long timestamp) {
        this();
        this.address = address;
        this.value = value;
        this.tag = tag;
        this.obsoleteTag = tag;
        this.timestamp = timestamp;
    }

    public Transaction(ICurl curl) {
        this.customCurl = curl;
    }

    public Transaction() {
        this.customCurl = SpongeFactory.create(SpongeFactory.Mode.CURLP81);
    }

    public Transaction(String trytes) {
        this();
        this.transactionObject(trytes);
    }

    public Transaction(String trytes, ICurl customCurl) {
        this(customCurl);
        this.transactionObject(trytes);
    }

    public static Transaction[] asTransactionObjects(String ... trytes) {
        Transaction[] transactions = new Transaction[trytes.length];
        for (int i = 0; i < trytes.length; ++i) {
            transactions[i] = Transaction.asTransactionObject(trytes[i]);
        }
        return transactions;
    }

    public static Transaction asTransactionObject(String trytes) {
        return new Transaction(trytes);
    }

    public void setCustomCurl(ICurl customCurl) {
        this.customCurl = customCurl;
    }

    public long getAttachmentTimestampLowerBound() {
        return this.attachmentTimestampLowerBound;
    }

    public void setAttachmentTimestampLowerBound(long attachmentTimestampLowerBound) {
        this.attachmentTimestampLowerBound = attachmentTimestampLowerBound;
    }

    public long getAttachmentTimestampUpperBound() {
        return this.attachmentTimestampUpperBound;
    }

    public void setAttachmentTimestampUpperBound(long attachmentTimestampUpperBound) {
        this.attachmentTimestampUpperBound = attachmentTimestampUpperBound;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSignatureFragments() {
        return this.signatureFragments;
    }

    public void setSignatureFragments(String signatureFragments) {
        this.signatureFragments = signatureFragments;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(long currentIndex) {
        this.currentIndex = currentIndex;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(long lastIndex) {
        this.lastIndex = lastIndex;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getTrunkTransaction() {
        return this.trunkTransaction;
    }

    public void setTrunkTransaction(String trunkTransaction) {
        this.trunkTransaction = trunkTransaction;
    }

    public String getBranchTransaction() {
        return this.branchTransaction;
    }

    public void setBranchTransaction(String branchTransaction) {
        this.branchTransaction = branchTransaction;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Boolean getPersistence() {
        return this.persistence;
    }

    public void setPersistence(Boolean persistence) {
        this.persistence = persistence;
    }

    public String getObsoleteTag() {
        return this.obsoleteTag;
    }

    public void setObsoleteTag(String obsoleteTag) {
        this.obsoleteTag = obsoleteTag;
    }

    public long getAttachmentTimestamp() {
        return this.attachmentTimestamp;
    }

    public void setAttachmentTimestamp(long attachmentTimestamp) {
        this.attachmentTimestamp = attachmentTimestamp;
    }

    public boolean equals(Object obj) {
        return obj != null && ((Transaction)obj).getHash().equals(this.getHash());
    }

    public String toTrytes() {
        int[] valueTrits = Converter.trits(this.getValue(), 81);
        int[] timestampTrits = Converter.trits(this.getTimestamp(), 27);
        int[] currentIndexTrits = Converter.trits(this.getCurrentIndex(), 27);
        int[] lastIndexTrits = Converter.trits(this.getLastIndex(), 27);
        int[] attachmentTimestampTrits = Converter.trits(this.getAttachmentTimestamp(), 27);
        int[] attachmentTimestampLowerBoundTrits = Converter.trits(this.getAttachmentTimestampLowerBound(), 27);
        int[] attachmentTimestampUpperBoundTrits = Converter.trits(this.getAttachmentTimestampUpperBound(), 27);
        this.tag = this.tag != null && !this.tag.isEmpty() ? this.tag : this.obsoleteTag;
        String trytes = this.getSignatureFragments() + this.getAddress().substring(0, 81) + Converter.trytes(valueTrits) + this.getObsoleteTag() + Converter.trytes(timestampTrits) + Converter.trytes(currentIndexTrits) + Converter.trytes(lastIndexTrits) + this.getBundle() + this.getTrunkTransaction() + this.getBranchTransaction() + this.getTag() + Converter.trytes(attachmentTimestampTrits) + Converter.trytes(attachmentTimestampLowerBoundTrits) + Converter.trytes(attachmentTimestampUpperBoundTrits) + this.getNonce();
        return trytes;
    }

    public void transactionObject(String trytes) {
        if (StringUtils.isEmpty((CharSequence)trytes)) {
            return;
        }
        if (!InputValidator.isNinesTrytes(trytes.substring(2279, 2295), 16)) {
            return;
        }
        int[] transactionTrits = Converter.trits(trytes);
        int[] hash = new int[243];
        ICurl curl = this.customCurl != null ? this.customCurl.clone() : SpongeFactory.create(SpongeFactory.Mode.CURLP81);
        curl.reset();
        curl.absorb(transactionTrits, 0, transactionTrits.length);
        curl.squeeze(hash, 0, hash.length);
        this.setHash(Converter.trytes(hash));
        this.setSignatureFragments(trytes.substring(0, 2187));
        this.setAddress(trytes.substring(2187, 2268));
        this.setValue(Converter.longValue(Arrays.copyOfRange(transactionTrits, 6804, 6837)));
        this.setObsoleteTag(trytes.substring(2295, 2322));
        this.setTimestamp(Converter.longValue(Arrays.copyOfRange(transactionTrits, 6966, 6993)));
        this.setCurrentIndex(Converter.longValue(Arrays.copyOfRange(transactionTrits, 6993, 7020)));
        this.setLastIndex(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7020, 7047)));
        this.setBundle(trytes.substring(2349, 2430));
        this.setTrunkTransaction(trytes.substring(2430, 2511));
        this.setBranchTransaction(trytes.substring(2511, 2592));
        this.setTag(trytes.substring(2592, 2619));
        this.setAttachmentTimestamp(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7857, 7884)));
        this.setAttachmentTimestampLowerBound(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7884, 7911)));
        this.setAttachmentTimestampUpperBound(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7911, 7938)));
        this.setNonce(trytes.substring(2646, 2673));
    }

    public boolean isTailTransaction() {
        return this.getCurrentIndex() == 0L;
    }
}

