/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.iota.jota.ApiOptions;
import org.iota.jota.IotaLocalPoW;
import org.iota.jota.connection.Connection;
import org.iota.jota.dto.request.IotaAttachToTangleRequest;
import org.iota.jota.dto.request.IotaBroadcastTransactionRequest;
import org.iota.jota.dto.request.IotaCheckConsistencyRequest;
import org.iota.jota.dto.request.IotaCommandRequest;
import org.iota.jota.dto.request.IotaFindTransactionsRequest;
import org.iota.jota.dto.request.IotaGetBalancesRequest;
import org.iota.jota.dto.request.IotaGetInclusionStateRequest;
import org.iota.jota.dto.request.IotaGetTransactionsToApproveRequest;
import org.iota.jota.dto.request.IotaGetTrytesRequest;
import org.iota.jota.dto.request.IotaNeighborsRequest;
import org.iota.jota.dto.request.IotaStoreTransactionsRequest;
import org.iota.jota.dto.request.IotaWereAddressesSpentFromRequest;
import org.iota.jota.dto.response.AddNeighborsResponse;
import org.iota.jota.dto.response.BroadcastTransactionsResponse;
import org.iota.jota.dto.response.CheckConsistencyResponse;
import org.iota.jota.dto.response.FindTransactionResponse;
import org.iota.jota.dto.response.GetAttachToTangleResponse;
import org.iota.jota.dto.response.GetBalancesResponse;
import org.iota.jota.dto.response.GetInclusionStateResponse;
import org.iota.jota.dto.response.GetNeighborsResponse;
import org.iota.jota.dto.response.GetNodeInfoResponse;
import org.iota.jota.dto.response.GetTipsResponse;
import org.iota.jota.dto.response.GetTransactionsToApproveResponse;
import org.iota.jota.dto.response.GetTrytesResponse;
import org.iota.jota.dto.response.InterruptAttachingToTangleResponse;
import org.iota.jota.dto.response.RemoveNeighborsResponse;
import org.iota.jota.dto.response.StoreTransactionsResponse;
import org.iota.jota.dto.response.WereAddressesSpentFromResponse;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Transaction;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.InputValidator;

public class IotaAPICore {
    protected ApiOptions options;
    protected List<Connection> nodes = new ArrayList<Connection>();
    private Connection service = null;

    protected IotaAPICore(ApiOptions options) {
        this.options = options;
        for (Connection c : options.getNodes()) {
            this.addNode(c);
        }
    }

    public boolean hasNodes() {
        return this.nodes != null && this.nodes.size() > 0;
    }

    public Connection getRandomNode() {
        if (!this.hasNodes()) {
            return null;
        }
        return this.nodes.get(new Random().nextInt(this.nodes.size()));
    }

    public List<Connection> getNodes() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(Connection n) {
        try {
            List<Connection> list = this.nodes;
            synchronized (list) {
                for (Connection c : this.nodes) {
                    if (!c.equals(n)) continue;
                    return true;
                }
                boolean started = n.start();
                if (started) {
                    this.nodes.add(n);
                    if (null == this.service) {
                        this.service = n;
                    }
                }
                return started;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(Connection n) {
        List<Connection> list = this.nodes;
        synchronized (list) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                Connection c = this.nodes.get(i);
                if (!c.equals(n)) continue;
                c.stop();
                this.nodes.remove(i);
                return true;
            }
        }
        return false;
    }

    public ICurl getCurl() {
        return this.options.getCustomCurl().clone();
    }

    public void setCurl(ICurl localPoW) {
        this.options.setCustomCurl(localPoW);
    }

    public IotaLocalPoW getLocalPoW() {
        return this.options.getLocalPoW();
    }

    public void setLocalPoW(IotaLocalPoW localPoW) {
        this.options.setLocalPoW(localPoW);
    }

    public GetNodeInfoResponse getNodeInfo() throws ArgumentException {
        return this.service.getNodeInfo(IotaCommandRequest.createNodeInfoRequest());
    }

    public GetNeighborsResponse getNeighbors() throws ArgumentException {
        return this.service.getNeighbors(IotaCommandRequest.createGetNeighborsRequest());
    }

    public AddNeighborsResponse addNeighbors(String ... uris) throws ArgumentException {
        return this.service.addNeighbors(IotaNeighborsRequest.createAddNeighborsRequest(uris));
    }

    public RemoveNeighborsResponse removeNeighbors(String ... uris) throws ArgumentException {
        return this.service.removeNeighbors(IotaNeighborsRequest.createRemoveNeighborsRequest(uris));
    }

    public GetTipsResponse getTips() throws ArgumentException {
        return this.service.getTips(IotaCommandRequest.createGetTipsRequest());
    }

    public FindTransactionResponse findTransactions(String[] addresses, String[] tags, String[] approvees, String[] bundles) throws ArgumentException {
        if (null != addresses && addresses.length > 0) {
            if (!InputValidator.isAddressesArrayValid(addresses)) {
                throw new ArgumentException("Invalid addresses provided.");
            }
            for (int i = 0; i < addresses.length; ++i) {
                addresses[i] = Checksum.removeChecksum(addresses[i]);
            }
        }
        if (null != tags && tags.length > 0) {
            if (!InputValidator.isStringArrayValid(tags)) {
                throw new ArgumentException("Array cannot be null or empty");
            }
            if (!InputValidator.isArrayOfHashes(tags)) {
                throw new ArgumentException("Invalid tag provided.");
            }
        }
        if (null != bundles && bundles.length > 0 && !InputValidator.isArrayOfHashes(bundles)) {
            throw new ArgumentException("Array cannot be null or empty");
        }
        if (null != approvees && approvees.length > 0 && !InputValidator.isStringArrayValid(approvees)) {
            throw new ArgumentException("Array cannot be null or empty");
        }
        IotaFindTransactionsRequest findTransRequest = IotaFindTransactionsRequest.createFindTransactionRequest().byAddresses(addresses).byTags(tags).byApprovees(approvees).byBundles(bundles);
        return this.service.findTransactions(findTransRequest);
    }

    public FindTransactionResponse findTransactionsByAddresses(String ... addresses) throws ArgumentException {
        if (!InputValidator.isStringArrayValid(addresses)) {
            throw new ArgumentException("Array cannot be null or empty");
        }
        if (!InputValidator.isAddressesArrayValid(addresses)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.findTransactions(addresses, null, null, null);
    }

    public FindTransactionResponse findTransactionsByBundles(String ... bundles) throws ArgumentException {
        return this.findTransactions(null, null, null, bundles);
    }

    public FindTransactionResponse findTransactionsByApprovees(String ... approvees) throws ArgumentException {
        return this.findTransactions(null, null, approvees, null);
    }

    public FindTransactionResponse findTransactionsByDigests(String ... digests) throws ArgumentException {
        return this.findTransactions(null, digests, null, null);
    }

    public FindTransactionResponse findTransactionsByTags(String ... tags) throws ArgumentException {
        return this.findTransactionsByDigests(tags);
    }

    public GetInclusionStateResponse getInclusionStates(String[] transactions, String[] tips) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(transactions)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfHashes(tips)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.service.getInclusionStates(IotaGetInclusionStateRequest.createGetInclusionStateRequest(transactions, tips));
    }

    public GetTrytesResponse getTrytes(String ... hashes) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(hashes)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.service.getTrytes(IotaGetTrytesRequest.createGetTrytesRequest(hashes));
    }

    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth, String reference) throws ArgumentException {
        if (depth < 0) {
            throw new ArgumentException("Invalid depth provided. (Between 0 and 15, soft upper bound)");
        }
        return this.service.getTransactionsToApprove(IotaGetTransactionsToApproveRequest.createIotaGetTransactionsToApproveRequest(depth, reference));
    }

    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth) throws ArgumentException {
        return this.getTransactionsToApprove(depth, null);
    }

    public GetBalancesResponse getBalances(Integer threshold, String[] addresses, String[] tips) throws ArgumentException {
        if (threshold < 0 || threshold > 100) {
            throw new ArgumentException("Invalid threshold provided. (Between 0 and 100 incl.)");
        }
        if (null != tips && !InputValidator.isArrayOfHashes(tips)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (null == addresses || addresses.length == 0 || !InputValidator.isAddressesArrayValid(addresses)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = Checksum.removeChecksum(addresses[i]);
        }
        return this.service.getBalances(IotaGetBalancesRequest.createIotaGetBalancesRequest(threshold, addresses, tips));
    }

    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses, List<String> tips) throws ArgumentException {
        String[] tipsArray = tips != null ? tips.toArray(new String[tips.size()]) : null;
        String[] addressesArray = addresses != null ? addresses.toArray(new String[addresses.size()]) : null;
        return this.getBalances(threshold, addressesArray, tipsArray);
    }

    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses) throws ArgumentException {
        return this.getBalances(threshold, addresses, null);
    }

    public WereAddressesSpentFromResponse wereAddressesSpentFrom(String ... addresses) throws ArgumentException {
        if (null == addresses || addresses.length == 0 || !InputValidator.isAddressesArrayValid(addresses)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = Checksum.removeChecksum(addresses[i]);
        }
        return this.service.wereAddressesSpentFrom(IotaWereAddressesSpentFromRequest.create(addresses));
    }

    public CheckConsistencyResponse checkConsistency(String ... tails) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(tails)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.service.checkConsistency(IotaCheckConsistencyRequest.create(tails));
    }

    public GetAttachToTangleResponse attachToTangle(String trunkTransaction, String branchTransaction, Integer minWeightMagnitude, String ... trytes) throws ArgumentException {
        if (!InputValidator.isHash(trunkTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isHash(branchTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid trytes provided.");
        }
        IotaLocalPoW pow = this.options.getLocalPoW();
        if (pow != null) {
            String[] resultTrytes = new String[trytes.length];
            String previousTransaction = null;
            for (int i = trytes.length - 1; i >= 0; --i) {
                Transaction txn = new Transaction(trytes[i]);
                txn.setTrunkTransaction(previousTransaction == null ? trunkTransaction : previousTransaction);
                txn.setBranchTransaction(previousTransaction == null ? branchTransaction : trunkTransaction);
                if (txn.getTag().isEmpty() || txn.getTag().matches("9*")) {
                    txn.setTag(txn.getObsoleteTag());
                }
                txn.setAttachmentTimestamp(System.currentTimeMillis());
                txn.setAttachmentTimestampLowerBound(0L);
                txn.setAttachmentTimestampUpperBound(3812798742493L);
                resultTrytes[i] = pow.performPoW(txn.toTrytes(), minWeightMagnitude);
                previousTransaction = new Transaction(resultTrytes[i], SpongeFactory.create(SpongeFactory.Mode.CURLP81)).getHash();
            }
            return new GetAttachToTangleResponse(resultTrytes);
        }
        GetAttachToTangleResponse ret = this.service.attachToTangle(IotaAttachToTangleRequest.createAttachToTangleRequest(trunkTransaction, branchTransaction, minWeightMagnitude, trytes));
        return ret;
    }

    public InterruptAttachingToTangleResponse interruptAttachingToTangle() throws ArgumentException {
        return this.service.interruptAttachingToTangle(IotaCommandRequest.createInterruptAttachToTangleRequest());
    }

    public BroadcastTransactionsResponse broadcastTransactions(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid attached trytes provided.");
        }
        return this.service.broadcastTransactions(IotaBroadcastTransactionRequest.createBroadcastTransactionsRequest(trytes));
    }

    public StoreTransactionsResponse storeTransactions(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid attached trytes provided.");
        }
        return this.service.storeTransactions(IotaStoreTransactionsRequest.createStoreTransactionsRequest(trytes));
    }

    @Deprecated
    public String getProtocol() {
        return this.service.url().getProtocol();
    }

    @Deprecated
    public String getHost() {
        return this.service.url().getHost();
    }

    @Deprecated
    public String getPort() {
        return this.service.url().getPort() + "";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("----------------------");
        builder.append(System.getProperty("line.separator"));
        builder.append(this.options.toString());
        builder.append(System.getProperty("line.separator"));
        builder.append("Registrered nodes: " + System.getProperty("line.separator"));
        for (Connection n : this.nodes) {
            builder.append(n.toString() + System.getProperty("line.separator"));
        }
        return builder.toString();
    }
}

