/*
 * Decompiled with CFR 0.152.
 */
package threads.iota;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import threads.iota.Hash;
import threads.iota.HashDao;

public final class HashDao_Impl
implements HashDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfHash;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfRemoveHash;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAllHashesWithSmallerTimestamp;

    public HashDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHash = new EntityInsertionAdapter<Hash>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Hash`(`hash`,`timestamp`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Hash value) {
                if (value.getHash() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getHash());
                }
                stmt.bindLong(2, value.getTimestamp());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Hash";
                return "DELETE FROM Hash";
            }
        };
        this.__preparedStmtOfRemoveHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Hash WHERE hash = ?";
                return "DELETE FROM Hash WHERE hash = ?";
            }
        };
        this.__preparedStmtOfRemoveAllHashesWithSmallerTimestamp = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Hash WHERE timestamp <= ?";
                return "DELETE FROM Hash WHERE timestamp <= ?";
            }
        };
    }

    @Override
    public void insertHash(Hash ... hashes) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfHash.insert((Object[])hashes);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHash(String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllHashesWithSmallerTimestamp(long timestamp) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveAllHashesWithSmallerTimestamp.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, timestamp);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveAllHashesWithSmallerTimestamp.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getHashes() {
        String _sql = "SELECT hash FROM Hash";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT hash FROM Hash", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long hasHash(String hash) {
        String _sql = "SELECT COUNT(*) FROM Hash WHERE hash =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM Hash WHERE hash =?", (int)1);
        int _argIndex = 1;
        if (hash == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, hash);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            long _result = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

