/*
 * Decompiled with CFR 0.152.
 */
package threads.iota;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.iota.jota.IotaAPI;
import org.iota.jota.IotaLocalPoW;
import org.iota.jota.dto.response.FindTransactionResponse;
import org.iota.jota.dto.response.GetNodeInfoResponse;
import org.iota.jota.model.Transaction;
import org.iota.jota.model.Transfer;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.InputValidator;
import org.iota.jota.utils.SeedRandomGenerator;
import org.iota.jota.utils.TrytesConverter;
import threads.iota.Entity;

public class IOTA {
    private static final int DEPTH = 1;
    private static final int ZERO_VALUE = 0;
    private static final String POW_SUPPORT = "RemotePOW";
    private static final String LOAD_BALANCER = "loadBalancer";
    private static final int MIN_WEIGHT_MAGNITUDE = 14;
    private final String protocol;
    private final String host;
    private final int port;
    private final int timeout;
    private IotaAPI iotaAPI;

    private IOTA(Builder builder) {
        Preconditions.checkNotNull((Object)builder);
        this.protocol = builder.protocol;
        this.host = builder.host;
        this.port = builder.port;
        this.timeout = builder.timeout;
        this.postConstruct();
    }

    public static boolean remotePoW(@NonNull GetNodeInfoResponse nodeInfoResponse) {
        Preconditions.checkNotNull((Object)nodeInfoResponse);
        String[] features = nodeInfoResponse.getFeatures();
        if (features != null) {
            for (String feature : features) {
                if (!POW_SUPPORT.equals(feature)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean loadBalancer(@NonNull GetNodeInfoResponse nodeInfoResponse) {
        Preconditions.checkNotNull((Object)nodeInfoResponse);
        String[] features = nodeInfoResponse.getFeatures();
        if (features != null) {
            for (String feature : features) {
                if (!LOAD_BALANCER.equals(feature)) continue;
                return true;
            }
        }
        return false;
    }

    private static String adaptTrytes(@NonNull String stringAsTrytes) {
        int length = (stringAsTrytes = StringUtils.stripEnd((String)stringAsTrytes, (String)"9")).length();
        if (length % 2 != 0) {
            stringAsTrytes = stringAsTrytes.concat("9");
        }
        return stringAsTrytes;
    }

    private static boolean isTrytes(String trytes, int length) {
        return trytes.matches("^[A-Z9]{" + (length == 0 ? "0," : Integer.valueOf(length)) + "}$");
    }

    public static String generateAddress() {
        String address = SeedRandomGenerator.generateNewSeed();
        return IOTA.addChecksum(address);
    }

    public static String addChecksum(@NonNull String address) {
        return Checksum.addChecksum(address);
    }

    public static String toTrytes(byte[] bytes) {
        StringBuilder trytes = new StringBuilder();
        for (byte asciiValue : bytes) {
            int value = asciiValue & 0xFF;
            int firstValue = value % 27;
            int secondValue = (value - firstValue) / 27;
            String trytesValue = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(firstValue) + String.valueOf("9ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(secondValue));
            trytes.append(trytesValue);
        }
        return trytes.toString();
    }

    public static byte[] toBytes(String inputTrytes) {
        if (inputTrytes.length() % 2 != 0) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < inputTrytes.length(); i += 2) {
            int firstValue = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(inputTrytes.charAt(i));
            int secondValue = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(inputTrytes.charAt(i + 1));
            int decimalValue = firstValue + secondValue * 27;
            bos.write(decimalValue);
        }
        return bos.toByteArray();
    }

    public static boolean isValidAddress(@NonNull String address) {
        return InputValidator.isAddress(address);
    }

    public static String randomTag() {
        char[] chars = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        StringBuilder builder = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 27; ++i) {
            char c = chars[random.nextInt(chars.length)];
            builder.append(c);
        }
        return builder.toString();
    }

    public static String createTag(byte[] basic) {
        Preconditions.checkNotNull((Object)basic);
        Preconditions.checkArgument((basic.length >= 20 ? 1 : 0) != 0);
        String trytes = IOTA.toTrytes(basic);
        return StringUtils.substring((String)trytes, (int)0, (int)27);
    }

    @Nullable
    private static byte[] loadBundle(@NonNull Entity bundle) {
        Preconditions.checkNotNull((Object)bundle);
        String bundleContent = bundle.getContent();
        if (!bundleContent.isEmpty()) {
            return IOTA.toBytes(bundleContent);
        }
        return null;
    }

    @NonNull
    public String getProtocol() {
        return this.protocol;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private void postConstruct() {
        IotaAPI.Builder builder = new IotaAPI.Builder();
        builder = (IotaAPI.Builder)builder.protocol(this.protocol);
        builder = (IotaAPI.Builder)builder.host(this.host);
        builder = (IotaAPI.Builder)builder.port(this.port);
        builder = (IotaAPI.Builder)builder.timeout(this.timeout);
        this.iotaAPI = (IotaAPI)builder.build();
    }

    @Nullable
    public IotaLocalPoW getLocalPoW() {
        return this.iotaAPI.getLocalPoW();
    }

    public void setLocalPoW(@Nullable IotaLocalPoW localPoW) {
        this.iotaAPI.setLocalPoW(localPoW);
    }

    public void loadHashTransactions(@NonNull Filter filter, String ... hashes) {
        Preconditions.checkNotNull((Object)filter);
        Preconditions.checkNotNull((Object)hashes);
        this.loadHashes(filter, hashes);
    }

    public void loadAddressTransactions(@NonNull Filter filter, String ... addresses) {
        Preconditions.checkNotNull((Object)filter);
        Preconditions.checkNotNull((Object)addresses);
        this.loadTransactions(filter, addresses);
    }

    @NonNull
    public Entity insertTransaction(@NonNull String address, @NonNull String data) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)data);
        return this.insert(address, TrytesConverter.asciiToTrytes(data), true);
    }

    @NonNull
    public GetNodeInfoResponse getNodeInfo() {
        return this.iotaAPI.getNodeInfo();
    }

    public void loadTransactions(@NonNull Filter filter, String ... addresses) {
        Preconditions.checkNotNull((Object)addresses);
        Preconditions.checkNotNull((Object)filter);
        FindTransactionResponse ftr = this.iotaAPI.findTransactions(addresses, null, null, null);
        ArrayList<String> findHashes = new ArrayList<String>();
        if (ftr != null) {
            String[] hashes;
            for (String hash : hashes = ftr.getHashes()) {
                if (!filter.acceptHash(hash)) continue;
                findHashes.add(hash);
            }
        }
        this.loadHashes(filter, (String[])Iterables.toArray(findHashes, String.class));
    }

    @Nullable
    private Entity getEntity(@NonNull Transaction transaction, boolean trytesToAscii) {
        if (transaction.getLastIndex() == 0L) {
            String content = IOTA.adaptTrytes(transaction.getSignatureFragments());
            if (trytesToAscii) {
                content = TrytesConverter.trytesToAscii(content);
            }
            return new Entity(transaction.getHash(), transaction.getAddress(), transaction.getTag(), content);
        }
        return null;
    }

    @NonNull
    public Entity setContent(@NonNull String address, @NonNull byte[] bytes) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)bytes);
        String data = IOTA.toTrytes(bytes);
        return this.insert(address, data, false);
    }

    @NonNull
    private Entity insert(@NonNull String address, @NonNull String dataTrits, boolean trytesToAscii) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)dataTrits);
        ArrayList<Transfer> transfers = new ArrayList<Transfer>();
        transfers.add(new Transfer(address, 0L, dataTrits, IOTA.randomTag()));
        List<String> trytes = this.iotaAPI.prepareTransfers(1, transfers, null, null, null, false);
        Preconditions.checkArgument((trytes.size() == 1 ? 1 : 0) != 0, (Object)"Trytes has not supported size");
        List<Transaction> transactions = this.iotaAPI.sendTrytes((String[])Iterables.toArray(trytes, String.class), 1, 14, null);
        Preconditions.checkArgument((transactions.size() == 1 ? 1 : 0) != 0, (Object)"Transactions not valid");
        Transaction transaction = transactions.get(0);
        Entity entity = this.getEntity(transaction, trytesToAscii);
        Preconditions.checkNotNull((Object)entity);
        return entity;
    }

    @Nullable
    public byte[] getContent(@NonNull String hash) {
        Transaction transaction;
        Entity bundle;
        Preconditions.checkNotNull((Object)hash);
        List<Transaction> transactions = this.iotaAPI.findTransactionsObjectsByHashes(hash);
        if (transactions != null && transactions.size() == 1 && (bundle = this.getEntity(transaction = transactions.get(0), false)) != null) {
            return IOTA.loadBundle(bundle);
        }
        return null;
    }

    private void loadHashes(@NonNull Filter filter, String ... hashes) {
        List<Transaction> transactions = this.iotaAPI.findTransactionsObjectsByHashes(hashes);
        for (Transaction transaction : transactions) {
            Entity entity = this.getEntity(transaction, true);
            if (entity != null) {
                if (!filter.acceptEntity(entity)) continue;
                this.loadEntity(entity, filter);
                continue;
            }
            filter.invalidHash(transaction.getHash());
        }
    }

    private void loadEntity(@NonNull Entity entity, @NonNull Filter filter) {
        try {
            String bundleContentTrytes = entity.getContent();
            if (!bundleContentTrytes.isEmpty()) {
                filter.loadEntity(entity);
            } else {
                filter.invalidEntity(entity);
            }
        }
        catch (Throwable e) {
            filter.error(entity, e);
        }
    }

    public static class Builder {
        private String protocol;
        private String host;
        private int port;
        private int timeout = 150;

        public IOTA build() {
            Preconditions.checkNotNull((Object)this.protocol);
            Preconditions.checkNotNull((Object)this.host);
            Preconditions.checkNotNull((Object)this.port);
            Preconditions.checkArgument((this.timeout >= 0 ? 1 : 0) != 0);
            return new IOTA(this);
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }
    }

    public static interface Filter {
        public boolean acceptHash(@NonNull String var1);

        public void invalidHash(@NonNull String var1);

        public boolean acceptEntity(@NonNull Entity var1);

        public void loadEntity(@NonNull Entity var1);

        public void invalidEntity(@NonNull Entity var1);

        public void error(@NonNull Entity var1, @NonNull Throwable var2);
    }
}

