package org.iota.jota.builder;

import org.iota.jota.IotaAPICore;
import org.iota.jota.IotaLocalPoW;
import org.iota.jota.connection.Connection;
import org.iota.jota.connection.HttpConnector;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("unchecked")
public abstract class ApiBuilder<T extends ApiBuilder<T, E>, E extends IotaAPICore>
        extends AbstractBuilder<T, E> {


    List<Connection> nodes = new ArrayList<>();

    String protocol, host;
    int port;

    int timeout = 0;

    // If this is null, no local PoW is done, therefore no default value
    IotaLocalPoW localPoW;
    ICurl customCurl = SpongeFactory.create(SpongeFactory.Mode.KERL);

    public ApiBuilder() {
        super();
    }

    /**
     * @return
     */
    protected T generate() throws Exception {


        if (hasLegacyOptions()) {
            nodes.add(new HttpConnector(protocol, host, port, timeout));
        }

        return (T) this;
    }

    private boolean hasLegacyOptions() {
        return null != host || null != protocol || 0 != port;
    }

    public T withCustomCurl(ICurl curl) {
        customCurl = curl;
        return (T) this;
    }

    public T host(String host) {
        this.host = host;
        return (T) this;
    }

    public T port(int port) {
        this.port = port;
        return (T) this;
    }

    public T protocol(String protocol) {
        this.protocol = protocol;
        return (T) this;
    }

    public T localPoW(IotaLocalPoW localPoW) {
        this.localPoW = localPoW;
        return (T) this;
    }

    public T timeout(int timeout) {
        this.timeout = timeout;
        return (T) this;
    }

    public String getProtocol() {
        return protocol;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public IotaLocalPoW getLocalPoW() {
        return localPoW;
    }

    public ICurl getCustomCurl() {
        return customCurl;
    }

    public T addNode(Connection c) {
        nodes.add(c);
        return (T) this;
    }

    public List<Connection> getNodes() {
        return nodes;
    }

    public int getConnectionTimeout() {
        return timeout;
    }


    public boolean hasNodes() {
        return nodes != null && nodes.size() > 0;
    }


    public int getLegacyPort() {
        return getPort();
    }


    public String getLegacyProtocol() {
        return getProtocol();
    }


    public String getLegacyHost() {
        return getHost();
    }
}