/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.builder;

import java.util.ArrayList;
import java.util.List;
import org.iota.jota.IotaAPICore;
import org.iota.jota.IotaLocalPoW;
import org.iota.jota.builder.AbstractBuilder;
import org.iota.jota.connection.Connection;
import org.iota.jota.connection.HttpConnector;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;

public abstract class ApiBuilder<T extends ApiBuilder<T, E>, E extends IotaAPICore>
extends AbstractBuilder<T, E> {
    List<Connection> nodes = new ArrayList<Connection>();
    String protocol;
    String host;
    int port;
    int timeout = 0;
    IotaLocalPoW localPoW;
    ICurl customCurl = SpongeFactory.create(SpongeFactory.Mode.KERL);

    @Override
    protected T generate() throws Exception {
        if (this.hasLegacyOptions()) {
            this.nodes.add(new HttpConnector(this.protocol, this.host, this.port, this.timeout));
        }
        return (T)this;
    }

    private boolean hasLegacyOptions() {
        return null != this.host || null != this.protocol || 0 != this.port;
    }

    public T withCustomCurl(ICurl curl) {
        this.customCurl = curl;
        return (T)this;
    }

    public T host(String host) {
        this.host = host;
        return (T)this;
    }

    public T port(int port) {
        this.port = port;
        return (T)this;
    }

    public T protocol(String protocol) {
        this.protocol = protocol;
        return (T)this;
    }

    public T localPoW(IotaLocalPoW localPoW) {
        this.localPoW = localPoW;
        return (T)this;
    }

    public T timeout(int timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public IotaLocalPoW getLocalPoW() {
        return this.localPoW;
    }

    public ICurl getCustomCurl() {
        return this.customCurl;
    }

    public T addNode(Connection c) {
        this.nodes.add(c);
        return (T)this;
    }

    public List<Connection> getNodes() {
        return this.nodes;
    }

    public int getConnectionTimeout() {
        return this.timeout;
    }

    public boolean hasNodes() {
        return this.nodes != null && this.nodes.size() > 0;
    }

    public int getLegacyPort() {
        return this.getPort();
    }

    public String getLegacyProtocol() {
        return this.getProtocol();
    }

    public String getLegacyHost() {
        return this.getHost();
    }
}

