package threads.iota;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import java.util.List;

@Dao
public interface HashDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertHash(Hash... hashes);


    @Query("SELECT hash FROM Hash")
    List<String> getHashes();

    @Query("DELETE FROM Hash")
    void clear();

    @Query("SELECT COUNT(*) FROM Hash WHERE hash =:hash")
    long hasHash(String hash);

    @Query("DELETE FROM Hash WHERE hash = :hash")
    void removeHash(String hash);


    @Query("DELETE FROM Hash WHERE timestamp <= :timestamp")
    void removeAllHashesWithSmallerTimestamp(long timestamp);

}
