/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import org.iota.jota.error.ArgumentException;

public class TrytesConverter {
    public static String asciiToTrytes(String inputString) {
        StringBuilder trytes = new StringBuilder();
        for (int i = 0; i < inputString.length(); ++i) {
            int asciiValue = inputString.charAt(i);
            if (asciiValue > 255) {
                asciiValue = 32;
            }
            int firstValue = asciiValue % 27;
            int secondValue = (asciiValue - firstValue) / 27;
            String trytesValue = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(firstValue) + String.valueOf("9ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(secondValue));
            trytes.append(trytesValue);
        }
        return trytes.toString();
    }

    public static String trytesToAscii(String inputTrytes) throws ArgumentException {
        if (inputTrytes.length() % 2 != 0) {
            throw new ArgumentException("Odd amount of trytes supplied");
        }
        StringBuilder string = new StringBuilder();
        for (int i = 0; i < inputTrytes.length(); i += 2) {
            int firstValue = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(inputTrytes.charAt(i));
            int secondValue = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(inputTrytes.charAt(i + 1));
            int decimalValue = firstValue + secondValue * 27;
            String character = Character.toString((char)decimalValue);
            string.append(character);
        }
        return string.toString();
    }
}

