/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iota.jota.ApiOptions;
import org.iota.jota.IotaAPICore;
import org.iota.jota.builder.ApiBuilder;
import org.iota.jota.dto.response.BroadcastTransactionsResponse;
import org.iota.jota.dto.response.CheckConsistencyResponse;
import org.iota.jota.dto.response.FindTransactionResponse;
import org.iota.jota.dto.response.GetAccountDataResponse;
import org.iota.jota.dto.response.GetAttachToTangleResponse;
import org.iota.jota.dto.response.GetBalancesAndFormatResponse;
import org.iota.jota.dto.response.GetBalancesResponse;
import org.iota.jota.dto.response.GetBundleResponse;
import org.iota.jota.dto.response.GetInclusionStateResponse;
import org.iota.jota.dto.response.GetNewAddressResponse;
import org.iota.jota.dto.response.GetNodeInfoResponse;
import org.iota.jota.dto.response.GetTransactionsToApproveResponse;
import org.iota.jota.dto.response.GetTransferResponse;
import org.iota.jota.dto.response.GetTrytesResponse;
import org.iota.jota.dto.response.ReplayBundleResponse;
import org.iota.jota.dto.response.SendTransferResponse;
import org.iota.jota.dto.response.WereAddressesSpentFromResponse;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.error.BaseException;
import org.iota.jota.error.NotPromotableException;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Input;
import org.iota.jota.model.Transaction;
import org.iota.jota.model.Transfer;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.BundleValidator;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.InputValidator;
import org.iota.jota.utils.IotaAPIUtils;
import org.iota.jota.utils.Parallel;
import org.iota.jota.utils.StopWatch;

public class IotaAPI
extends IotaAPICore {
    protected IotaAPI(Builder builder) {
        super(new ApiOptions(builder));
    }

    @Deprecated
    public GetNewAddressResponse getNewAddress(String seed, int security, int index, boolean checksum, int total, boolean returnAll) throws ArgumentException {
        if (total != 0) {
            return this.getAddressesUnchecked(seed, security, checksum, index, total);
        }
        return this.generateNewAddresses(seed, security, checksum, index, 1L, returnAll);
    }

    public GetNewAddressResponse getNextAvailableAddress(String seed, int security, boolean checksum) throws ArgumentException {
        return this.generateNewAddresses(seed, security, checksum, 0, 1L, false);
    }

    public GetNewAddressResponse getNextAvailableAddress(String seed, int security, boolean checksum, int index) throws ArgumentException {
        return this.generateNewAddresses(seed, security, checksum, index, 1L, false);
    }

    public GetNewAddressResponse generateNewAddresses(String seed, int security, boolean checksum, int amount) throws ArgumentException {
        return this.generateNewAddresses(seed, security, checksum, 0, amount, false);
    }

    public GetNewAddressResponse generateNewAddresses(String seed, int security, boolean checksum, int index, int amount) throws ArgumentException {
        return this.generateNewAddresses(seed, security, checksum, 0, amount, false);
    }

    public GetNewAddressResponse generateNewAddresses(String seed, int security, boolean checksum, int index, long amount, boolean addSpendAddresses) throws ArgumentException {
        if (!InputValidator.isValidSeed(seed)) {
            throw new IllegalStateException("Invalid seed provided.");
        }
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        if ((long)index + amount < 0L) {
            throw new ArgumentException("Invalid input provided.");
        }
        StopWatch stopWatch = new StopWatch();
        ArrayList<String> allAddresses = new ArrayList<String>();
        int i = index;
        int numUnspentFound = 0;
        while ((long)numUnspentFound < amount) {
            WereAddressesSpentFromResponse spent;
            String newAddress = IotaAPIUtils.newAddress(seed, security, i, checksum, this.getCurl());
            FindTransactionResponse response = this.findTransactionsByAddresses(checksum ? newAddress : Checksum.addChecksum(newAddress));
            boolean isSpent = true;
            if (response.getHashes().length == 0 && (spent = this.wereAddressesSpentFrom(checksum ? newAddress : Checksum.addChecksum(newAddress))).getStates().length > 0 && !spent.getStates()[0]) {
                if (amount != 0L) {
                    allAddresses.add(newAddress);
                }
                ++numUnspentFound;
                isSpent = false;
            }
            if (isSpent && addSpendAddresses) {
                allAddresses.add(newAddress);
            }
            ++i;
        }
        return GetNewAddressResponse.create(allAddresses, stopWatch.getElapsedTimeMili());
    }

    public GetNewAddressResponse getAddressesUnchecked(String seed, int security, boolean checksum, int index, int amount) throws ArgumentException {
        if (!InputValidator.isValidSeed(seed)) {
            throw new IllegalStateException("Invalid seed provided.");
        }
        StopWatch stopWatch = new StopWatch();
        ArrayList<String> allAddresses = new ArrayList<String>();
        for (int i = index; i < index + amount; ++i) {
            allAddresses.add(IotaAPIUtils.newAddress(seed, security, i, checksum, this.getCurl()));
        }
        return GetNewAddressResponse.create(allAddresses, stopWatch.getElapsedTimeMili());
    }

    public GetTransferResponse getTransfers(String seed, int security, Integer start, Integer end, Boolean inclusionStates) throws ArgumentException {
        if (!InputValidator.isValidSeed(seed)) {
            throw new IllegalStateException("Invalid seed provided.");
        }
        if (start < 0 || start > end || end > start + 500) {
            throw new ArgumentException("Invalid input provided.");
        }
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        StopWatch stopWatch = new StopWatch();
        GetNewAddressResponse gnr = this.getNewAddress(seed, security, start, true, end, true);
        if (gnr != null && gnr.getAddresses() != null) {
            Bundle[] bundles = this.bundlesFromAddresses(inclusionStates, gnr.getAddresses().toArray(new String[gnr.getAddresses().size()]));
            return GetTransferResponse.create(bundles, stopWatch.getElapsedTimeMili());
        }
        return GetTransferResponse.create(new Bundle[0], stopWatch.getElapsedTimeMili());
    }

    public Bundle[] bundlesFromAddresses(final Boolean inclusionStates, String ... addresses) throws ArgumentException {
        List<Transaction> trxs = this.findTransactionObjectsByAddresses(addresses);
        ArrayList<String> tailTransactions = new ArrayList<String>();
        ArrayList<String> nonTailBundleHashes = new ArrayList<String>();
        for (Transaction transaction : trxs) {
            if (transaction.getCurrentIndex() == 0L) {
                tailTransactions.add(transaction.getHash());
                continue;
            }
            if (nonTailBundleHashes.indexOf(transaction.getBundle()) != -1) continue;
            nonTailBundleHashes.add(transaction.getBundle());
        }
        List<Transaction> bundleObjects = this.findTransactionObjectsByBundle(nonTailBundleHashes.toArray(new String[nonTailBundleHashes.size()]));
        for (Transaction trx : bundleObjects) {
            if (trx.getCurrentIndex() != 0L || tailTransactions.indexOf(trx.getHash()) != -1) continue;
            tailTransactions.add(trx.getHash());
        }
        final ArrayList arrayList = new ArrayList();
        final String[] tailTxArray = tailTransactions.toArray(new String[tailTransactions.size()]);
        GetInclusionStateResponse gisr = null;
        if (tailTxArray.length != 0 && inclusionStates.booleanValue() && ((gisr = this.getLatestInclusion(tailTxArray)) == null || gisr.getStates() == null || gisr.getStates().length == 0)) {
            throw new IllegalStateException("Get inclusion state response was null.");
        }
        final GetInclusionStateResponse finalInclusionStates = gisr;
        try {
            Parallel.of(Arrays.asList(tailTxArray), new Parallel.Operation<String>(){

                @Override
                public void perform(String tailTx) {
                    try {
                        GetBundleResponse bundleResponse = IotaAPI.this.getBundle(tailTx);
                        Bundle gbr = new Bundle(bundleResponse.getTransactions(), bundleResponse.getTransactions().size());
                        if (gbr.getTransactions() != null) {
                            if (inclusionStates.booleanValue()) {
                                boolean thisInclusion = false;
                                if (finalInclusionStates != null) {
                                    thisInclusion = finalInclusionStates.getStates()[Arrays.asList(tailTxArray).indexOf(tailTx)];
                                }
                                for (Transaction t : gbr.getTransactions()) {
                                    t.setPersistence(thisInclusion);
                                }
                            }
                            arrayList.add(gbr);
                        }
                    }
                    catch (ArgumentException argumentException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (InterruptedException e) {
            return null;
        }
        Collections.sort(arrayList);
        Bundle[] returnValue = new Bundle[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            returnValue[i] = new Bundle(((Bundle)arrayList.get(i)).getTransactions(), ((Bundle)arrayList.get(i)).getTransactions().size());
        }
        return returnValue;
    }

    public BroadcastTransactionsResponse storeAndBroadcast(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfAttachedTrytes(trytes)) {
            throw new ArgumentException("Invalid trytes provided.");
        }
        try {
            this.storeTransactions(trytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArgumentException(e.toString());
        }
        return this.broadcastTransactions(trytes);
    }

    public List<Transaction> sendTrytes(String[] trytes, int depth, int minWeightMagnitude, String reference) throws ArgumentException {
        GetTransactionsToApproveResponse txs = this.getTransactionsToApprove(depth, reference);
        GetAttachToTangleResponse res = this.attachToTangle(txs.getTrunkTransaction(), txs.getBranchTransaction(), minWeightMagnitude, trytes);
        try {
            this.storeAndBroadcast(res.getTrytes());
        }
        catch (ArgumentException e) {
            return new ArrayList<Transaction>();
        }
        ArrayList<Transaction> trx = new ArrayList<Transaction>();
        for (String tryte : res.getTrytes()) {
            trx.add(new Transaction(tryte, SpongeFactory.create(SpongeFactory.Mode.CURLP81)));
        }
        return trx;
    }

    public List<Transaction> findTransactionsObjectsByHashes(String ... hashes) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(hashes)) {
            throw new IllegalStateException("Invalid hashes provided.");
        }
        GetTrytesResponse trytesResponse = this.getTrytes(hashes);
        ArrayList<Transaction> trxs = new ArrayList<Transaction>();
        for (String tryte : trytesResponse.getTrytes()) {
            trxs.add(new Transaction(tryte, SpongeFactory.create(SpongeFactory.Mode.CURLP81)));
        }
        return trxs;
    }

    public List<Transaction> findTransactionObjectsByAddresses(String[] addresses) throws ArgumentException {
        FindTransactionResponse ftr = this.findTransactionsByAddresses(addresses);
        if (ftr == null || ftr.getHashes() == null) {
            return new ArrayList<Transaction>();
        }
        return this.findTransactionsObjectsByHashes(ftr.getHashes());
    }

    public List<Transaction> findTransactionObjectsByTag(String ... tags) throws ArgumentException {
        FindTransactionResponse ftr = this.findTransactionsByTags(tags);
        if (ftr == null || ftr.getHashes() == null) {
            return new ArrayList<Transaction>();
        }
        return this.findTransactionsObjectsByHashes(ftr.getHashes());
    }

    public List<Transaction> findTransactionObjectsByApprovees(String ... approvees) throws ArgumentException {
        FindTransactionResponse ftr = this.findTransactionsByApprovees(approvees);
        if (ftr == null || ftr.getHashes() == null) {
            return new ArrayList<Transaction>();
        }
        return this.findTransactionsObjectsByHashes(ftr.getHashes());
    }

    public List<Transaction> findTransactionObjectsByBundle(String ... bundles) throws ArgumentException {
        FindTransactionResponse ftr = this.findTransactionsByBundles(bundles);
        if (ftr == null || ftr.getHashes() == null) {
            return new ArrayList<Transaction>();
        }
        return this.findTransactionsObjectsByHashes(ftr.getHashes());
    }

    /*
     * WARNING - void declaration
     */
    public List<String> prepareTransfers(String seed, int security, List<Transfer> transfers, String remainder, List<Input> inputs, List<Transaction> tips, boolean validateInputs) throws ArgumentException {
        if (!InputValidator.isValidSeed(seed)) {
            throw new IllegalStateException("Invalid seed provided.");
        }
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        if (remainder != null && !InputValidator.checkAddress(remainder)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        if (!InputValidator.isTransfersCollectionValid(transfers)) {
            throw new ArgumentException("Invalid transfers provided.");
        }
        if (inputs != null && !InputValidator.areValidInputsList(inputs)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        Bundle bundle = new Bundle();
        ArrayList<String> signatureFragments = new ArrayList<String>();
        long totalValue = 0L;
        String tag = "";
        for (Transfer transfer : transfers) {
            transfer.setAddress(Checksum.removeChecksum(transfer.getAddress()));
            int signatureMessageLength = 1;
            if (transfer.getMessage().length() > 2187) {
                signatureMessageLength = (int)((double)signatureMessageLength + Math.floor(transfer.getMessage().length() / 2187));
                String msgCopy = transfer.getMessage();
                while (!msgCopy.isEmpty()) {
                    String fragment = StringUtils.substring((String)msgCopy, (int)0, (int)2187);
                    msgCopy = StringUtils.substring((String)msgCopy, (int)2187, (int)msgCopy.length());
                    fragment = StringUtils.rightPad((String)fragment, (int)2187, (char)'9');
                    signatureFragments.add(fragment);
                }
            } else {
                String fragment = transfer.getMessage();
                if (transfer.getMessage().length() < 2187) {
                    fragment = StringUtils.rightPad((String)fragment, (int)2187, (char)'9');
                }
                signatureFragments.add(fragment);
            }
            tag = transfer.getTag();
            if (transfer.getTag().length() < 27) {
                tag = StringUtils.rightPad((String)tag, (int)27, (char)'9');
            }
            long timestamp = (long)Math.floor(Calendar.getInstance().getTimeInMillis() / 1000L);
            bundle.addEntry(signatureMessageLength, transfer.getAddress(), transfer.getValue(), tag, timestamp);
            totalValue += transfer.getValue();
        }
        if (totalValue != 0L) {
            if (!InputValidator.isValidSeed(seed)) {
                throw new IllegalStateException("Invalid seed provided.");
            }
            for (Transfer transfer : transfers) {
                if (InputValidator.hasTrailingZeroTrit(transfer.getAddress())) continue;
                throw new ArgumentException("Invalid addresses provided.");
            }
            if (inputs != null && !inputs.isEmpty()) {
                void var14_19;
                if (!validateInputs) {
                    return this.addRemainder(seed, security, inputs, bundle, tag, totalValue, remainder, signatureFragments);
                }
                ArrayList<String> inputsAddresses = new ArrayList<String>();
                for (Input i : inputs) {
                    inputsAddresses.add(i.getAddress());
                }
                Object var14_17 = null;
                if (tips != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Transaction tx : tips) {
                        arrayList.add(tx.getHash());
                    }
                }
                GetBalancesResponse balancesResponse = this.getBalances((Integer)100, inputsAddresses, (List<String>)var14_19);
                String[] balances = balancesResponse.getBalances();
                ArrayList<Input> confirmedInputs = new ArrayList<Input>();
                long totalBalance = 0L;
                for (int i = 0; i < balances.length; ++i) {
                    long thisBalance = Long.parseLong(balances[i]);
                    if (thisBalance <= 0L) continue;
                    Input inputEl = inputs.get(i);
                    inputEl.setBalance(thisBalance);
                    confirmedInputs.add(inputEl);
                    if ((totalBalance += thisBalance) >= totalValue) break;
                }
                if (totalValue > totalBalance) {
                    throw new IllegalStateException("Not enough balance.");
                }
                return this.addRemainder(seed, security, confirmedInputs, bundle, tag, totalValue, remainder, signatureFragments);
            }
            GetBalancesAndFormatResponse newinputs = this.getInputs(seed, security, 0, 0, totalValue, new String[0]);
            return this.addRemainder(seed, security, newinputs.getInputs(), bundle, tag, totalValue, remainder, signatureFragments);
        }
        bundle.finalize(SpongeFactory.create(SpongeFactory.Mode.KERL));
        bundle.addTrytes(signatureFragments);
        List<Transaction> trxb = bundle.getTransactions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Transaction trx : trxb) {
            arrayList.add(trx.toTrytes());
        }
        return arrayList;
    }

    public GetBalancesAndFormatResponse getInputs(String seed, int security, int start, int end, long threshold, String ... tips) throws ArgumentException {
        List<String> tipsList;
        if (!InputValidator.isValidSeed(seed)) {
            throw new IllegalStateException("Invalid seed provided.");
        }
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        if (start < 0 || start > end || end > start + 500) {
            throw new IllegalStateException("Invalid input provided.");
        }
        StopWatch stopWatch = new StopWatch();
        List<String> list = tipsList = tips != null ? Arrays.asList(tips) : null;
        if (end != 0) {
            ArrayList<String> allAddresses = new ArrayList<String>();
            for (int i = start; i < end; ++i) {
                String address = IotaAPIUtils.newAddress(seed, security, i, true, this.getCurl());
                allAddresses.add(address);
            }
            return this.getBalanceAndFormat(allAddresses, tipsList, threshold, start, stopWatch, security);
        }
        GetNewAddressResponse res = this.generateNewAddresses(seed, security, true, start, threshold, true);
        return this.getBalanceAndFormat(res.getAddresses(), tipsList, threshold, start, stopWatch, security);
    }

    public long getBalance(int threshold, String address) throws ArgumentException {
        GetBalancesResponse response = this.getBalances((Integer)threshold, new String[]{address}, null);
        try {
            return Long.parseLong(response.getBalances()[0]);
        }
        catch (NumberFormatException e) {
            throw new ArgumentException(e.getMessage());
        }
    }

    public GetBalancesAndFormatResponse getBalanceAndFormat(List<String> addresses, List<String> tips, long threshold, int start, StopWatch stopWatch, int security) throws ArgumentException, IllegalStateException {
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        StopWatch suppliedStopWatch = stopWatch;
        if (suppliedStopWatch == null) {
            suppliedStopWatch = new StopWatch();
        }
        GetBalancesResponse getBalancesResponse = this.getBalances((Integer)100, addresses, tips);
        List<String> balances = Arrays.asList(getBalancesResponse.getBalances());
        boolean thresholdReached = threshold == 0L;
        ArrayList<Input> inputs = new ArrayList<Input>();
        long totalBalance = 0L;
        for (int i = 0; i < addresses.size(); ++i) {
            long balance = Long.parseLong(balances.get(i));
            if (balance <= 0L) continue;
            Input newEntry = new Input(addresses.get(i), balance, start + i, security);
            inputs.add(newEntry);
            if (thresholdReached || (totalBalance += balance) < threshold) continue;
            thresholdReached = true;
            break;
        }
        if (thresholdReached) {
            return GetBalancesAndFormatResponse.create(inputs, totalBalance, stopWatch.getElapsedTimeMili());
        }
        throw new IllegalStateException("Not enough balance.");
    }

    public GetBundleResponse getBundle(String transaction) throws ArgumentException {
        if (!InputValidator.isHash(transaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        StopWatch stopWatch = new StopWatch();
        Bundle bundle = this.traverseBundle(transaction, null, new Bundle());
        if (bundle == null) {
            throw new ArgumentException("Invalid bundle.");
        }
        if (!BundleValidator.isBundle(bundle)) {
            throw new ArgumentException("Invalid bundle.");
        }
        return GetBundleResponse.create(bundle.getTransactions(), stopWatch.getElapsedTimeMili());
    }

    public GetAccountDataResponse getAccountData(String seed, int security, int index, boolean checksum, int total, boolean returnAll, int start, int end, boolean inclusionStates, long threshold) throws ArgumentException {
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        if (start < 0 || start > end || end > start + 1000) {
            throw new ArgumentException("Invalid input provided.");
        }
        StopWatch stopWatch = new StopWatch();
        GetNewAddressResponse gna = this.getNewAddress(seed, security, index, checksum, total, returnAll);
        GetTransferResponse gtr = this.getTransfers(seed, security, start, end, inclusionStates);
        GetBalancesAndFormatResponse gbr = this.getInputs(seed, security, start, end, threshold, new String[0]);
        return GetAccountDataResponse.create(gna.getAddresses(), gtr.getTransfers(), gbr.getInputs(), gbr.getTotalBalance(), stopWatch.getElapsedTimeMili());
    }

    public boolean[] checkWereAddressSpentFrom(String ... addresses) throws ArgumentException {
        WereAddressesSpentFromResponse response = this.wereAddressesSpentFrom(addresses);
        return response.getStates();
    }

    public Boolean checkWereAddressSpentFrom(String address) throws ArgumentException {
        String[] spentAddresses = new String[]{address};
        boolean[] response = this.checkWereAddressSpentFrom(spentAddresses);
        return response[0];
    }

    public ReplayBundleResponse replayBundle(String tailTransactionHash, int depth, int minWeightMagnitude, String reference) throws ArgumentException {
        if (!InputValidator.isHash(tailTransactionHash)) {
            throw new ArgumentException("Invalid tail hash provided.");
        }
        StopWatch stopWatch = new StopWatch();
        GetBundleResponse bundleResponse = this.getBundle(tailTransactionHash);
        Bundle bundle = new Bundle(bundleResponse.getTransactions(), bundleResponse.getTransactions().size());
        return this.replayBundle(bundle, depth, minWeightMagnitude, reference, stopWatch);
    }

    public ReplayBundleResponse replayBundle(Bundle bundle, int depth, int minWeightMagnitude, String reference) throws ArgumentException {
        return this.replayBundle(bundle, depth, minWeightMagnitude, reference, new StopWatch());
    }

    private ReplayBundleResponse replayBundle(Bundle bundle, int depth, int minWeightMagnitude, String reference, StopWatch stopWatch) throws ArgumentException {
        ArrayList<String> bundleTrytes = new ArrayList<String>();
        for (Transaction trx : bundle.getTransactions()) {
            bundleTrytes.add(trx.toTrytes());
        }
        List<Transaction> trxs = this.sendTrytes(bundleTrytes.toArray(new String[bundleTrytes.size()]), depth, minWeightMagnitude, reference);
        Boolean[] successful = new Boolean[trxs.size()];
        for (int i = 0; i < trxs.size(); ++i) {
            FindTransactionResponse response = this.findTransactionsByBundles(trxs.get(i).getBundle());
            successful[i] = response.getHashes().length != 0;
        }
        return ReplayBundleResponse.create(new Bundle(trxs), successful, stopWatch.getElapsedTimeMili());
    }

    public GetInclusionStateResponse getLatestInclusion(String ... hashes) throws ArgumentException {
        GetNodeInfoResponse getNodeInfoResponse = this.getNodeInfo();
        String[] latestMilestone = new String[]{getNodeInfoResponse.getLatestSolidSubtangleMilestone()};
        return this.getInclusionStates(hashes, latestMilestone);
    }

    public SendTransferResponse sendTransfer(String seed, int security, int depth, int minWeightMagnitude, List<Transfer> transfers, List<Input> inputs, String remainderAddress, boolean validateInputs, boolean validateInputAddresses, List<Transaction> tips) throws ArgumentException {
        StopWatch stopWatch = new StopWatch();
        List<String> trytes = this.prepareTransfers(seed, security, transfers, remainderAddress, inputs, tips, validateInputs);
        if (validateInputAddresses) {
            this.validateTransfersAddresses(seed, security, trytes);
        }
        String reference = tips != null && tips.size() > 0 ? tips.get(0).getHash() : null;
        List<Transaction> trxs = this.sendTrytes(trytes.toArray(new String[trytes.size()]), depth, minWeightMagnitude, reference);
        Boolean[] successful = new Boolean[trxs.size()];
        for (int i = 0; i < trxs.size(); ++i) {
            FindTransactionResponse response = this.findTransactionsByBundles(trxs.get(i).getBundle());
            successful[i] = response.getHashes().length != 0;
        }
        return SendTransferResponse.create(trxs, successful, stopWatch.getElapsedTimeMili());
    }

    public Bundle traverseBundle(String trunkTx, String bundleHash, Bundle bundle) throws ArgumentException {
        GetTrytesResponse gtr = this.getTrytes(trunkTx);
        if (gtr != null) {
            if (gtr.getTrytes().length == 0) {
                throw new ArgumentException("Invalid bundle.");
            }
            Transaction trx = new Transaction(gtr.getTrytes()[0], SpongeFactory.create(SpongeFactory.Mode.CURLP81));
            if (trx.getBundle() == null) {
                throw new ArgumentException("Invalid trytes provided.");
            }
            if (bundleHash == null && trx.getCurrentIndex() != 0L) {
                throw new ArgumentException("Invalid tail hash provided.");
            }
            if (bundleHash == null) {
                bundleHash = trx.getBundle();
            }
            if (!bundleHash.equals(trx.getBundle())) {
                bundle.setLength(bundle.getTransactions().size());
                return bundle;
            }
            if (trx.getLastIndex() == 0L && trx.getCurrentIndex() == 0L) {
                return new Bundle(Collections.singletonList(trx), 1);
            }
            trunkTx = trx.getTrunkTransaction();
            bundle.getTransactions().add(trx);
            return this.traverseBundle(trunkTx, bundleHash, bundle);
        }
        throw new ArgumentException("Get trytes response was null.");
    }

    public List<Transaction> initiateTransfer(int securitySum, String inputAddress, String remainderAddress, List<Transfer> transfers) throws ArgumentException {
        return this.initiateTransfer(securitySum, inputAddress, remainderAddress, transfers, null, false);
    }

    public List<Transaction> initiateTransfer(int securitySum, String inputAddress, String remainderAddress, List<Transfer> transfers, List<Transaction> tips) throws ArgumentException {
        return this.initiateTransfer(securitySum, inputAddress, remainderAddress, transfers, tips, false);
    }

    public List<Transaction> initiateTransfer(int securitySum, String inputAddress, String remainderAddress, List<Transfer> transfers, boolean testMode) throws ArgumentException {
        return this.initiateTransfer(securitySum, inputAddress, remainderAddress, transfers, null, testMode);
    }

    public List<Transaction> initiateTransfer(int securitySum, String inputAddress, String remainderAddress, List<Transfer> transfers, List<Transaction> tips, boolean testMode) throws ArgumentException {
        if (securitySum < 1) {
            throw new ArgumentException("Invalid security level provided.");
        }
        if (!InputValidator.isAddress(inputAddress)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        if (remainderAddress != null && !InputValidator.isAddress(remainderAddress)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        if (!InputValidator.isTransfersCollectionValid(transfers)) {
            throw new ArgumentException("Invalid transfers provided.");
        }
        Bundle bundle = new Bundle();
        int totalValue = 0;
        ArrayList<String> signatureFragments = new ArrayList<String>();
        String tag = "";
        for (Transfer transfer : transfers) {
            transfer.setAddress(Checksum.removeChecksum(transfer.getAddress()));
            int signatureMessageLength = 1;
            if (transfer.getMessage().length() > 2187) {
                signatureMessageLength = (int)((double)signatureMessageLength + Math.floor(transfer.getMessage().length() / 2187));
                String msgCopy = transfer.getMessage();
                while (!msgCopy.isEmpty()) {
                    String fragment = StringUtils.substring((String)msgCopy, (int)0, (int)2187);
                    msgCopy = StringUtils.substring((String)msgCopy, (int)2187, (int)msgCopy.length());
                    fragment = StringUtils.rightPad((String)fragment, (int)2187, (char)'9');
                    signatureFragments.add(fragment);
                }
            } else {
                String fragment = transfer.getMessage();
                if (transfer.getMessage().length() < 2187) {
                    fragment = StringUtils.rightPad((String)fragment, (int)2187, (char)'9');
                }
                signatureFragments.add(fragment);
            }
            tag = transfer.getTag();
            if (transfer.getTag().length() < 27) {
                tag = StringUtils.rightPad((String)tag, (int)27, (char)'9');
            }
            long timestamp = (long)Math.floor(Calendar.getInstance().getTimeInMillis() / 1000L);
            bundle.addEntry(signatureMessageLength, transfer.getAddress(), transfer.getValue(), tag, timestamp);
            totalValue = (int)((long)totalValue + transfer.getValue());
        }
        if (totalValue != 0) {
            for (Transfer transfer : transfers) {
                if (InputValidator.hasTrailingZeroTrit(transfer.getAddress())) continue;
                throw new ArgumentException("Invalid addresses provided.");
            }
            ArrayList<String> tipHashes = null;
            if (tips != null) {
                tipHashes = new ArrayList<String>(tips.size());
                for (Transaction tx : tips) {
                    tipHashes.add(tx.getHash());
                }
            }
            GetBalancesResponse getBalancesResponse = this.getBalances((Integer)100, Collections.singletonList(inputAddress), tipHashes);
            String[] balances = getBalancesResponse.getBalances();
            long totalBalance = 0L;
            for (String balance : balances) {
                long thisBalance = Long.parseLong(balance);
                totalBalance += thisBalance;
            }
            long timestamp = (long)Math.floor(Calendar.getInstance().getTimeInMillis() / 1000L);
            if (testMode) {
                totalBalance += 1000L;
            }
            if (totalBalance > 0L) {
                long toSubtract = 0L - totalBalance;
                bundle.addEntry(securitySum, Checksum.removeChecksum(inputAddress), toSubtract, tag, timestamp);
            }
            if ((long)totalValue > totalBalance) {
                throw new IllegalStateException("Not enough balance.");
            }
            if (totalBalance > (long)totalValue) {
                long remainder = totalBalance - (long)totalValue;
                if (remainderAddress == null) {
                    throw new IllegalStateException("No remainder address defined.");
                }
                bundle.addEntry(1, remainderAddress, remainder, tag, timestamp);
            }
            bundle.finalize(SpongeFactory.create(SpongeFactory.Mode.KERL));
            bundle.addTrytes(signatureFragments);
            return bundle.getTransactions();
        }
        throw new RuntimeException("Invalid value transfer: the transfer does not require a signature.");
    }

    public void validateTransfersAddresses(String seed, int security, List<String> trytes) throws ArgumentException {
        HashSet<String> addresses = new HashSet<String>();
        ArrayList<Transaction> inputTransactions = new ArrayList<Transaction>();
        ArrayList<String> inputAddresses = new ArrayList<String>();
        for (String trx : trytes) {
            Transaction transaction = new Transaction(trx, SpongeFactory.create(SpongeFactory.Mode.CURLP81));
            addresses.add(Checksum.addChecksum(transaction.getAddress()));
            inputTransactions.add(transaction);
        }
        String[] hashes = this.findTransactionsByAddresses(addresses.toArray(new String[addresses.size()])).getHashes();
        List<Transaction> transactions = this.findTransactionsObjectsByHashes(hashes);
        GetNewAddressResponse gna = this.generateNewAddresses(seed, security, true, 0, 0L, false);
        GetBalancesAndFormatResponse gbr = this.getInputs(seed, security, 0, 0, 0L, new String[0]);
        for (Input input : gbr.getInputs()) {
            inputAddresses.add(Checksum.addChecksum(input.getAddress()));
        }
        for (Transaction trx : inputTransactions) {
            if (trx.getValue() <= 0L) continue;
            if (inputAddresses.contains(trx.getAddress())) {
                throw new ArgumentException("Send to inputs!");
            }
            if (InputValidator.hasTrailingZeroTrit(trx.getAddress())) continue;
            throw new ArgumentException("Invalid addresses provided.");
        }
        for (Transaction trx : transactions) {
            if (trx.getValue() < 0L && !inputAddresses.contains(trx.getAddress())) {
                throw new ArgumentException("Sending to a used address.");
            }
            if (trx.getValue() >= 0L || !gna.getAddresses().contains(trx.getAddress())) continue;
            throw new ArgumentException("Private key reuse detect!");
        }
    }

    public List<String> addRemainder(String seed, int security, List<Input> inputs, Bundle bundle, String tag, long totalValue, String remainderAddress, List<String> signatureFragments) throws ArgumentException {
        if (!InputValidator.isValidSeed(seed)) {
            throw new IllegalStateException("Invalid seed provided.");
        }
        if (remainderAddress != null && !InputValidator.checkAddress(remainderAddress)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        if (!InputValidator.areValidInputsList(inputs)) {
            throw new ArgumentException("Invalid input provided.");
        }
        long totalTransferValue = totalValue;
        for (int i = 0; i < inputs.size(); ++i) {
            long thisBalance = inputs.get(i).getBalance();
            long toSubtract = 0L - thisBalance;
            long timestamp = (long)Math.floor(Calendar.getInstance().getTimeInMillis() / 1000L);
            bundle.addEntry(security, Checksum.removeChecksum(inputs.get(i).getAddress()), toSubtract, tag, timestamp);
            if (thisBalance >= totalTransferValue) {
                long remainder = thisBalance - totalTransferValue;
                if (remainder > 0L && remainderAddress != null) {
                    bundle.addEntry(1, Checksum.removeChecksum(remainderAddress), remainder, tag, timestamp);
                    return IotaAPIUtils.signInputsAndReturn(seed, inputs, bundle, signatureFragments, this.getCurl());
                }
                if (remainder > 0L) {
                    GetNewAddressResponse res = this.getNextAvailableAddress(seed, security, false);
                    bundle.addEntry(1, res.getAddresses().get(0), remainder, tag, timestamp);
                    return IotaAPIUtils.signInputsAndReturn(seed, inputs, bundle, signatureFragments, this.getCurl());
                }
                return IotaAPIUtils.signInputsAndReturn(seed, inputs, bundle, signatureFragments, this.getCurl());
            }
            totalTransferValue -= thisBalance;
        }
        throw new IllegalStateException("Not enough balance.");
    }

    public boolean isPromotable(Transaction tail) throws ArgumentException {
        long lowerBound = tail.getAttachmentTimestamp();
        CheckConsistencyResponse consistencyResponse = this.checkConsistency(tail.getHash());
        return consistencyResponse.getState() && this.isAboveMaxDepth(lowerBound);
    }

    public boolean isPromotable(String tail) throws ArgumentException {
        GetTrytesResponse transaction = this.getTrytes(tail);
        if (0 == transaction.getTrytes().length) {
            throw new ArgumentException("Transaction was not found on the node");
        }
        return this.isPromotable(new Transaction(transaction.getTrytes()[0]));
    }

    private boolean isAboveMaxDepth(long attachmentTimestamp) {
        return attachmentTimestamp < System.currentTimeMillis() && System.currentTimeMillis() - attachmentTimestamp < 660000L;
    }

    public List<Transaction> promoteTransaction(String tail, int depth, int minWeightMagnitude, Bundle bundle) throws BaseException {
        if (bundle == null || bundle.getTransactions().size() == 0) {
            throw new ArgumentException("Need at least one transaction in the bundle");
        }
        if (depth < 0) {
            throw new ArgumentException("Depth must be >= 0");
        }
        if (minWeightMagnitude <= 0) {
            throw new ArgumentException("MinWeightMagnitude must be > 0");
        }
        CheckConsistencyResponse consistencyResponse = this.checkConsistency(tail);
        if (!consistencyResponse.getState()) {
            throw new NotPromotableException(consistencyResponse.getInfo());
        }
        GetTransactionsToApproveResponse transactionsToApprove = this.getTransactionsToApprove(depth, tail);
        GetAttachToTangleResponse res = this.attachToTangle(transactionsToApprove.getTrunkTransaction(), transactionsToApprove.getBranchTransaction(), minWeightMagnitude, (String[])bundle.getTransactions().stream().map(tx -> tx.toTrytes()).toArray(String[]::new));
        try {
            this.storeAndBroadcast(res.getTrytes());
        }
        catch (ArgumentException e) {
            return Collections.emptyList();
        }
        return Arrays.stream(res.getTrytes()).map(trytes -> new Transaction((String)trytes, this.getCurl())).collect(Collectors.toList());
    }

    public static class Builder
    extends ApiBuilder<Builder, IotaAPI> {
        @Override
        protected IotaAPI compile() {
            return new IotaAPI(this);
        }
    }
}

