/*
 * Decompiled with CFR 0.152.
 */
package threads.iota;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.Room;
import java.util.ArrayList;
import java.util.List;
import threads.iota.Entity;
import threads.iota.Hash;
import threads.iota.HashDatabase;
import threads.iota.IOTA;

public class NotificationService {
    private static final String TAG = NotificationService.class.getSimpleName();
    private static NotificationService SINGLETON = null;
    @NonNull
    private final HashDatabase hashDatabase;

    private NotificationService(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        this.hashDatabase = (HashDatabase)Room.databaseBuilder((Context)context, HashDatabase.class, (String)HashDatabase.class.getSimpleName()).fallbackToDestructiveMigration().build();
    }

    @NonNull
    public static NotificationService getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (SINGLETON == null) {
            SINGLETON = new NotificationService(context);
        }
        return SINGLETON;
    }

    @NonNull
    public HashDatabase getHashDatabase() {
        return this.hashDatabase;
    }

    @NonNull
    public List<String> getNotifications(@NonNull String address, @NonNull String protocol, @NonNull String host, int port, int timeout) {
        IOTA iota = new IOTA.Builder().protocol(protocol).timeout(timeout).host(host).port(port).build();
        final ArrayList<String> notifications = new ArrayList<String>();
        iota.loadAddressTransactions(new IOTA.Filter(){

            @Override
            public boolean acceptHash(@NonNull String hash) {
                return !NotificationService.this.hasHash(hash);
            }

            @Override
            public void invalidHash(@NonNull String hash) {
                Hash transactionHash = NotificationService.this.createHash(hash);
                NotificationService.this.insertHash(transactionHash);
            }

            @Override
            public boolean acceptEntity(@NonNull Entity entity) {
                boolean result = true;
                String hash = entity.getHash();
                if (NotificationService.this.hasHash(hash)) {
                    result = false;
                } else {
                    Hash transactionHash = NotificationService.this.createHash(hash);
                    NotificationService.this.insertHash(transactionHash);
                }
                return result;
            }

            @Override
            public void loadEntity(@NonNull Entity entity) {
                notifications.add(entity.getContent());
            }

            @Override
            public void invalidEntity(@NonNull Entity entity) {
                String hash = entity.getHash();
                Hash transactionHash = NotificationService.this.createHash(hash);
                NotificationService.this.insertHash(transactionHash);
            }

            @Override
            public void error(@NonNull Entity entity, @NonNull Throwable e) {
                String hash = entity.getHash();
                Hash transactionHash = NotificationService.this.createHash(hash);
                NotificationService.this.insertHash(transactionHash);
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }

            @Override
            public int getPartionFactor() {
                return 20;
            }
        }, address);
        return notifications;
    }

    private boolean hasHash(@NonNull String hash) {
        return this.getHashDatabase().hashDao().hasHash(hash) > 0L;
    }

    private Hash createHash(@NonNull String hash) {
        Preconditions.checkNotNull((Object)hash);
        return new Hash(hash, System.currentTimeMillis());
    }

    private void insertHash(@NonNull Hash hash) {
        Preconditions.checkNotNull((Object)hash);
        this.getHashDatabase().hashDao().insertHash(hash);
    }
}

