/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Transaction;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.InputValidator;

public class Signing {
    private ICurl curl;

    public Signing() {
        this(Optional.empty());
    }

    public Signing(ICurl curl) {
        this(curl != null ? Optional.of(curl) : Optional.empty());
    }

    public Signing(Optional<ICurl> curl) {
        this.curl = curl == null || !curl.isPresent() ? SpongeFactory.create(SpongeFactory.Mode.KERL) : curl.get();
    }

    public int[] subseed(int[] inSeed, int index) throws ArgumentException {
        if (index < 0) {
            throw new ArgumentException("Invalid index provided.");
        }
        int[] seed = (int[])inSeed.clone();
        block0: for (int i = 0; i < index; ++i) {
            for (int j = 0; j < seed.length; ++j) {
                int n = j;
                seed[n] = seed[n] + 1;
                if (seed[n] <= 1) continue block0;
                seed[j] = -1;
            }
        }
        return seed;
    }

    public int[] key(int[] inSeed, int index) throws ArgumentException {
        return this.key(inSeed, index, (int)Math.floor(inSeed.length / 6561));
    }

    public int[] key(int[] inSeed, int index, int security) throws ArgumentException {
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        if (inSeed.length % 3 != 0) {
            throw new ArgumentException("Invalid seed provided.");
        }
        int[] seed = this.subseed(inSeed, index);
        ICurl curl = this.getICurlObject(SpongeFactory.Mode.KERL);
        curl.reset();
        curl.absorb(seed, 0, seed.length);
        curl.squeeze(seed, 0, seed.length);
        curl.reset();
        curl.absorb(seed, 0, seed.length);
        int[] key = new int[security * 243 * 27];
        int[] buffer = new int[seed.length];
        int offset = 0;
        while (security-- > 0) {
            for (int i = 0; i < 27; ++i) {
                curl.squeeze(buffer, 0, seed.length);
                System.arraycopy(buffer, 0, key, offset, 243);
                offset += 243;
            }
        }
        return key;
    }

    public int[] address(int[] digests) {
        int[] address = new int[243];
        ICurl curl = this.getICurlObject(SpongeFactory.Mode.KERL);
        curl.reset().absorb(digests).squeeze(address);
        return address;
    }

    public int[] digests(int[] key) throws ArgumentException {
        int security = (int)Math.floor(key.length / 6561);
        if (!InputValidator.isValidSecurityLevel(security)) {
            throw new ArgumentException("Invalid security level provided.");
        }
        int[] digests = new int[security * 243];
        int[] keyFragment = new int[6561];
        ICurl curl = this.getICurlObject(SpongeFactory.Mode.KERL);
        int i = 0;
        while ((double)i < Math.floor(key.length / 6561)) {
            System.arraycopy(key, i * 6561, keyFragment, 0, 6561);
            for (int j = 0; j < 27; ++j) {
                for (int k = 0; k < 26; ++k) {
                    curl.reset().absorb(keyFragment, j * 243, 243).squeeze(keyFragment, j * 243, 243);
                }
            }
            curl.reset();
            curl.absorb(keyFragment, 0, keyFragment.length);
            curl.squeeze(digests, i * 243, 243);
            ++i;
        }
        return digests;
    }

    public int[] digest(int[] normalizedBundleFragment, int[] signatureFragment) {
        this.curl.reset();
        ICurl jCurl = this.getICurlObject(SpongeFactory.Mode.KERL);
        int[] buffer = new int[243];
        for (int i = 0; i < 27; ++i) {
            buffer = Arrays.copyOfRange(signatureFragment, i * 243, (i + 1) * 243);
            int j = normalizedBundleFragment[i] + 13;
            while (j-- > 0) {
                jCurl.reset();
                jCurl.absorb(buffer);
                jCurl.squeeze(buffer);
            }
            this.curl.absorb(buffer);
        }
        this.curl.squeeze(buffer);
        return buffer;
    }

    public int[] signatureFragment(int[] normalizedBundleFragment, int[] keyFragment) {
        int[] signatureFragment = (int[])keyFragment.clone();
        for (int i = 0; i < 27; ++i) {
            for (int j = 0; j < 13 - normalizedBundleFragment[i]; ++j) {
                this.curl.reset().absorb(signatureFragment, i * 243, 243).squeeze(signatureFragment, i * 243, 243);
            }
        }
        return signatureFragment;
    }

    public Boolean validateSignatures(Bundle signedBundle, String inputAddress) {
        String bundleHash = "";
        ArrayList<String> signatureFragments = new ArrayList<String>();
        for (int i = 0; i < signedBundle.getTransactions().size(); ++i) {
            Transaction trx = signedBundle.getTransactions().get(i);
            if (!trx.getAddress().equals(inputAddress)) continue;
            bundleHash = trx.getBundle();
            String signatureFragment = trx.getSignatureFragments();
            if (InputValidator.isNinesTrytes(signatureFragment, signatureFragment.length())) break;
            signatureFragments.add(signatureFragment);
        }
        return this.validateSignatures(inputAddress, signatureFragments.toArray(new String[signatureFragments.size()]), bundleHash);
    }

    public Boolean validateSignatures(String expectedAddress, String[] signatureFragments, String bundleHash) {
        Bundle bundle = new Bundle();
        int[][] normalizedBundleFragments = new int[3][27];
        int[] normalizedBundleHash = bundle.normalizedBundle(bundleHash);
        for (int i = 0; i < 3; ++i) {
            normalizedBundleFragments[i] = Arrays.copyOfRange(normalizedBundleHash, i * 27, (i + 1) * 27);
        }
        int[] digests = new int[signatureFragments.length * 243];
        for (int i = 0; i < signatureFragments.length; ++i) {
            int[] digestBuffer = this.digest(normalizedBundleFragments[i % 3], Converter.trits(signatureFragments[i]));
            System.arraycopy(digestBuffer, 0, digests, i * 243, 243);
        }
        String address = Converter.trytes(this.address(digests));
        return expectedAddress.equals(address);
    }

    private ICurl getICurlObject(SpongeFactory.Mode mode) {
        return SpongeFactory.create(mode);
    }

    public int[] normalizedBundle(String bundleHash) {
        int[] normalizedBundle = new int[81];
        for (int i = 0; i < 3; ++i) {
            int j;
            long sum = 0L;
            for (j = 0; j < 27; ++j) {
                int n = Converter.value(Converter.trits("" + bundleHash.charAt(i * 27 + j)));
                normalizedBundle[i * 27 + j] = n;
                sum += (long)n;
            }
            if (sum >= 0L) {
                block2: while (sum-- > 0L) {
                    for (j = 0; j < 27; ++j) {
                        if (normalizedBundle[i * 27 + j] <= -13) continue;
                        int n = i * 27 + j;
                        normalizedBundle[n] = normalizedBundle[n] - 1;
                        continue block2;
                    }
                }
                continue;
            }
            block4: while (sum++ < 0L) {
                for (j = 0; j < 27; ++j) {
                    if (normalizedBundle[i * 27 + j] >= 13) continue;
                    int n = i * 27 + j;
                    normalizedBundle[n] = normalizedBundle[n] + 1;
                    continue block4;
                }
            }
        }
        return normalizedBundle;
    }
}

