/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum Status {
    INIT(0),
    SEMI(1),
    DONE(2),
    DELETING(3),
    ERROR(5);

    @NonNull
    private final Integer code;

    private Status(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static Status toStatus(Integer status) {
        Preconditions.checkNotNull((Object)status);
        if (status.equals(DONE.getCode())) {
            return DONE;
        }
        if (status.equals(SEMI.getCode())) {
            return SEMI;
        }
        if (status.equals(INIT.getCode())) {
            return INIT;
        }
        if (status.equals(DELETING.getCode())) {
            return DELETING;
        }
        if (status.equals(ERROR.getCode())) {
            return ERROR;
        }
        throw new IllegalArgumentException("Could not recognize status");
    }

    @TypeConverter
    public static Integer toInteger(Status status) {
        Preconditions.checkNotNull((Object)((Object)status));
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return this.code;
    }
}

