/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Objects;
import threads.core.api.Addresses;
import threads.core.api.Entity;
import threads.core.api.MultiAddresses;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class PeerInfo
extends Entity {
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="pid")
    private final String pid;
    @NonNull
    @TypeConverters(value={Addresses.class})
    @ColumnInfo(name="addresses")
    private Addresses addresses = new Addresses();
    @NonNull
    @TypeConverters(value={MultiAddresses.class})
    @ColumnInfo(name="multiAddresses")
    private MultiAddresses multiAddresses = new MultiAddresses();

    PeerInfo(@NonNull String pid) {
        this.pid = pid;
    }

    public static PeerInfo createPeerInfo(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return new PeerInfo(pid.getPid());
    }

    @NonNull
    String getPid() {
        return this.pid;
    }

    public PID getPID() {
        return PID.create((String)this.pid);
    }

    @NonNull
    public MultiAddresses getMultiAddresses() {
        return (MultiAddresses)this.multiAddresses.clone();
    }

    public void setMultiAddresses(@NonNull MultiAddresses multiAddresses) {
        this.multiAddresses = multiAddresses;
    }

    @NonNull
    public Addresses getAddresses() {
        return (Addresses)this.addresses.clone();
    }

    public void setAddresses(@NonNull Addresses addresses) {
        this.addresses = addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerInfo peer = (PeerInfo)o;
        return Objects.equals(this.pid, peer.pid);
    }

    public int hashCode() {
        return Objects.hash(this.pid);
    }

    public void addMultiAddresses(@NonNull String address) {
        Preconditions.checkNotNull((Object)address);
        if (!this.multiAddresses.contains(address)) {
            this.multiAddresses.add(address);
        }
    }

    public void removeMultiAddresses(@NonNull String address) {
        Preconditions.checkNotNull((Object)address);
        this.multiAddresses.remove(address);
    }

    public void removeMultiAddresses() {
        this.multiAddresses.clear();
    }

    public void addAddress(@NonNull String relayPid, @NonNull String address) {
        Preconditions.checkNotNull((Object)relayPid);
        Preconditions.checkNotNull((Object)address);
        this.addresses.put(relayPid, address);
    }

    public void removeAddresses() {
        this.addresses.clear();
    }

    public void removeAddress(@NonNull String relayPid) {
        Preconditions.checkNotNull((Object)relayPid);
        this.addresses.remove(relayPid);
    }

    public int numAddresses() {
        return this.addresses.size();
    }

    public boolean hasAddress(@NonNull PID pid) {
        return this.addresses.containsKey(pid.getPid());
    }

    public void addAddress(@NonNull PID pid, @NonNull String address) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)address);
        this.addresses.put(pid.getPid(), address);
    }

    public void removeAddress(@NonNull PID relay) {
        Preconditions.checkNotNull((Object)relay);
        this.addresses.remove(relay.getPid());
    }

    public String toString() {
        return "PeerInfo{pid='" + this.pid + '\'' + ", timestamp=" + this.getTimestamp() + ", addresses=" + this.addresses + ", multiAddresses=" + this.multiAddresses + '}';
    }
}

