/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import threads.core.Network;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Peer;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.ipfs.api.PeerInfo;

public class GatewayService {
    public static final String TAG = GatewayService.class.getSimpleName();

    public static int evaluateAllPeers(@NonNull Context context) {
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        Preconditions.checkNotNull((Object)ipfs);
        threads.resetPeersConnected();
        List peers = ipfs.swarmPeers();
        int size = peers.size();
        for (threads.ipfs.api.Peer peer : peers) {
            if (peer.getMultiAddress().endsWith("/p2p-circuit")) continue;
            GatewayService.storePeer(context, peer);
        }
        if (Network.isConnectedMinHighBandwidth(context)) {
            List<Peer> stored = threads.getPeers();
            for (Peer peer : stored) {
                if (peer.isConnected() || peer.isRelay() || peer.isAutonat() || peer.isPubsub()) continue;
                threads.removePeer(ipfs, peer);
            }
        }
        return size;
    }

    public static int evaluatePeers(@NonNull Context context, boolean pubsubs) {
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Preconditions.checkNotNull((Object)ipfs);
        List peers = ipfs.swarmPeers();
        int size = peers.size();
        for (threads.ipfs.api.Peer peer : peers) {
            if (peer.getMultiAddress().endsWith("/p2p-circuit")) continue;
            if (pubsubs) {
                if (!peer.isAutonat() && !peer.isRelay() && !peer.isMeshSub() && !peer.isFloodSub()) continue;
                GatewayService.storePeer(context, peer);
                continue;
            }
            if (!peer.isAutonat() && !peer.isRelay()) continue;
            GatewayService.storePeer(context, peer);
        }
        return size;
    }

    public static synchronized List<Peer> getRelayPeers(@NonNull Context context, @NonNull String tag, int numRelays, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numRelays >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Peer> result = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return result;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            peers.sort(threads.ipfs.api.Peer::compareTo);
            for (threads.ipfs.api.Peer peer : peers) {
                if (result.size() == numRelays) break;
                if (!peer.isRelay()) continue;
                if (ipfs.isConnected(peer.getPid())) {
                    if (!tag.isEmpty()) {
                        ipfs.protectPeer(peer.getPid(), tag);
                    }
                    result.add(GatewayService.storePeer(context, peer));
                    continue;
                }
                if (!ipfs.swarmConnect(peer, timeout)) continue;
                if (!tag.isEmpty()) {
                    ipfs.protectPeer(peer.getPid(), tag);
                }
                result.add(GatewayService.storePeer(context, peer));
            }
        }
        return result;
    }

    public static List<Peer> getConnectedPeers(@NonNull Context context, @NonNull String tag, int numPeers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)tag);
        ArrayList<Peer> connected = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return connected;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            peers.sort(threads.ipfs.api.Peer::compareTo);
            for (threads.ipfs.api.Peer peer : peers) {
                if (connected.size() == numPeers) break;
                if (!ipfs.isConnected(peer.getPid())) continue;
                if (!tag.isEmpty()) {
                    ipfs.protectPeer(peer.getPid(), tag);
                }
                connected.add(GatewayService.storePeer(context, peer));
            }
        }
        return connected;
    }

    private static Peer storePeer(@NonNull Context context, @NonNull threads.ipfs.api.Peer peer) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        int rating = 0;
        try {
            double latency = peer.getLatency();
            if (latency < 1000.0) {
                rating = (int)(1000.0 - latency);
            }
        }
        catch (Throwable latency) {
            // empty catch block
        }
        boolean isConnected = false;
        try {
            int timeout = 5;
            IPFS ipfs = Singleton.getInstance(context).getIpfs();
            if (ipfs != null) {
                PeerInfo info = ipfs.id(peer, timeout);
                if (info != null) {
                    String protocol = info.getProtocolVersion();
                    String agent = info.getAgentVersion();
                    rating = protocol != null && protocol.equals("ipfs/0.1.0") ? (rating += 100) : (rating -= 100);
                    if (agent != null) {
                        if (agent.startsWith("go-ipfs/0.4.2")) {
                            rating += 100;
                        } else if (agent.startsWith("go-ipfs/0.5")) {
                            rating += 150;
                        }
                    }
                }
                isConnected = ipfs.isConnected(peer.getPid());
            }
        }
        catch (Throwable timeout) {
            // empty catch block
        }
        if (rating < 0) {
            rating = 0;
        }
        boolean isPubsub = peer.isFloodSub() || peer.isMeshSub();
        return GatewayService.storePeer(context, peer.getPid(), peer.getMultiAddress(), peer.isRelay(), peer.isAutonat(), isPubsub, isConnected, rating);
    }

    @NonNull
    private static Peer storePeer(@NonNull Context context, @NonNull PID pid, @NonNull String multiAddress, boolean isRelay, boolean isAutonat, boolean isPubsub, boolean isConnected, int rating) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        Peer peer = threads.getPeerByPID(pid);
        if (peer != null) {
            peer.setMultiAddress(multiAddress);
            peer.setRating(rating);
            peer.setConnected(isConnected);
            threads.updatePeer(peer);
        } else {
            peer = threads.createPeer(pid, multiAddress);
            peer.setRelay(isRelay);
            peer.setAutonat(isAutonat);
            peer.setPubsub(isPubsub);
            peer.setRating(rating);
            peer.setConnected(isConnected);
            threads.storePeer(peer);
        }
        return peer;
    }

    public static List<Peer> connectStoredAutonat(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Peer> connected = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return connected;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getAutonatPeers();
            peers.sort(Peer::compareTo);
            for (Peer autonat : peers) {
                if (counter.get() == numConnections) break;
                if (ipfs.isConnected(autonat.getPID())) {
                    counter.incrementAndGet();
                    threads.setTimestamp(autonat, System.currentTimeMillis());
                    connected.add(autonat);
                    continue;
                }
                String ma = autonat.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + autonat.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    threads.setTimestamp(autonat, System.currentTimeMillis());
                    connected.add(autonat);
                    continue;
                }
                if (!Network.isConnectedMinHighBandwidth(context) || !GatewayService.lifeTimeExpired(autonat)) continue;
                threads.removePeer(ipfs, autonat);
            }
        }
        return connected;
    }

    private static boolean lifeTimeExpired(@NonNull Peer peer) {
        return System.currentTimeMillis() > peer.getTimestamp() + TimeUnit.HOURS.toMillis(24L);
    }

    public static List<Peer> connectStoredPubsub(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Peer> connected = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return connected;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getPubsubPeers();
            peers.sort(Peer::compareTo);
            for (Peer pubsub : peers) {
                if (counter.get() == numConnections) break;
                if (ipfs.isConnected(pubsub.getPID())) {
                    counter.incrementAndGet();
                    threads.setTimestamp(pubsub, System.currentTimeMillis());
                    connected.add(pubsub);
                    continue;
                }
                String ma = pubsub.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + pubsub.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    threads.setTimestamp(pubsub, System.currentTimeMillis());
                    connected.add(pubsub);
                    continue;
                }
                if (!Network.isConnectedMinHighBandwidth(context) || !GatewayService.lifeTimeExpired(pubsub)) continue;
                threads.removePeer(ipfs, pubsub);
            }
        }
        return connected;
    }

    public static List<Peer> connectStoredRelays(@NonNull Context context, @NonNull String tag, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)tag);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Peer> connected = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return connected;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getRelayPeers();
            peers.sort(Peer::compareTo);
            for (Peer relay : peers) {
                if (counter.get() == numConnections) break;
                if (ipfs.isConnected(relay.getPID())) {
                    counter.incrementAndGet();
                    threads.setTimestamp(relay, System.currentTimeMillis());
                    if (!tag.isEmpty()) {
                        ipfs.protectPeer(relay.getPID(), tag);
                    }
                    connected.add(relay);
                    continue;
                }
                String ma = relay.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + relay.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    threads.setTimestamp(relay, System.currentTimeMillis());
                    if (!tag.isEmpty()) {
                        ipfs.protectPeer(relay.getPID(), tag);
                    }
                    connected.add(relay);
                    continue;
                }
                if (!Network.isConnectedMinHighBandwidth(context) || !GatewayService.lifeTimeExpired(relay)) continue;
                threads.removePeer(ipfs, relay);
            }
        }
        return connected;
    }

    public static List<Peer> connectStoredPeers(@NonNull Context context, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Peer> connected = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return connected;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        if (ipfs != null) {
            List<Peer> peers = threads.getPeers();
            peers.sort(Peer::compareTo);
            for (Peer peer : peers) {
                if (!ipfs.isConnected(peer.getPID())) {
                    String ma = peer.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + peer.getPid();
                    if (!ipfs.swarmConnect(ma, timeout)) {
                        if (!Network.isConnectedMinHighBandwidth(context)) continue;
                        threads.removePeer(ipfs, peer);
                        continue;
                    }
                    connected.add(peer);
                    continue;
                }
                connected.add(peer);
            }
        }
        return connected;
    }
}

