package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import java.util.List;

@Dao
public interface ServerDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertServer(Server... servers);

    @Query("SELECT * FROM Server")
    LiveData<List<Server>> getLiveDataServers();

    @Delete
    void removeServer(Server server);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    void updateServer(Server server);

    @Query("SELECT * FROM Server")
    List<Server> getServers();


    @Query("DELETE FROM Server")
    void clear();

    @Query("UPDATE Server SET hash = :hash WHERE idx = :idx")
    void setHash(long idx, String hash);

    @Query("UPDATE Server SET bundle = :bundle WHERE idx = :idx")
    void setBundle(long idx, String bundle);


    @Query("SELECT * FROM Server WHERE idx = :idx")
    Server getServerByIdx(long idx);
}
