/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Server;
import threads.core.api.ServerDao;

public final class ServerDao_Impl
implements ServerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfServer;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfServer;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfServer;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;
    private final SharedSQLiteStatement __preparedStmtOfSetBundle;

    public ServerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfServer = new EntityInsertionAdapter<Server>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Server`(`host`,`port`,`protocol`,`alias`,`idx`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,nullif(?, 0),?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Server value) {
                if (value.getHost() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getHost());
                }
                stmt.bindLong(2, (long)value.getPort());
                if (value.getProtocol() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getProtocol());
                }
                if (value.getAlias() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAlias());
                }
                stmt.bindLong(5, value.getIdx());
                String _tmp = Additionals.toString(value.getAdditionals());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getBundle());
                }
                stmt.bindLong(9, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfServer = new EntityDeletionOrUpdateAdapter<Server>(__db){

            public String createQuery() {
                return "DELETE FROM `Server` WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Server value) {
                stmt.bindLong(1, value.getIdx());
            }
        };
        this.__updateAdapterOfServer = new EntityDeletionOrUpdateAdapter<Server>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Server` SET `host` = ?,`port` = ?,`protocol` = ?,`alias` = ?,`idx` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Server value) {
                if (value.getHost() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getHost());
                }
                stmt.bindLong(2, (long)value.getPort());
                if (value.getProtocol() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getProtocol());
                }
                if (value.getAlias() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAlias());
                }
                stmt.bindLong(5, value.getIdx());
                String _tmp = Additionals.toString(value.getAdditionals());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getBundle());
                }
                stmt.bindLong(9, value.getTimestamp());
                stmt.bindLong(10, value.getIdx());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Server";
                return "DELETE FROM Server";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Server SET hash = ? WHERE idx = ?";
                return "UPDATE Server SET hash = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetBundle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Server SET bundle = ? WHERE idx = ?";
                return "UPDATE Server SET bundle = ? WHERE idx = ?";
            }
        };
    }

    @Override
    public void insertServer(Server ... servers) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfServer.insert((Object[])servers);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void removeServer(Server server) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfServer.handle((Object)server);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateServer(Server server) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfServer.handle((Object)server);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(long idx, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(long idx, String bundle) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetBundle.acquire();
        int _argIndex = 1;
        if (bundle == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, bundle);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetBundle.release(_stmt);
        }
    }

    @Override
    public LiveData<List<Server>> getLiveDataServers() {
        String _sql = "SELECT * FROM Server";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Server", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Server"}, false, (Callable)new Callable<List<Server>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Server> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ServerDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"port");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Server> _result = new ArrayList<Server>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        int _tmpPort = _cursor.getInt(_cursorIndexOfPort);
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        Server _item = new Server(_tmpProtocol, _tmpHost, _tmpPort, _tmpAlias);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        String _tmp = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _item.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Server> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Server> getServers() {
        String _sql = "SELECT * FROM Server";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Server", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
            int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"port");
            int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Server> _result = new ArrayList<Server>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                int _tmpPort = _cursor.getInt(_cursorIndexOfPort);
                String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Server _item = new Server(_tmpProtocol, _tmpHost, _tmpPort, _tmpAlias);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Server> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Server getServerByIdx(long idx) {
        String _sql = "SELECT * FROM Server WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Server WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Server _result;
            int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
            int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"port");
            int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                int _tmpPort = _cursor.getInt(_cursorIndexOfPort);
                String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                _result = new Server(_tmpProtocol, _tmpHost, _tmpPort, _tmpAlias);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _result.setIdx(_tmpIdx);
                String _tmp = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Server server = _result;
            return server;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

