/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Thread;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

public class ThreadEncoder {
    @NonNull
    public static String convert(@NonNull Thread thread, @NonNull String aesKey) {
        CID image;
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        Content content = new Content();
        Gson gson = new Gson();
        content.put("exp", String.valueOf(thread.getExpireDate().getTime()));
        CID cid = thread.getCid();
        if (cid != null) {
            content.put("cid", cid.getCid());
        }
        if ((image = thread.getImage()) != null) {
            content.put("img", image.getCid());
        }
        content.put("alias", thread.getSenderAlias());
        content.put("sesKey", thread.getSesKey());
        content.put("date", String.valueOf(thread.getDate().getTime()));
        HashMap<String, String> additions = thread.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Additionals.toString(additions));
        content.put("pid", thread.getSenderPid().getPid());
        content.put("pubKey", thread.getSenderKey());
        String data = gson.toJson((Object)content);
        try {
            data = Encryption.encrypt((String)data, (String)aesKey);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return data;
    }
}

