package threads.core.api;

import androidx.room.RoomDatabase;

@androidx.room.Database(entities = {User.class,
        Thread.class, Note.class, Settings.class, Server.class}, version = 67, exportSchema = false)
public abstract class ThreadsDatabase extends RoomDatabase {


    public abstract UserDao userDao();

    public abstract ThreadDao threadDao();

    public abstract NoteDao noteDao();

    public abstract SettingsDao settingsDao();

    public abstract ServerDao serverDao();


    public void clear() {
        userDao().clear();
        threadDao().clear();
        noteDao().clear();
        settingsDao().clear();
        serverDao().clear();
    }

}
