package threads.core.api;

import androidx.annotation.NonNull;
import androidx.room.TypeConverter;

import static androidx.core.util.Preconditions.checkNotNull;

public enum PeerStatus {

    // BLOCKED is deprecated TODO (delete later 11.07.2017 -> delete 30.09.2017)

    OFFLINE(0),
    @Deprecated
    BLOCKED(1),
    ONLINE(2),
    DIALING(3);

    @NonNull
    private final Integer code;

    PeerStatus(@NonNull Integer code) {
        checkNotNull(code);
        this.code = code;
    }

    @TypeConverter
    public static PeerStatus toPeerStatus(Integer status) {
        checkNotNull(status);
        if (status.equals(PeerStatus.OFFLINE.getCode())) {
            return PeerStatus.OFFLINE;
        } else if (status.equals(PeerStatus.ONLINE.getCode())) {
            return PeerStatus.ONLINE;
        } else if (status.equals(PeerStatus.BLOCKED.getCode())) {
            return PeerStatus.BLOCKED;
        } else if (status.equals(PeerStatus.DIALING.getCode())) {
            return PeerStatus.DIALING;
        } else {
            throw new IllegalArgumentException("Could not recognize status");
        }
    }

    @TypeConverter
    public static Integer toInteger(PeerStatus status) {
        checkNotNull(status);
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return code;
    }
}
