/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import threads.core.THREADS;
import threads.core.api.AddressType;
import threads.core.api.Content;
import threads.core.api.Event;
import threads.core.api.EventsDatabase;
import threads.core.api.Kind;
import threads.core.api.LinkType;
import threads.core.api.Message;
import threads.core.api.MessageKind;
import threads.core.api.Note;
import threads.core.api.NoteDecoder;
import threads.core.api.NoteEncoder;
import threads.core.api.NotePublishDecoder;
import threads.core.api.NotePublishEncoder;
import threads.core.api.NoteRequestDecoder;
import threads.core.api.NoteRequestEncoder;
import threads.core.api.NoteStatus;
import threads.core.api.NoteType;
import threads.core.api.Peer;
import threads.core.api.PeerInfo;
import threads.core.api.PeerInfoDecoder;
import threads.core.api.PeerInfoEncoder;
import threads.core.api.PeersDatabase;
import threads.core.api.PeersInfoDatabase;
import threads.core.api.Server;
import threads.core.api.ServerDecoder;
import threads.core.api.ServerEncoder;
import threads.core.api.Settings;
import threads.core.api.Thread;
import threads.core.api.ThreadStatus;
import threads.core.api.ThreadsDatabase;
import threads.core.api.User;
import threads.core.api.UserDecoder;
import threads.core.api.UserEncoder;
import threads.core.api.UserStatus;
import threads.core.api.UserType;
import threads.iota.Entity;
import threads.iota.EntityService;
import threads.iota.Hash;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.CID;
import threads.ipfs.api.Multihash;
import threads.ipfs.api.PID;

public class ThreadsAPI {
    private static final String TAG = ThreadsAPI.class.getSimpleName();
    private final Gson gson = new Gson();
    private final ThreadsDatabase threadsDatabase;
    private final EventsDatabase eventsDatabase;
    private final PeersInfoDatabase peersInfoDatabase;
    private final PeersDatabase peersDatabase;
    private final EntityService entityService;

    public ThreadsAPI(@NonNull ThreadsDatabase threadsDatabase, @NonNull EventsDatabase eventsDatabase, @NonNull PeersInfoDatabase peersInfoDatabase, @NonNull PeersDatabase peersDatabase, @NonNull EntityService entityService) {
        Preconditions.checkNotNull((Object)((Object)threadsDatabase));
        Preconditions.checkNotNull((Object)((Object)eventsDatabase));
        Preconditions.checkNotNull((Object)((Object)peersInfoDatabase));
        Preconditions.checkNotNull((Object)((Object)peersDatabase));
        Preconditions.checkNotNull((Object)entityService);
        this.threadsDatabase = threadsDatabase;
        this.eventsDatabase = eventsDatabase;
        this.peersInfoDatabase = peersInfoDatabase;
        this.peersDatabase = peersDatabase;
        this.entityService = entityService;
    }

    @NonNull
    private PeersDatabase getPeersDatabase() {
        return this.peersDatabase;
    }

    @NonNull
    private PeersInfoDatabase getPeersInfoDatabase() {
        return this.peersInfoDatabase;
    }

    @NonNull
    private EventsDatabase getEventsDatabase() {
        return this.eventsDatabase;
    }

    @NonNull
    private ThreadsDatabase getThreadsDatabase() {
        return this.threadsDatabase;
    }

    @NonNull
    public String getRandomAddress() {
        return IOTA.generateAddress();
    }

    public int getUnreadNotes() {
        return this.getThreadsDatabase().threadDao().getUnreadNotes();
    }

    public void setThreadStatus(long idx, @NonNull ThreadStatus status) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().threadDao().setThreadStatus(idx, status);
    }

    public void setThreadsStatus(@NonNull ThreadStatus status, long ... idxs) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().threadDao().setThreadsStatus(status, idxs);
    }

    public void setThreadStatus(@NonNull ThreadStatus oldStatus, @NonNull ThreadStatus newStatus) {
        Preconditions.checkNotNull((Object)((Object)oldStatus));
        this.getThreadsDatabase().threadDao().setThreadStatus(oldStatus, newStatus);
    }

    public void setUserStatus(@NonNull UserStatus oldStatus, @NonNull UserStatus newStatus) {
        Preconditions.checkNotNull((Object)((Object)oldStatus));
        this.getThreadsDatabase().userDao().setUserStatus(oldStatus, newStatus);
    }

    public void setNoteStatus(@NonNull NoteStatus oldStatus, @NonNull NoteStatus newStatus) {
        Preconditions.checkNotNull((Object)((Object)oldStatus));
        this.getThreadsDatabase().noteDao().setNoteStatus(oldStatus, newStatus);
    }

    public void setNoteStatus(long idx, @NonNull NoteStatus status) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().noteDao().setNoteStatus(idx, status);
    }

    public void setNotesStatus(@NonNull NoteStatus status, long ... idxs) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().noteDao().setNotesStatus(status, idxs);
    }

    public void setImage(@NonNull Thread thread, @NonNull CID image) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)image);
        this.getThreadsDatabase().threadDao().setImage(thread.getIdx(), image);
    }

    public void setImage(@NonNull User user, @NonNull CID image) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)image);
        this.getThreadsDatabase().userDao().setImage(user.getPid(), image);
    }

    public void setImage(@NonNull Note note, @NonNull CID image) {
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)image);
        this.getThreadsDatabase().noteDao().setImage(note.getIdx(), image);
    }

    @NonNull
    public String getMimeType(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        return this.getThreadsDatabase().threadDao().getMimeType(thread.getIdx());
    }

    @NonNull
    public String getMimeType(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return this.getThreadsDatabase().noteDao().getMimeType(note.getIdx());
    }

    @Nullable
    public String getThreadMimeType(long idx) {
        return this.getThreadsDatabase().threadDao().getMimeType(idx);
    }

    @Nullable
    public String getNoteMimeType(long idx) {
        return this.getThreadsDatabase().noteDao().getMimeType(idx);
    }

    public void setThreadSenderAlias(@NonNull PID pid, @NonNull String alias) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)alias);
        this.getThreadsDatabase().threadDao().setSenderAlias(pid, alias);
    }

    public void setNoteSenderAlias(@NonNull PID pid, @NonNull String alias) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)alias);
        this.getThreadsDatabase().noteDao().setSenderAlias(pid, alias);
    }

    public void setMimeType(@NonNull Thread thread, @NonNull String mimeType) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)mimeType);
        this.getThreadsDatabase().threadDao().setMimeType(thread.getIdx(), mimeType);
    }

    public void setMimeType(@NonNull Note note, @NonNull String mimeType) {
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)mimeType);
        this.getThreadsDatabase().noteDao().setMimeType(note.getIdx(), mimeType);
    }

    @NonNull
    public List<Note> getNotes(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        return this.getNotesByThread(thread.getCid());
    }

    @NonNull
    private List<Note> getNotesByThread(@Nullable CID thread) {
        return this.getThreadsDatabase().noteDao().getNotesByThread(thread);
    }

    @NonNull
    public List<Note> loadNotes(@NonNull IOTA iota, @NonNull User user, @NonNull ThreadStatus threadStatus) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)((Object)threadStatus));
        ArrayList<Note> notes = new ArrayList<Note>();
        List<Thread> threads = this.getThreadsByThreadStatus(threadStatus);
        for (Thread thread : threads) {
            notes.addAll(this.loadNotes(iota, thread));
        }
        return notes;
    }

    public boolean isUserBlocked(@NonNull PID user) {
        Preconditions.checkNotNull((Object)user);
        return this.isUserBlocked(user.getPid());
    }

    public boolean isUserBlocked(@NonNull String pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getThreadsDatabase().userDao().isBlocked(pid);
    }

    @NonNull
    public List<Thread> loadPublishedThreads(@NonNull IOTA iota, final @NonNull String aesKey, @NonNull Integer maxNumberOfLoadedThreads, String ... addresses) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)addresses);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)maxNumberOfLoadedThreads);
        Preconditions.checkArgument((maxNumberOfLoadedThreads > 0 ? 1 : 0) != 0);
        final AtomicBoolean shouldContinue = new AtomicBoolean(true);
        final AtomicInteger maxNum = new AtomicInteger(maxNumberOfLoadedThreads);
        final AtomicInteger counter = new AtomicInteger(0);
        final ArrayList<Thread> threads = new ArrayList<Thread>();
        try {
            iota.loadTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    if (!shouldContinue.get()) {
                        return false;
                    }
                    return !ThreadsAPI.this.hasHash(hash);
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    if (!shouldContinue.get()) {
                        return;
                    }
                    Thread thread = NotePublishDecoder.convert(entity, aesKey);
                    if (thread != null) {
                        if (ThreadsAPI.this.isUserBlocked(thread.getSenderPid())) {
                            return;
                        }
                        if (ThreadsAPI.this.existsSameThread(thread)) {
                            return;
                        }
                        Date today = THREADS.getToday();
                        if (thread.getExpireDate().after(today)) {
                            threads.add(thread);
                            if (counter.incrementAndGet() > maxNum.get()) {
                                shouldContinue.set(false);
                            }
                        }
                    }
                }
            }, addresses);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return threads;
    }

    public boolean publishThreadRequestNote(@NonNull IPFS ipfs, @NonNull User user, @NonNull Note note) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((note.getKind() == Kind.OUT ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() == NoteType.THREAD_REQUEST ? 1 : 0) != 0);
        Preconditions.checkArgument((!user.getPid().isEmpty() ? 1 : 0) != 0);
        try {
            Content content = NoteRequestEncoder.convert(user.getPublicKey(), note);
            Preconditions.checkNotNull((Object)content);
            NoteType type = note.getNoteType();
            content.put("est", String.valueOf(type.getCode()));
            String hash = this.getHash(note);
            if (hash != null) {
                content.put("hash", hash);
            }
            this.sendNotification(ipfs, user.getPID(), content);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean insertThreadRequestNote(@NonNull IOTA iota, @NonNull User user, @NonNull Note note) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((note.getKind() == Kind.OUT ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() == NoteType.THREAD_REQUEST ? 1 : 0) != 0);
        Preconditions.checkArgument((!user.getPid().isEmpty() ? 1 : 0) != 0);
        try {
            Content content = NoteRequestEncoder.convert(user.getPublicKey(), note);
            Preconditions.checkNotNull((Object)content);
            String address = AddressType.getAddress(user.getPID(), AddressType.INBOX);
            Preconditions.checkNotNull((Object)address);
            Entity entity = iota.insertTransaction(address, this.gson.toJson((Object)content));
            Preconditions.checkNotNull((Object)entity);
            String hash = entity.getHash();
            Hash transactionHash = this.createHash(hash);
            this.insertHash(transactionHash);
            this.setHash(note, hash);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean insertThreadPublishNote(@NonNull IOTA iota, @NonNull Note note, @NonNull String address, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((note.getKind() == Kind.OUT ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() == NoteType.THREAD_PUBLISH ? 1 : 0) != 0);
        try {
            Thread thread = this.getThread(note);
            Preconditions.checkNotNull((Object)thread);
            String dataTransaction = NotePublishEncoder.convert(thread, aesKey);
            Entity entity = iota.insertTransaction(address, dataTransaction);
            Preconditions.checkNotNull((Object)entity);
            String hash = entity.getHash();
            Hash transactionHash = this.createHash(hash);
            this.insertHash(transactionHash);
            this.setHash(note, hash);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean insertNote(@NonNull IOTA iota, @NonNull Note note) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((note.getKind() == Kind.OUT ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.THREAD_REQUEST ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.THREAD_PUBLISH ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.HTML ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.INFO ? 1 : 0) != 0);
        try {
            Thread thread = this.getThread(note);
            Preconditions.checkNotNull((Object)thread);
            CID cid = thread.getCid();
            Preconditions.checkNotNull((Object)cid);
            String address = THREADS.getAddress(cid);
            Content content = NoteEncoder.convert(note);
            Entity entity = iota.insertTransaction(address, this.gson.toJson((Object)content));
            Preconditions.checkNotNull((Object)entity);
            String hash = entity.getHash();
            Hash transactionHash = this.createHash(hash);
            this.insertHash(transactionHash);
            this.setHash(note, hash);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean publishNote(@NonNull IPFS ipfs, @NonNull String topic, @NonNull Note note) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((note.getKind() == Kind.OUT ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.THREAD_REQUEST ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.THREAD_PUBLISH ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.HTML ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.INFO ? 1 : 0) != 0);
        try {
            Content content = NoteEncoder.convert(note);
            String message = this.gson.toJson((Object)content);
            ipfs.pubsubPub(topic, message, 50);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean publishNote(@NonNull IPFS ipfs, @NonNull User user, @NonNull Note note) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkArgument((note.getKind() == Kind.OUT ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.THREAD_REQUEST ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.THREAD_PUBLISH ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.HTML ? 1 : 0) != 0);
        Preconditions.checkArgument((note.getNoteType() != NoteType.INFO ? 1 : 0) != 0);
        try {
            Content content = NoteEncoder.convert(note);
            String hash = this.getHash(note);
            if (hash != null) {
                content.put("hash", hash);
            }
            this.sendNotification(ipfs, user.getPID(), content);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    @NonNull
    public Thread createThread(@NonNull User user, @NonNull ThreadStatus status, @NonNull Kind kind, @NonNull String sesKey, @Nullable CID cid, long thread) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)((Object)status));
        Preconditions.checkNotNull((Object)((Object)kind));
        Preconditions.checkNotNull((Object)sesKey);
        Preconditions.checkArgument((thread >= 0L ? 1 : 0) != 0);
        Thread result = this.createThread(status, kind, user.getPID(), user.getAlias(), user.getPublicKey(), sesKey, new Date(), thread);
        result.setCid(cid);
        return result;
    }

    @NonNull
    public Note createThreadRequestNote(@NonNull User sender, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        Note note = this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.THREAD_REQUEST, thread.getCid(), "text/plain", new Date());
        HashMap<String, String> externals = thread.getExternalAdditions();
        for (String key : externals.keySet()) {
            String value = externals.get(key);
            if (value == null) continue;
            note.addAdditional(key, value, false);
        }
        return note;
    }

    @NonNull
    public Note createThreadRejectNote(@NonNull User sender, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.THREAD_REJECT, null, "text/plain", new Date());
    }

    @NonNull
    public Note createThreadJoinNote(@NonNull User sender, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.THREAD_JOIN, null, "text/plain", new Date());
    }

    @NonNull
    public Note createThreadPublishNote(@NonNull User sender, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.THREAD_PUBLISH, thread.getCid(), "text/plain", new Date());
    }

    @NonNull
    public Note createThreadLeaveNote(@NonNull User sender, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.THREAD_LEAVE, null, "text/plain", new Date());
    }

    @NonNull
    public Note createHtmlNote(@NonNull User sender, @NonNull Thread thread, @Nullable CID cid) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.HTML, cid, "text/plain", new Date());
    }

    @NonNull
    public Note createMessageNote(@NonNull User sender, @NonNull Thread thread, @NonNull CID cid) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.MESSAGE, cid, "text/plain", new Date());
    }

    @NonNull
    public Note createVideoCallNote(@NonNull User sender, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.VIDEO_CALL, null, "text/plain", new Date());
    }

    @NonNull
    public Note createCallNote(@NonNull User sender, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.CALL, null, "text/plain", new Date());
    }

    @NonNull
    public Note createLocationNote(@NonNull User sender, @NonNull Thread thread, double latitude, double longitude, double zoom) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        Note note = this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.LOCATION, null, "text/geo", new Date());
        note.addAdditional("LATITUDE", String.valueOf(latitude), false);
        note.addAdditional("LONGITUDE", String.valueOf(longitude), false);
        note.addAdditional("ZOOM", String.valueOf(zoom), false);
        return note;
    }

    @NonNull
    public Note createLinkNote(@NonNull User sender, @NonNull Thread thread, @NonNull LinkType linkType, @Nullable CID cid, @NonNull String fileName, @NonNull String mimeType, long fileSize) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)((Object)linkType));
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)mimeType);
        Note note = this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.LINK, cid, mimeType, new Date());
        note.addAdditional(LinkType.class.getSimpleName(), linkType.name(), false);
        note.addAdditional("fn", fileName, false);
        note.addAdditional("fs", String.valueOf(fileSize), false);
        return note;
    }

    @NonNull
    public Note createDataNote(@NonNull User sender, @NonNull Thread thread, @NonNull String mimeType, @Nullable CID cid) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)mimeType);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.DATA, cid, mimeType, new Date());
    }

    @NonNull
    public Note createAudioNote(@NonNull User sender, @NonNull Thread thread, @NonNull String mimeType, @Nullable CID cid) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)mimeType);
        return this.createNote(thread.getCid(), sender.getPID(), sender.getAlias(), sender.getPublicKey(), thread.getSesKey(), NoteType.AUDIO, cid, mimeType, new Date());
    }

    @NonNull
    public Note createInfoNote(@NonNull Thread thread, @NonNull String info, @NonNull Date date) {
        Preconditions.checkNotNull((Object)thread);
        Note note = this.createNote(thread.getCid(), thread.getSenderPid(), thread.getSenderAlias(), thread.getSenderKey(), thread.getSesKey(), NoteType.INFO, null, "text/plain", date);
        note.addAdditional("text", info, true);
        return note;
    }

    @Nullable
    public PeerInfo getPeerInfoByHash(@NonNull String hash) {
        Preconditions.checkNotNull((Object)hash);
        return this.getPeersInfoDatabase().peersInfoDao().getPeerInfoByHash(hash);
    }

    public void storeUser(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        this.getThreadsDatabase().userDao().insertUsers(user);
    }

    @NonNull
    public PeerInfo createPeerInfo(@NonNull PID owner) {
        Preconditions.checkNotNull((Object)owner);
        return PeerInfo.createPeerInfo(owner);
    }

    @NonNull
    public Peer createPeer(@NonNull PID pid, @NonNull String multiAddress) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)multiAddress);
        return Peer.createPeer(pid, multiAddress);
    }

    @Nullable
    public Peer getPeerByPID(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getPeersDatabase().peersDao().getPeerByPid(pid.getPid());
    }

    @NonNull
    public List<Peer> getRelayPeers() {
        return this.getPeersDatabase().peersDao().getRelayPeers();
    }

    @NonNull
    public List<Peer> getAutonatPeers() {
        return this.getPeersDatabase().peersDao().getAutonatPeers();
    }

    @Nullable
    public PeerInfo getPeerInfoByPID(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getPeersInfoDatabase().peersInfoDao().getPeerInfoByPid(pid.getPid());
    }

    public void storePeer(@NonNull Peer peer) {
        Preconditions.checkNotNull((Object)peer);
        this.getPeersDatabase().peersDao().insertPeer(peer);
    }

    public void storePeerInfo(@NonNull PeerInfo peer) {
        Preconditions.checkNotNull((Object)peer);
        this.getPeersInfoDatabase().peersInfoDao().insertPeerInfo(peer);
    }

    public void updatePeerInfo(@NonNull PeerInfo peer) {
        Preconditions.checkNotNull((Object)peer);
        this.getPeersInfoDatabase().peersInfoDao().updatePeerInfo(peer);
    }

    public void updatePeer(@NonNull Peer peer) {
        Preconditions.checkNotNull((Object)peer);
        this.getPeersDatabase().peersDao().updatePeer(peer);
    }

    public boolean insertPeerInfo(@NonNull IOTA iota, @NonNull PeerInfo peer, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)peer);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            String address = AddressType.getAddress(peer.getPID(), AddressType.PEER);
            String data = PeerInfoEncoder.convert(peer, aesKey);
            Entity entity = iota.insertTransaction(address, data);
            Preconditions.checkNotNull((Object)entity);
            String hash = entity.getHash();
            Hash transactionHash = this.createHash(hash);
            this.insertHash(transactionHash);
            this.setHash(peer, hash);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    @NonNull
    public User createUser(@NonNull PID pid, @NonNull String publicKey, @NonNull String name, @NonNull UserType type, @Nullable CID image) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkArgument((!pid.getPid().isEmpty() ? 1 : 0) != 0);
        return User.createUser(type, UserStatus.OFFLINE, name, publicKey, pid, image);
    }

    public void handleExpiredThreads(@NonNull IPFS ipfs) {
        Date today = THREADS.getToday();
        List<Thread> threads = this.getExpiredThreads(today);
        for (Thread thread : threads) {
            if (thread.getKind() == Kind.IN) {
                this.removeThread(ipfs, thread);
                continue;
            }
            this.setStatus(thread, ThreadStatus.EXPIRED);
        }
    }

    public void setAdditional(@NonNull Server server, @NonNull String key, @NonNull String value, boolean internal) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        Server update = this.getServerByIdx(server.getIdx());
        Preconditions.checkNotNull((Object)update);
        update.addAdditional(key, value, internal);
        this.updateServer(update);
    }

    public void setAdditional(@NonNull User user, @NonNull String key, @NonNull String value, boolean internal) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        User update = this.getUserByPID(user.getPID());
        Preconditions.checkNotNull((Object)update);
        update.addAdditional(key, value, internal);
        this.updateUser(update);
    }

    public void setAdditional(@NonNull Note note, @NonNull String key, @NonNull String value, boolean internal) {
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        Note update = this.getNoteByIdx(note.getIdx());
        Preconditions.checkNotNull((Object)update);
        update.addAdditional(key, value, internal);
        this.updateNote(update);
    }

    public void setAdditional(@NonNull Thread thread, @NonNull String key, @NonNull String value, boolean internal) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        Thread update = this.getThreadByIdx(thread.getIdx());
        Preconditions.checkNotNull((Object)update);
        update.addAdditional(key, value, internal);
        this.updateThread(update);
    }

    public void removeThread(@NonNull IPFS ipfs, @NonNull Thread thread) {
        CID image;
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)thread);
        this.removeThreadNotes(ipfs, thread);
        this.removeThread(thread);
        CID cid = thread.getCid();
        if (cid != null) {
            try {
                List<Thread> list = this.getThreadsByCID(cid);
                if (list.isEmpty()) {
                    this.pin_rm(ipfs, cid);
                }
            }
            catch (Throwable list) {
                // empty catch block
            }
        }
        if ((image = thread.getImage()) != null) {
            try {
                List<Thread> list = this.getThreadsByCID(image);
                if (list.isEmpty()) {
                    this.pin_rm(ipfs, image);
                }
            }
            catch (Throwable list) {
                // empty catch block
            }
        }
        List<Thread> entries = this.getThreadsByThread(thread.getIdx());
        for (Thread entry : entries) {
            this.removeThread(ipfs, entry);
        }
    }

    public void removeNote(@NonNull IPFS ipfs, @NonNull Note note) {
        CID image;
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)note);
        CID cid = note.getCid();
        this.removeNote(note);
        if (cid != null) {
            try {
                List<Note> list = this.getNotesByCID(cid);
                if (list.isEmpty()) {
                    this.pin_rm(ipfs, cid);
                }
            }
            catch (Throwable list) {
                // empty catch block
            }
        }
        if ((image = note.getImage()) != null) {
            try {
                List<Note> list = this.getNotesByCID(image);
                if (list.isEmpty()) {
                    this.pin_rm(ipfs, image);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void insertHash(@NonNull Hash hash) {
        Preconditions.checkNotNull((Object)hash);
        this.entityService.getHashDatabase().hashDao().insertHash(new Hash[]{hash});
    }

    private List<Thread> getExpiredThreads(@NonNull Date date) {
        Preconditions.checkNotNull((Object)date);
        return this.getThreadsDatabase().threadDao().getExpiredThreads(date);
    }

    @NonNull
    public List<Thread> loadThreadRequests(@NonNull IOTA iota, @NonNull User user, final @NonNull String privateKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)privateKey);
        final ArrayList<Thread> threads = new ArrayList<Thread>();
        String address = AddressType.getAddress(user.getPID(), AddressType.INBOX);
        Preconditions.checkNotNull((Object)address);
        try {
            iota.loadTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    return !ThreadsAPI.this.hasHash(hash);
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    Thread thread = NoteRequestDecoder.convert(entity, privateKey);
                    if (thread != null) {
                        if (ThreadsAPI.this.isUserBlocked(thread.getSenderPid())) {
                            return;
                        }
                        if (ThreadsAPI.this.existsSameThread(thread)) {
                            return;
                        }
                        threads.add(thread);
                    }
                }
            }, new String[]{address});
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return threads;
    }

    @Nullable
    public PeerInfo getPeer(@NonNull IOTA iota, @NonNull PID pid, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)aesKey);
        PeerInfo peer = this.loadPeer(iota, pid, aesKey);
        if (peer != null) {
            PeerInfo storePeer = this.getPeerInfoByPID(pid);
            if (storePeer != null) {
                if (storePeer.getTimestamp() > peer.getTimestamp()) {
                    return storePeer;
                }
                this.storePeerInfo(peer);
                return peer;
            }
            this.storePeerInfo(peer);
            return peer;
        }
        return this.getPeerInfoByPID(pid);
    }

    @Nullable
    public PeerInfo loadPeer(@NonNull IOTA iota, final @NonNull PID pid, final @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)aesKey);
        String address = AddressType.getAddress(pid, AddressType.PEER);
        final AtomicReference<Object> reference = new AtomicReference<Object>(null);
        try {
            iota.loadTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    return !ThreadsAPI.this.hasHash(hash);
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    PeerInfo peer = PeerInfoDecoder.convert(pid, entity, aesKey);
                    if (peer != null) {
                        PeerInfo inserted = (PeerInfo)reference.get();
                        if (inserted != null) {
                            if (inserted.getTimestamp() < peer.getTimestamp()) {
                                reference.set(peer);
                            }
                        } else {
                            reference.set(peer);
                        }
                    }
                }
            }, new String[]{address});
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return reference.get();
    }

    @NonNull
    public List<Server> loadServers(@NonNull IOTA iota, final @NonNull User owner, @NonNull String address) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)address);
        final ArrayList<Server> servers = new ArrayList<Server>();
        try {
            iota.loadTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    return !ThreadsAPI.this.hasHash(hash);
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    Server server = ServerDecoder.convert(entity, owner);
                    if (server != null) {
                        servers.add(server);
                    }
                }
            }, new String[]{address});
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return servers;
    }

    @NonNull
    public List<Note> loadNotes(@NonNull IOTA iota, final @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)thread);
        final ArrayList<Note> notes = new ArrayList<Note>();
        CID cid = thread.getCid();
        Preconditions.checkNotNull((Object)cid);
        String address = THREADS.getAddress(cid);
        try {
            iota.loadTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    return !ThreadsAPI.this.hasHash(hash);
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    Note note = NoteDecoder.convert(thread, entity);
                    if (note != null) {
                        if (ThreadsAPI.this.isUserBlocked(note.getSenderPid())) {
                            return;
                        }
                        if (ThreadsAPI.this.existsSameNote(note)) {
                            return;
                        }
                        notes.add(note);
                    }
                }
            }, new String[]{address});
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return notes;
    }

    public void removeThread(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        this.getThreadsDatabase().threadDao().removeThreads(thread);
    }

    public void removeUser(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        this.getThreadsDatabase().userDao().removeUsers(user);
    }

    public void removeUserByPID(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        this.getThreadsDatabase().userDao().removeUserByPid(pid.getPid());
    }

    public void removeUsersByPID(String ... pids) {
        Preconditions.checkNotNull((Object)pids);
        this.getThreadsDatabase().userDao().removeUsersByPid(pids);
    }

    public boolean existsUser(@NonNull PID user) {
        Preconditions.checkNotNull((Object)user);
        return this.existsUser(user.getPid());
    }

    public boolean existsUser(@NonNull String pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getThreadsDatabase().userDao().hasUser(pid) > 0L;
    }

    public void removeThreads(@NonNull IPFS ipfs, long ... idxs) {
        Preconditions.checkNotNull((Object)ipfs);
        List<Thread> threads = this.getThreadByIdxs(idxs);
        for (Thread thread : threads) {
            this.removeThread(ipfs, thread);
        }
    }

    public void pin_rm(@NonNull IPFS ipfs, @NonNull CID cid) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)cid);
        Preconditions.checkNotNull((Object)cid);
        ipfs.rm(cid);
    }

    public void pin_add(@NonNull IPFS ipfs, @NonNull CID cid, int timeout, boolean offline) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)cid);
        Preconditions.checkNotNull((Object)(timeout > 0 ? 1 : 0));
        ipfs.pin_add(cid, timeout, offline);
    }

    public void removeThreads(@NonNull IPFS ipfs, @NonNull List<Thread> threads) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull(threads);
        for (Thread thread : threads) {
            this.removeThreadNotes(ipfs, thread);
        }
        this.getThreadsDatabase().threadDao().removeThreads((Thread[])Iterables.toArray(threads, Thread.class));
    }

    @NonNull
    public Event createEvent(@NonNull String identifier, @NonNull String content) {
        Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)content);
        return Event.createEvent(identifier, content);
    }

    public void removeEvent(@NonNull Event event) {
        Preconditions.checkNotNull((Object)event);
        this.getEventsDatabase().eventDao().deleteEvent(event);
    }

    public void removeEvent(@NonNull String identifier) {
        Preconditions.checkNotNull((Object)identifier);
        this.getEventsDatabase().eventDao().deleteEvent(identifier);
    }

    public void invokeEvent(@NonNull String identifier, @NonNull String content) {
        Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)content);
        this.storeEvent(this.createEvent(identifier, content));
    }

    public void storeEvent(@NonNull Event event) {
        Preconditions.checkNotNull((Object)event);
        this.getEventsDatabase().eventDao().insertEvent(event);
    }

    public Message createMessage(@NonNull MessageKind messageKind, @NonNull String message, long timestamp) {
        Preconditions.checkNotNull((Object)((Object)messageKind));
        Preconditions.checkNotNull((Object)message);
        return Message.createMessage(messageKind, message, timestamp);
    }

    public void removeMessage(@NonNull Message message) {
        Preconditions.checkNotNull((Object)message);
        this.getEventsDatabase().messageDao().deleteMessage(message);
    }

    public void storeMessage(@NonNull Message message) {
        Preconditions.checkNotNull((Object)message);
        this.getEventsDatabase().messageDao().insertMessages(message);
    }

    public void clearMessages() {
        this.getEventsDatabase().messageDao().clear();
    }

    public List<PID> getMembers(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        return Lists.newArrayList((Iterable)thread.getMembers());
    }

    public List<Thread> getThreads() {
        return this.getThreadsDatabase().threadDao().getThreads();
    }

    public void incrementUnreadNotesNumber(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        this.incrementThreadsUnreadNotesNumber(thread.getIdx());
    }

    public void incrementThreadsUnreadNotesNumber(long ... idxs) {
        this.getThreadsDatabase().threadDao().incrementUnreadNotesNumber(idxs);
    }

    public void refreshNotesNumber(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        int number = thread.getUnreadNotes();
        this.getThreadsDatabase().threadDao().setUnreadNotesNumber(thread.getIdx(), number);
    }

    public void resetThreadsUnreadNotesNumber(long ... idxs) {
        this.getThreadsDatabase().threadDao().resetUnreadNotes(idxs);
    }

    public void resetThreadUnreadNotesNumber(long thread) {
        this.getThreadsDatabase().threadDao().resetThreadUnreadNotes(thread);
    }

    @Nullable
    public User getUserByPID(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkArgument((!pid.getPid().isEmpty() ? 1 : 0) != 0);
        return this.getThreadsDatabase().userDao().getUserByPid(pid.getPid());
    }

    @NonNull
    public List<User> getUsersByPID(String ... pids) {
        Preconditions.checkNotNull((Object)pids);
        return this.getThreadsDatabase().userDao().getUsersByPid(pids);
    }

    @NonNull
    public List<User> getUsers() {
        return this.getThreadsDatabase().userDao().getUsers();
    }

    @NonNull
    public List<User> getUsers(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        ArrayList<User> users = new ArrayList<User>();
        for (PID pid : thread.getMembers()) {
            User user = this.getUserByPID(pid);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    @NonNull
    public String getFileName(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return note.getAdditional("fn");
    }

    public long getFileSize(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return Long.valueOf(note.getAdditional("fs"));
    }

    @NonNull
    public LinkType getLinkNoteLinkType(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((note.getNoteType() == NoteType.LINK ? 1 : 0) != 0);
        return LinkType.valueOf(note.getAdditional(LinkType.class.getSimpleName()));
    }

    private void removeThreadNotes(@NonNull IPFS ipfs, @NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)ipfs);
        List<Note> notes = this.getNotesByThread(thread.getCid());
        for (Note note : notes) {
            this.removeNote(ipfs, note);
        }
    }

    public void removeNote(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        this.getThreadsDatabase().noteDao().removeNote(note);
    }

    @NonNull
    public List<Note> getNotesByNoteType(@NonNull NoteType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        return this.getThreadsDatabase().noteDao().getNotesByType(type);
    }

    @NonNull
    public List<Note> getNotesByKindAndStatus(@NonNull Kind kind, @NonNull NoteStatus status) {
        Preconditions.checkNotNull((Object)((Object)kind));
        Preconditions.checkNotNull((Object)((Object)status));
        return this.getThreadsDatabase().noteDao().getNotesByKindAndStatus(kind, status);
    }

    public boolean insertUser(@NonNull IOTA iota, @NonNull User user, @NonNull String address, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            String dataTransaction = UserEncoder.convert(user, aesKey);
            Entity entity = iota.insertTransaction(address, dataTransaction);
            Preconditions.checkNotNull((Object)entity);
            String hash = entity.getHash();
            Hash transactionHash = this.createHash(hash);
            Preconditions.checkNotNull((Object)transactionHash);
            this.insertHash(transactionHash);
            this.setHash(user, hash);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void setHash(@NonNull Server server, @Nullable String hash) {
        Preconditions.checkNotNull((Object)server);
        long idx = server.getIdx();
        server.setHash(hash);
        this.getThreadsDatabase().serverDao().setHash(idx, hash);
    }

    @Nullable
    public String getPeerInfoHash(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getPeersInfoDatabase().peersInfoDao().getPeerInfoHash(pid.getPid());
    }

    public void setHash(@NonNull PeerInfo peer, @Nullable String hash) {
        Preconditions.checkNotNull((Object)peer);
        peer.setHash(hash);
        this.getPeersInfoDatabase().peersInfoDao().setHash(peer.getPid(), hash);
    }

    public void setHash(@NonNull User user, @Nullable String hash) {
        Preconditions.checkNotNull((Object)user);
        user.setHash(hash);
        this.getThreadsDatabase().userDao().setHash(user.getPid(), hash);
    }

    @Nullable
    public String getHash(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return this.getThreadsDatabase().noteDao().getHash(note.getIdx());
    }

    public void setHash(@NonNull Note note, @Nullable String hash) {
        Preconditions.checkNotNull((Object)note);
        note.setHash(hash);
        this.getThreadsDatabase().noteDao().setHash(note.getIdx(), hash);
    }

    public void updateSettings(@NonNull Settings settings) {
        Preconditions.checkNotNull((Object)settings);
        this.getThreadsDatabase().settingsDao().updateSettings(settings);
    }

    public boolean hasHash(@NonNull String hash) {
        return this.entityService.getHashDatabase().hashDao().hasHash(hash) > 0L;
    }

    public void removeHash(@NonNull String hash) {
        this.entityService.getHashDatabase().hashDao().removeHash(hash);
    }

    private void updateUser(@NonNull User user) {
        this.getThreadsDatabase().userDao().updateUser(user);
    }

    @Nullable
    public PeerInfo getPeerInfoByHash(@NonNull IOTA iota, @NonNull PID pid, @NonNull String hash, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)hash);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)aesKey);
        PeerInfo peer = this.getPeerInfoByHash(hash);
        if (peer != null) {
            return peer;
        }
        peer = this.loadPeerInfoByHash(iota, pid, hash, aesKey);
        if (peer != null) {
            boolean store = true;
            PeerInfo storedPeer = this.getPeerInfoByPID(pid);
            if (storedPeer != null && peer.getTimestamp() < storedPeer.getTimestamp()) {
                store = false;
            }
            if (store) {
                this.storePeerInfo(peer);
            }
        }
        return peer;
    }

    @Nullable
    public PeerInfo loadPeerInfoByHash(@NonNull IOTA iota, final @NonNull PID pid, @NonNull String hash, final @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)hash);
        Preconditions.checkNotNull((Object)aesKey);
        final ArrayList peers = new ArrayList();
        try {
            iota.loadHashTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    return true;
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    PeerInfo peer = PeerInfoDecoder.convert(pid, entity, aesKey);
                    if (peer != null) {
                        peers.add(peer);
                    }
                }
            }, new String[]{hash});
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (peers.isEmpty()) {
            return null;
        }
        return (PeerInfo)peers.get(0);
    }

    @Nullable
    public User loadUserByHash(@NonNull IOTA iota, @NonNull String hash, final @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)hash);
        Preconditions.checkNotNull((Object)aesKey);
        final ArrayList users = new ArrayList();
        try {
            iota.loadHashTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    return true;
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    User user = UserDecoder.convert(entity, aesKey);
                    if (user != null) {
                        users.add(user);
                    }
                }
            }, new String[]{hash});
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    @Nullable
    public User loadUserByAddress(@NonNull IOTA iota, @NonNull String address, final @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)aesKey);
        final ArrayList users = new ArrayList();
        try {
            iota.loadTransactions(new IOTA.Filter(){

                public boolean acceptHash(@NonNull String hash) {
                    return !ThreadsAPI.this.hasHash(hash);
                }

                public void invalidHash(@NonNull String hash) {
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public boolean acceptEntity(@NonNull Entity entity) {
                    boolean result = true;
                    String hash = entity.getHash();
                    if (ThreadsAPI.this.hasHash(hash)) {
                        result = false;
                    } else {
                        Hash transactionHash = ThreadsAPI.this.createHash(hash);
                        ThreadsAPI.this.insertHash(transactionHash);
                    }
                    return result;
                }

                public void invalidEntity(@NonNull Entity entity) {
                    Preconditions.checkNotNull((Object)entity);
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void error(@NonNull Entity entity, @NonNull Throwable e) {
                    String hash = entity.getHash();
                    Hash transactionHash = ThreadsAPI.this.createHash(hash);
                    ThreadsAPI.this.insertHash(transactionHash);
                }

                public void loadEntity(@NonNull Entity entity) {
                    User user = UserDecoder.convert(entity, aesKey);
                    if (user != null) {
                        users.add(user);
                    }
                }
            }, new String[]{address});
            if (users.isEmpty()) {
                return null;
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return (User)users.get(0);
    }

    public void resetUnreadNotes(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        this.getThreadsDatabase().threadDao().resetUnreadNotes(thread.getIdx());
    }

    public long storeThread(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        return this.getThreadsDatabase().threadDao().insertThread(thread);
    }

    public long storeNote(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return this.getThreadsDatabase().noteDao().insertNote(note);
    }

    public void setStatus(@NonNull Thread thread, @NonNull ThreadStatus status) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().threadDao().setThreadStatus(thread.getIdx(), status);
    }

    public void setThreadPinned(long idx, boolean pinned) {
        this.getThreadsDatabase().threadDao().setPinned(idx, pinned);
    }

    public boolean isThreadPinned(long idx) {
        return this.getThreadsDatabase().threadDao().isPinned(idx);
    }

    public void setCID(@NonNull Thread thread, @NonNull CID cid) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)cid);
        Multihash.fromBase58((String)cid.getCid());
        this.getThreadsDatabase().threadDao().setCid(thread.getIdx(), cid);
    }

    public void setThreadCID(long idx, @NonNull CID cid) {
        Preconditions.checkNotNull((Object)cid);
        this.getThreadsDatabase().threadDao().setCid(idx, cid);
    }

    public void setNoteCID(long idx, @NonNull CID cid) {
        Preconditions.checkNotNull((Object)cid);
        this.getThreadsDatabase().noteDao().setCid(idx, cid);
    }

    public void setCID(@NonNull Note note, @NonNull CID cid) {
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)cid);
        this.getThreadsDatabase().noteDao().setCid(note.getIdx(), cid);
    }

    public void setStatus(@NonNull Note note, @NonNull NoteStatus status) {
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().noteDao().setNoteStatus(note.getIdx(), status);
    }

    public void setNoteStatus(@NonNull NoteStatus status, long idx) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().noteDao().setNoteStatus(idx, status);
    }

    public void setStatus(@NonNull User user, @NonNull UserStatus status) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)((Object)status));
        this.setUserStatus(user.getPID(), status);
    }

    public void setUserStatus(@NonNull PID user, @NonNull UserStatus status) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().userDao().setUserStatus(user.getPid(), status);
    }

    public void setUsersStatus(@NonNull UserStatus status, String ... pids) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.getThreadsDatabase().userDao().setUsersStatus(status, pids);
    }

    @NonNull
    public UserStatus getStatus(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        return this.getUserStatus(user.getPid());
    }

    @NonNull
    public UserStatus getUserStatus(@NonNull PID user) {
        Preconditions.checkNotNull((Object)user);
        return this.getUserStatus(user.getPid());
    }

    @NonNull
    public UserStatus getUserStatus(@NonNull String pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getThreadsDatabase().userDao().getUserStatus(pid);
    }

    @NonNull
    public ThreadStatus getStatus(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        return this.getThreadsDatabase().threadDao().getThreadStatus(thread.getIdx());
    }

    public boolean getThreadMarkedFlag(long idx) {
        return this.getThreadsDatabase().threadDao().getMarkedFlag(idx);
    }

    public void setThreadMarkedFlag(long idx, boolean flag) {
        this.getThreadsDatabase().threadDao().setMarkedFlag(idx, flag);
    }

    @NonNull
    public List<Note> getNotesByDate(@NonNull Date date) {
        Preconditions.checkNotNull((Object)date);
        return this.getThreadsDatabase().noteDao().getNotesByDate(date);
    }

    @NonNull
    public List<Thread> getPinnedThreads() {
        return this.getThreadsDatabase().threadDao().getThreadsByPinned(true);
    }

    @NonNull
    public List<Thread> getThreadsByDate(@NonNull Date date) {
        Preconditions.checkNotNull((Object)date);
        return this.getThreadsDatabase().threadDao().getThreadsByDate(date);
    }

    private boolean existsSameNote(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        boolean result = false;
        List<Note> notes = this.getNotesByDate(note.getDate());
        for (Note cmp : notes) {
            if (!note.sameNote(cmp)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean existsSameThread(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        boolean result = false;
        List<Thread> notes = this.getThreadsByDate(thread.getDate());
        for (Thread cmp : notes) {
            if (!thread.sameThread(cmp)) continue;
            result = true;
            break;
        }
        return result;
    }

    @NonNull
    public NoteStatus getStatus(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return this.getThreadsDatabase().noteDao().getNoteStatus(note.getIdx());
    }

    @Nullable
    public NoteStatus getNoteStatus(long idx) {
        return this.getThreadsDatabase().noteDao().getNoteStatus(idx);
    }

    @Nullable
    public ThreadStatus getThreadStatus(long idx) {
        return this.getThreadsDatabase().threadDao().getThreadStatus(idx);
    }

    @Nullable
    public NoteType getNoteType(long idx) {
        return this.getThreadsDatabase().noteDao().getNoteType(idx);
    }

    public void setUserPublicKey(@NonNull User user, @NonNull String publicKey) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)publicKey);
        this.setUserPublicKey(user.getPid(), publicKey);
    }

    public void setUserPublicKey(@NonNull PID user, @NonNull String publicKey) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)publicKey);
        this.setUserPublicKey(user.getPid(), publicKey);
    }

    public void setUserPublicKey(@NonNull String pid, @NonNull String publicKey) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)publicKey);
        this.getThreadsDatabase().userDao().setPublicKey(pid, publicKey);
    }

    public String getUserPublicKey(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        return this.getUserPublicKey(user.getPid());
    }

    public String getUserPublicKey(@NonNull PID user) {
        Preconditions.checkNotNull((Object)user);
        return this.getUserPublicKey(user.getPid());
    }

    public String getUserPublicKey(@NonNull String pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getThreadsDatabase().userDao().getPublicKey(pid);
    }

    public String getUserAlias(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        return this.getUserAlias(user.getPid());
    }

    public String getUserAlias(@NonNull PID user) {
        Preconditions.checkNotNull((Object)user);
        return this.getUserAlias(user.getPid());
    }

    public String getUserAlias(@NonNull String pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.getThreadsDatabase().userDao().getAlias(pid);
    }

    public void setUserAlias(@NonNull User user, @NonNull String alias) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)alias);
        this.setUserAlias(user.getPid(), alias);
    }

    public void setUserAlias(@NonNull PID user, @NonNull String alias) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)alias);
        this.setUserAlias(user.getPid(), alias);
    }

    public void setUserAlias(@NonNull String pid, @NonNull String alias) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)alias);
        this.getThreadsDatabase().userDao().setAlias(pid, alias);
    }

    public void setUserImage(@NonNull PID user, @NonNull CID image) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)image);
        this.setUserImage(user.getPid(), image);
    }

    public void setUserImage(@NonNull String pid, @NonNull CID image) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)image);
        this.getThreadsDatabase().userDao().setImage(pid, image);
    }

    public void setUserType(@NonNull User user, @NonNull UserType type) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)((Object)type));
        this.setUserType(user.getPid(), type);
    }

    public void setUserType(@NonNull PID user, @NonNull UserType type) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)((Object)type));
        this.setUserType(user.getPid(), type);
    }

    public void setUserType(@NonNull String pid, @NonNull UserType type) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)((Object)type));
        this.getThreadsDatabase().userDao().setUserType(pid, type);
    }

    @NonNull
    public Settings createSettings(@NonNull String id) {
        Preconditions.checkNotNull((Object)id);
        return Settings.createSettings(id);
    }

    public void storeNotes(@NonNull List<Note> notes) {
        Preconditions.checkNotNull(notes);
        this.getThreadsDatabase().noteDao().insertNotes((Note[])Iterables.toArray(notes, Note.class));
    }

    public void storeThreads(@NonNull List<Thread> threads) {
        Preconditions.checkNotNull(threads);
        this.getThreadsDatabase().threadDao().insertThreads((Thread[])Iterables.toArray(threads, Thread.class));
    }

    private void updateThread(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        this.getThreadsDatabase().threadDao().updateThreads(thread);
    }

    @NonNull
    public List<Thread> getThreadsByThread(long thread) {
        return this.getThreadsDatabase().threadDao().getThreadsByThread(thread);
    }

    @Nullable
    public Thread getThreadByIdx(long idx) {
        return this.getThreadsDatabase().threadDao().getThreadByIdx(idx);
    }

    public List<Thread> getThreadByIdxs(long ... idx) {
        return this.getThreadsDatabase().threadDao().getThreadByIdxs(idx);
    }

    @Nullable
    public CID getThreadCID(long idx) {
        return this.getThreadsDatabase().threadDao().getCid(idx);
    }

    @Nullable
    public Thread getThread(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        CID cid = note.getThread();
        if (cid == null) {
            return null;
        }
        List<Thread> threads = this.getThreadsByCID(cid);
        if (threads.isEmpty()) {
            return null;
        }
        Preconditions.checkArgument((threads.size() == 1 ? 1 : 0) != 0);
        return threads.get(0);
    }

    @Nullable
    public Note getNoteByIdx(long idx) {
        return this.getThreadsDatabase().noteDao().getNoteByIdx(idx);
    }

    private void updateServer(@NonNull Server server) {
        Preconditions.checkNotNull((Object)server);
        this.getThreadsDatabase().serverDao().updateServer(server);
    }

    private void updateNote(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        this.getThreadsDatabase().noteDao().updateNote(note);
    }

    public void blockUser(@NonNull PID user) {
        Preconditions.checkNotNull((Object)user);
        this.getThreadsDatabase().userDao().setBlocked(user.getPid(), true);
    }

    public void blockUser(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        this.blockUser(user.getPID());
    }

    public void unblockUser(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        this.unblockUser(user.getPID());
    }

    public void unblockUser(@NonNull PID user) {
        Preconditions.checkNotNull((Object)user);
        this.getThreadsDatabase().userDao().setBlocked(user.getPid(), false);
    }

    @Nullable
    public Settings getSettings(@NonNull String id) {
        Preconditions.checkNotNull((Object)id);
        return this.getThreadsDatabase().settingsDao().getSettings(id);
    }

    public void storeSettings(@NonNull Settings settings) {
        Preconditions.checkNotNull((Object)settings);
        this.getThreadsDatabase().settingsDao().insertSettings(settings);
    }

    @NonNull
    public List<Thread> getThreadsByThreadStatus(@NonNull ThreadStatus readStatus) {
        Preconditions.checkNotNull((Object)((Object)readStatus));
        return this.getThreadsDatabase().threadDao().getThreadsByThreadStatus(readStatus);
    }

    @NonNull
    public List<Thread> getThreadsByKindAndThreadStatus(@NonNull Kind kind, @NonNull ThreadStatus status) {
        Preconditions.checkNotNull((Object)((Object)kind));
        Preconditions.checkNotNull((Object)((Object)status));
        return this.getThreadsDatabase().threadDao().getThreadsByKindAndThreadStatus(kind, status);
    }

    private void sendNotification(@NonNull IPFS ipfs, @NonNull PID pid, @NonNull Content content) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)content);
        String json_message = this.gson.toJson((Object)content);
        ipfs.pubsubPub(pid.getPid(), json_message, 50);
    }

    @Nullable
    public User verifyMember(@NonNull Thread thread, @NonNull Note note) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)note);
        PID pid = note.getSenderPid();
        if (!thread.getMembers().contains(pid)) {
            User senderUser = this.getUserByPID(pid);
            if (senderUser == null) {
                senderUser = this.createUser(pid, note.getSenderKey(), note.getSenderAlias(), UserType.UNKNOWN, null);
                this.storeUser(senderUser);
                return senderUser;
            }
            this.addMember(thread, pid);
            return null;
        }
        return null;
    }

    public void addMember(@NonNull Thread thread, @NonNull PID user) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)user);
        thread.addMember(user);
        Thread update = this.getThreadByIdx(thread.getIdx());
        Preconditions.checkNotNull((Object)update);
        update.addMember(user);
        this.updateThread(update);
    }

    public void removeMember(@NonNull Thread thread, @NonNull PID user) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)user);
        thread.removeMember(user);
        Thread update = this.getThreadByIdx(thread.getIdx());
        Preconditions.checkNotNull((Object)update);
        update.removeMember(user);
        this.updateThread(update);
    }

    @NonNull
    public Hash createHash(@NonNull String hash) {
        Preconditions.checkNotNull((Object)hash);
        return Hash.create((String)hash, (long)System.currentTimeMillis());
    }

    private Note createNote(@Nullable CID thread, @NonNull PID senderPid, @NonNull String senderAuthor, @NonNull String senderKey, @NonNull String sesKey, @NonNull NoteType noteType, @Nullable CID cid, @NonNull String mimeType, @NonNull Date date) {
        Note note = Note.createNote(thread, senderPid, senderAuthor, senderKey, sesKey, NoteStatus.OFFLINE, Kind.OUT, noteType, mimeType, date);
        note.setCid(cid);
        return note;
    }

    @NonNull
    private Thread createThread(@NonNull ThreadStatus threadStatus, @NonNull Kind kind, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull Date date, long thread) {
        return Thread.createThread(threadStatus, senderPid, senderAlias, senderKey, sesKey, kind, date, thread);
    }

    @Nullable
    public Server getServerByIdx(long idx) {
        return this.getThreadsDatabase().serverDao().getServerByIdx(idx);
    }

    public void storeServer(@NonNull Server server) {
        this.getThreadsDatabase().serverDao().insertServer(server);
    }

    @NonNull
    public List<Server> getServers() {
        return this.getThreadsDatabase().serverDao().getServers();
    }

    @NonNull
    public Server createServer(@NonNull String protocol, @NonNull String host, int port, @NonNull String alias) {
        Preconditions.checkNotNull((Object)protocol);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)alias);
        return Server.createServer(protocol, host, port, alias);
    }

    @NonNull
    public List<Note> getNotesByCID(@NonNull CID cid) {
        Preconditions.checkNotNull((Object)cid);
        return this.getThreadsDatabase().noteDao().getNotesByCid(cid);
    }

    @NonNull
    public List<PID> getUsersPIDs() {
        ArrayList<PID> result = new ArrayList<PID>();
        List<String> pids = this.getThreadsDatabase().userDao().getUserPids();
        for (String pid : pids) {
            result.add(PID.create((String)pid));
        }
        return result;
    }

    @NonNull
    public List<Thread> getThreadsByCIDAndThread(@NonNull CID cid, long thread) {
        Preconditions.checkNotNull((Object)cid);
        return this.getThreadsDatabase().threadDao().getThreadsByCidAndThread(cid, thread);
    }

    @NonNull
    public List<Thread> getThreadsByCID(@NonNull CID cid) {
        Preconditions.checkNotNull((Object)cid);
        return this.getThreadsDatabase().threadDao().getThreadsByCid(cid);
    }

    public boolean insertServer(@NonNull IOTA iota, @NonNull Server server, @NonNull String address) {
        Preconditions.checkNotNull((Object)iota);
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)address);
        try {
            Content content = ServerEncoder.convert(server);
            Entity entity = iota.insertTransaction(address, this.gson.toJson((Object)content));
            Preconditions.checkNotNull((Object)entity);
            String hash = entity.getHash();
            Hash transactionHash = this.createHash(hash);
            this.insertHash(transactionHash);
            this.setHash(server, hash);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void removePeerInfo(@NonNull PeerInfo peer) {
        Preconditions.checkNotNull((Object)peer);
        this.getPeersInfoDatabase().peersInfoDao().deletePeerInfo(peer);
    }

    public void removePeer(@NonNull Peer peer) {
        Preconditions.checkNotNull((Object)peer);
        this.getPeersDatabase().peersDao().deletePeer(peer);
    }
}

