/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.MultiAddresses;
import threads.core.api.PeerInfo;
import threads.ipfs.api.Encryption;

public class PeerInfoEncoder {
    @NonNull
    public static String convert(@NonNull PeerInfo peer, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)peer);
        Preconditions.checkNotNull((Object)aesKey);
        Content content = new Content();
        Gson gson = new Gson();
        try {
            String multiAddresses;
            String addresses = Addresses.toString(peer.getAddresses());
            if (addresses != null && !addresses.isEmpty()) {
                content.put("peers", Encryption.encrypt((String)addresses, (String)aesKey));
            }
            if ((multiAddresses = MultiAddresses.toString(peer.getMultiAddresses())) != null && !multiAddresses.isEmpty()) {
                content.put("mads", Encryption.encrypt((String)multiAddresses, (String)aesKey));
            }
            HashMap<String, String> additions = peer.getExternalAdditions();
            Preconditions.checkNotNull(additions);
            content.put("adds", Encryption.encrypt((String)Additionals.toString(additions), (String)aesKey));
            return gson.toJson((Object)content);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

