/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import threads.core.GatewayService;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Addresses;
import threads.core.api.MultiAddresses;
import threads.core.api.Peer;
import threads.core.api.PeerInfo;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class IdentityService {
    private static final String TAG = IdentityService.class.getSimpleName();
    private static final String PROTOCOL = "/ipfs/";

    public static void identity(@NonNull Context context, @NonNull String aesKey, boolean addIdentity, int timeout, int numPeers, boolean protectRelays, boolean cleanStoredPeers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((numPeers >= 0 ? 1 : 0) != 0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            try {
                IdentityService.publishIdentity(context, aesKey, addIdentity, timeout, numPeers, protectRelays, cleanStoredPeers);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    public static boolean publishIdentity(@NonNull Context context, @NonNull String aesKey, boolean addIdentity, int timeout, int numPeers, boolean protectPeers, boolean cleanStoredPeers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((numPeers >= 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return false;
        }
        THREADS threads = Singleton.getInstance(context).getThreads();
        try {
            PID host = Preferences.getPID(context);
            if (host != null) {
                PeerInfo peer;
                IPFS ipfs;
                threads.ipfs.api.PeerInfo info = null;
                if (addIdentity && (ipfs = Singleton.getInstance(context).getIpfs()) != null) {
                    info = ipfs.id();
                }
                if ((peer = threads.getPeerInfoByPID(host)) != null) {
                    return IdentityService.updatePeerInfo(context, peer, info, aesKey, timeout, numPeers, protectPeers, cleanStoredPeers);
                }
                return IdentityService.createPeerInfo(context, info, host, aesKey, timeout, numPeers, protectPeers, cleanStoredPeers);
            }
        }
        catch (Throwable e) {
            Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
        }
        return false;
    }

    private static List<String> getMultiAddresses(@NonNull threads.ipfs.api.PeerInfo info) {
        Preconditions.checkNotNull((Object)info);
        ArrayList<String> addresses = new ArrayList<String>();
        for (String address : info.getMultiAddresses()) {
            String ending;
            if (address.startsWith("/ip6/::1/") || address.startsWith("/ip4/127.0.0.1/") || !address.endsWith(ending = PROTOCOL + info.getPID().getPid())) continue;
            String smallAddress = address.substring(0, address.length() - ending.length());
            addresses.add(smallAddress);
        }
        return addresses;
    }

    private static boolean createPeerInfo(@NonNull Context context, @Nullable threads.ipfs.api.PeerInfo info, @NonNull PID user, @NonNull String aesKey, int timeout, int numPeers, boolean protectRelays, boolean cleanStoredPeers) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        PeerInfo peerInfo = threads.createPeerInfo(user);
        GatewayService.connectStoredRelays(context, numPeers, timeout, cleanStoredPeers);
        List<Peer> relayPeers = GatewayService.getPeers(context, numPeers, timeout, protectRelays);
        for (Peer relay : relayPeers) {
            peerInfo.addAddress(relay.getPid(), relay.getMultiAddress());
        }
        String alias = threads.getUserAlias(user);
        peerInfo.addAdditional("alias", alias, false);
        if (info != null) {
            List<String> multiAddresses = IdentityService.getMultiAddresses(info);
            for (String address : multiAddresses) {
                peerInfo.addMultiAddresses(address);
            }
        }
        threads.storePeerInfo(peerInfo);
        return IdentityService.insertPeer(context, peerInfo, aesKey);
    }

    private static boolean insertPeer(@NonNull Context context, @NonNull PeerInfo peer, @NonNull String aesKey) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        Preconditions.checkNotNull((Object)iota);
        threads.setHash(peer, null);
        long start = System.currentTimeMillis();
        boolean success = threads.insertPeerInfo(iota, peer, aesKey);
        long time = (System.currentTimeMillis() - start) / 1000L;
        if (success) {
            Singleton.getInstance(context).getConsoleListener().info("Success store peer : " + time + " [s]");
        } else {
            Singleton.getInstance(context).getConsoleListener().error("Failed store peer : " + time + " [s]");
        }
        return success;
    }

    public static PeerInfo getPeerInfo(@NonNull Context context, @NonNull PID user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        return threads.getPeer(iota, user, aesKey);
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PID peer, @NonNull String aesKey, boolean supportDiscovery, boolean protectRelay, boolean protectPeer) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)peer);
        int timeout = Preferences.getConnectionTimeout(context);
        return IdentityService.connectPeer(context, peer, aesKey, timeout, supportDiscovery, protectRelay, protectPeer);
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PID user, @NonNull String aesKey, int timeout, boolean supportDiscovery, boolean protectRelay, boolean protectPeer) {
        PeerInfo peer;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)user);
        if (!Network.isConnected(context)) {
            return false;
        }
        if (supportDiscovery && (peer = IdentityService.getPeerInfo(context, user, aesKey)) != null && IdentityService.connectPeer(context, peer, timeout, protectRelay, protectPeer)) {
            return true;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            boolean connected = ipfs.swarmConnect(user, timeout);
            if (connected && protectPeer) {
                ipfs.protectPeer(user, GatewayService.TAG);
            }
            return ipfs.isConnected(user);
        }
        return false;
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PeerInfo peer, int timeout, boolean protectRelay, boolean protectPeer) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        Singleton.ConsoleListener consoleListener = Singleton.getInstance(context).getConsoleListener();
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            boolean connect;
            Addresses addresses = peer.getAddresses();
            for (String relay : addresses.keySet()) {
                try {
                    String ma = (String)addresses.get(relay);
                    Preconditions.checkNotNull((Object)ma);
                    boolean relayConnected = ipfs.isConnected(PID.create((String)relay));
                    if (!relayConnected) {
                        relayConnected = ipfs.swarmConnect(ma + "/" + IPFS.Style.ipfs.name() + "/" + relay, timeout);
                    }
                    if (protectRelay && relayConnected) {
                        GatewayService.storePeer(context, PID.create((String)relay), ma, false, false, 0);
                        ipfs.protectPeer(PID.create((String)relay), GatewayService.TAG);
                    }
                    if (!relayConnected || !(connect = ipfs.swarmConnect(ma = ma.concat("/" + IPFS.Style.ipfs.name() + "/" + relay + "/p2p-circuit/" + IPFS.Style.ipfs.name() + "/" + peer.getPID().getPid()), timeout)) || !protectPeer) continue;
                    ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            MultiAddresses multiAddresses = peer.getMultiAddresses();
            for (String address : multiAddresses) {
                try {
                    String ma = address.concat(PROTOCOL + peer.getPID().getPid());
                    consoleListener.debug("Try connect : " + ma);
                    if (ipfs.isConnected(peer.getPID())) {
                        if (!protectPeer) break;
                        ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                        break;
                    }
                    connect = ipfs.swarmConnect(ma, timeout);
                    if (!connect) continue;
                    if (protectPeer) {
                        ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                    }
                    consoleListener.info("Success connect : " + ma);
                    break;
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return ipfs.isConnected(peer.getPID());
        }
        return false;
    }

    private static boolean updatePeerInfo(@NonNull Context context, @NonNull PeerInfo peer, @Nullable threads.ipfs.api.PeerInfo info, @NonNull String aesKey, int timeout, int numPeers, boolean protectPeers, boolean cleanStoredPeers) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        peer.removeAddresses();
        GatewayService.connectStoredRelays(context, numPeers, timeout, cleanStoredPeers);
        List<Peer> peers = GatewayService.getPeers(context, numPeers, timeout, protectPeers);
        for (Peer relay : peers) {
            peer.addAddress(relay.getPid(), relay.getMultiAddress());
        }
        peer.removeMultiAddresses();
        if (info != null) {
            List<String> multiAddresses = IdentityService.getMultiAddresses(info);
            for (String address : multiAddresses) {
                peer.addMultiAddresses(address);
            }
        }
        threads.updatePeerInfo(peer);
        return IdentityService.insertPeer(context, peer, aesKey);
    }
}

