/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import threads.core.GatewayService;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Addresses;
import threads.core.api.MultiAddresses;
import threads.core.api.Peer;
import threads.core.api.PeerInfo;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class IdentityService {
    private static final String TAG = IdentityService.class.getSimpleName();
    private static final String PROTOCOL = "/ipfs/";
    private static final String SUPPORT_PEER_DISCOVERY_KEY = "supportPeerDiscoveryKey";

    public static boolean isSupportPeerDiscovery(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(TAG, 0);
        return sharedPref.getBoolean(SUPPORT_PEER_DISCOVERY_KEY, true);
    }

    public static void setSupportPeerDiscovery(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(TAG, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(SUPPORT_PEER_DISCOVERY_KEY, enable);
        editor.apply();
    }

    public static void identity(@NonNull Context context, @NonNull String aesKey, int numRelays, boolean protectRelays) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((numRelays >= 0 ? 1 : 0) != 0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            try {
                IdentityService.publishIdentity(context, aesKey, numRelays, protectRelays);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    public static boolean publishIdentity(@NonNull Context context, @NonNull String aesKey, int numRelays, boolean protectRelays) {
        block9: {
            Preconditions.checkNotNull((Object)context);
            Preconditions.checkNotNull((Object)aesKey);
            Preconditions.checkArgument((numRelays >= 0 ? 1 : 0) != 0);
            if (!Network.isConnected(context)) {
                return false;
            }
            if (!IdentityService.isSupportPeerDiscovery(context)) {
                return false;
            }
            IPFS ipfs = Singleton.getInstance(context).getIpfs();
            THREADS threads = Singleton.getInstance(context).getThreads();
            if (ipfs != null) {
                try {
                    PID host = Preferences.getPID(context);
                    if (host == null) break block9;
                    threads.ipfs.api.PeerInfo info = ipfs.id();
                    Preconditions.checkNotNull((Object)info);
                    List<String> addresses = IdentityService.getMultiAddresses(info);
                    PeerInfo peer = threads.getPeerInfoByPID(host);
                    if (peer != null) {
                        boolean update;
                        boolean bl = update = !peer.hasHash();
                        if (!update) {
                            MultiAddresses multiAddresses = peer.getMultiAddresses();
                            for (String address : addresses) {
                                if (multiAddresses.contains(address)) continue;
                                update = true;
                                break;
                            }
                        }
                        if (update) {
                            return IdentityService.updatePeer(context, peer, aesKey, addresses, numRelays, protectRelays);
                        }
                        break block9;
                    }
                    return IdentityService.createPeer(context, host, aesKey, addresses, numRelays, protectRelays);
                }
                catch (Throwable e) {
                    Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
                }
            }
        }
        return false;
    }

    private static List<String> getMultiAddresses(@NonNull threads.ipfs.api.PeerInfo info) {
        Preconditions.checkNotNull((Object)info);
        ArrayList<String> addresses = new ArrayList<String>();
        for (String address : info.getMultiAddresses()) {
            String ending;
            if (address.startsWith("/ip6/::1/") || address.startsWith("/ip4/127.0.0.1/") || !address.endsWith(ending = PROTOCOL + info.getPID().getPid())) continue;
            String smallAddress = address.substring(0, address.length() - ending.length());
            addresses.add(smallAddress);
        }
        return addresses;
    }

    private static boolean createPeer(@NonNull Context context, @NonNull PID user, @NonNull String aesKey, @NonNull List<String> addresses, int numRelays, boolean protectRelays) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        PeerInfo peer = threads.createPeerInfo(user);
        int timeout = Preferences.getMaxThreshold(context);
        List<Peer> relayPeers = GatewayService.getRelayPeers(context, numRelays, timeout, protectRelays);
        for (Peer relay : relayPeers) {
            peer.addAddress(relay.getPid(), relay.getMultiAddress());
        }
        String alias = threads.getUserAlias(user);
        peer.addAdditional("alias", alias, false);
        for (String address : addresses) {
            peer.addMultiAddresses(address);
        }
        threads.storePeerInfo(peer);
        return IdentityService.insertPeer(context, peer, aesKey);
    }

    public static PeerInfo getPeer(@NonNull Context context, @NonNull PID user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        if (IdentityService.isSupportPeerDiscovery(context)) {
            return threads.getPeer(iota, user, aesKey);
        }
        return null;
    }

    private static boolean insertPeer(@NonNull Context context, @NonNull PeerInfo peer, @NonNull String aesKey) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        Preconditions.checkNotNull((Object)iota);
        threads.setHash(peer, null);
        long start = System.currentTimeMillis();
        boolean success = threads.insertPeerInfo(iota, peer, aesKey);
        long time = (System.currentTimeMillis() - start) / 1000L;
        if (success) {
            Singleton.getInstance(context).getConsoleListener().info("Success store peer : " + time + " [s]");
        } else {
            Singleton.getInstance(context).getConsoleListener().error("Failed store peer : " + time + " [s]");
        }
        return success;
    }

    public static PeerInfo getPeerInfo(@NonNull Context context, @NonNull PID user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        if (IdentityService.isSupportPeerDiscovery(context)) {
            return threads.getPeer(iota, user, aesKey);
        }
        return null;
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PID peer, @NonNull String aesKey, boolean protectRelay, boolean protectPeer) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)peer);
        int timeout = Preferences.getConnectionTimeout(context);
        return IdentityService.connectPeer(context, peer, aesKey, timeout, protectRelay, protectPeer);
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PID user, @NonNull String aesKey, int timeout, boolean protectRelay, boolean protectPeer) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)user);
        if (!Network.isConnected(context)) {
            return false;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            PeerInfo peer = IdentityService.getPeer(context, user, aesKey);
            if (peer != null && IdentityService.connectPeer(context, ipfs, peer, protectRelay, protectPeer)) {
                return true;
            }
            boolean connected = ipfs.swarmConnect(user, timeout);
            if (connected && protectPeer) {
                ipfs.protectPeer(user, GatewayService.TAG);
            }
            return ipfs.isConnected(user);
        }
        return false;
    }

    private static boolean connectPeer(@NonNull Context context, @NonNull IPFS ipfs, @NonNull PeerInfo peer, boolean protectRelay, boolean protectPeer) {
        boolean connect;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        int timeout = Preferences.getMaxThreshold(context);
        boolean dialRelay = Preferences.isDialRelay(context);
        Singleton.ConsoleListener consoleListener = Singleton.getInstance(context).getConsoleListener();
        Addresses addresses = peer.getAddresses();
        for (String relay : addresses.keySet()) {
            try {
                String ma = (String)addresses.get(relay);
                Preconditions.checkNotNull((Object)ma);
                boolean relayConnected = ipfs.isConnected(PID.create((String)relay));
                if (!relayConnected) {
                    relayConnected = ipfs.swarmConnect(ma + "/" + IPFS.Style.ipfs.name() + "/" + relay, timeout);
                }
                if (protectRelay && relayConnected) {
                    GatewayService.storePeer(context, PID.create((String)relay), ma, true, true);
                    ipfs.protectPeer(PID.create((String)relay), GatewayService.TAG);
                }
                if (!dialRelay || !relayConnected || !(connect = ipfs.swarmConnect(ma = ma.concat("/" + IPFS.Style.ipfs.name() + "/" + relay + "/p2p-circuit/" + IPFS.Style.ipfs.name() + "/" + peer.getPID().getPid()), timeout)) || !protectPeer) continue;
                ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        MultiAddresses multiAddresses = peer.getMultiAddresses();
        for (String address : multiAddresses) {
            try {
                String ma = address.concat(PROTOCOL + peer.getPID().getPid());
                consoleListener.debug("Try connect : " + ma);
                if (ipfs.isConnected(peer.getPID())) {
                    if (!protectPeer) break;
                    ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                    break;
                }
                connect = ipfs.swarmConnect(ma, timeout);
                if (!connect) continue;
                if (protectPeer) {
                    ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                }
                consoleListener.info("Success connect : " + ma);
                break;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return ipfs.isConnected(peer.getPID());
    }

    private static boolean updatePeer(@NonNull Context context, @NonNull PeerInfo peer, @NonNull String aesKey, @NonNull List<String> multiAddresses, int numRelays, boolean protectRelays) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        peer.removeAddresses();
        int timeout = Preferences.getMaxThreshold(context);
        List<Peer> relayPeers = GatewayService.getRelayPeers(context, numRelays, timeout, protectRelays);
        for (Peer relay : relayPeers) {
            peer.addAddress(relay.getPid(), relay.getMultiAddress());
        }
        peer.removeMultiAddresses();
        for (String address : multiAddresses) {
            peer.addMultiAddresses(address);
        }
        threads.updatePeerInfo(peer);
        return IdentityService.insertPeer(context, peer, aesKey);
    }
}

