/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Converter;
import threads.core.api.Kind;
import threads.core.api.Members;
import threads.core.api.Thread;
import threads.core.api.ThreadDao;
import threads.core.api.ThreadStatus;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

public final class ThreadDao_Impl
implements ThreadDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfThread;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfThread;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfThread;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetThreadStatus;
    private final SharedSQLiteStatement __preparedStmtOfSetSenderAlias;
    private final SharedSQLiteStatement __preparedStmtOfSetSenderAlias_1;
    private final SharedSQLiteStatement __preparedStmtOfSetThreadStatus_1;
    private final SharedSQLiteStatement __preparedStmtOfSetCid;
    private final SharedSQLiteStatement __preparedStmtOfSetMimeType;
    private final SharedSQLiteStatement __preparedStmtOfSetBundle;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;
    private final SharedSQLiteStatement __preparedStmtOfSetImage;
    private final SharedSQLiteStatement __preparedStmtOfSetMarkedFlag;
    private final SharedSQLiteStatement __preparedStmtOfSetUnreadNotesNumber;

    public ThreadDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfThread = new EntityInsertionAdapter<Thread>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Thread`(`thread`,`kind`,`senderPid`,`senderKey`,`sesKey`,`date`,`readOnly`,`senderAlias`,`idx`,`image`,`markedFlag`,`unreadNotes`,`cid`,`expireDate`,`status`,`members`,`mimeType`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,?,?,?,?,nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Thread value) {
                stmt.bindLong(1, value.getThread());
                Integer _tmp = Kind.toInteger(value.getKind());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)_tmp.intValue());
                }
                String _tmp_1 = Converter.toString(value.getSenderPid());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getSenderKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSenderKey());
                }
                if (value.getSesKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSesKey());
                }
                Long _tmp_2 = Converter.toLong(value.getDate());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_2.longValue());
                }
                int _tmp_3 = value.isReadOnly() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_3);
                if (value.getSenderAlias() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSenderAlias());
                }
                stmt.bindLong(9, value.getIdx());
                String _tmp_4 = Converter.toString(value.getImage());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                int _tmp_5 = value.getMarkedFlag() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_5);
                stmt.bindLong(12, (long)value.getUnreadNotes());
                String _tmp_6 = Converter.toString(value.getCid());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_6);
                }
                Long _tmp_7 = Converter.toLong(value.getExpireDate());
                if (_tmp_7 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, _tmp_7.longValue());
                }
                Integer _tmp_8 = ThreadStatus.toInteger(value.getStatus());
                if (_tmp_8 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)_tmp_8.intValue());
                }
                String _tmp_9 = Members.toString(value.getMembers());
                if (_tmp_9 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_9);
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getMimeType());
                }
                String _tmp_10 = Additionals.toString(value.getAdditionals());
                if (_tmp_10 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_10);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getBundle());
                }
                stmt.bindLong(21, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfThread = new EntityDeletionOrUpdateAdapter<Thread>(__db){

            public String createQuery() {
                return "DELETE FROM `Thread` WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Thread value) {
                stmt.bindLong(1, value.getIdx());
            }
        };
        this.__updateAdapterOfThread = new EntityDeletionOrUpdateAdapter<Thread>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Thread` SET `thread` = ?,`kind` = ?,`senderPid` = ?,`senderKey` = ?,`sesKey` = ?,`date` = ?,`readOnly` = ?,`senderAlias` = ?,`idx` = ?,`image` = ?,`markedFlag` = ?,`unreadNotes` = ?,`cid` = ?,`expireDate` = ?,`status` = ?,`members` = ?,`mimeType` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Thread value) {
                stmt.bindLong(1, value.getThread());
                Integer _tmp = Kind.toInteger(value.getKind());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)_tmp.intValue());
                }
                String _tmp_1 = Converter.toString(value.getSenderPid());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getSenderKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSenderKey());
                }
                if (value.getSesKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSesKey());
                }
                Long _tmp_2 = Converter.toLong(value.getDate());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_2.longValue());
                }
                int _tmp_3 = value.isReadOnly() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_3);
                if (value.getSenderAlias() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSenderAlias());
                }
                stmt.bindLong(9, value.getIdx());
                String _tmp_4 = Converter.toString(value.getImage());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                int _tmp_5 = value.getMarkedFlag() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_5);
                stmt.bindLong(12, (long)value.getUnreadNotes());
                String _tmp_6 = Converter.toString(value.getCid());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_6);
                }
                Long _tmp_7 = Converter.toLong(value.getExpireDate());
                if (_tmp_7 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, _tmp_7.longValue());
                }
                Integer _tmp_8 = ThreadStatus.toInteger(value.getStatus());
                if (_tmp_8 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)_tmp_8.intValue());
                }
                String _tmp_9 = Members.toString(value.getMembers());
                if (_tmp_9 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_9);
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getMimeType());
                }
                String _tmp_10 = Additionals.toString(value.getAdditionals());
                if (_tmp_10 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_10);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getBundle());
                }
                stmt.bindLong(21, value.getTimestamp());
                stmt.bindLong(22, value.getIdx());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Thread";
                return "DELETE FROM Thread";
            }
        };
        this.__preparedStmtOfSetThreadStatus = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET status = ?  WHERE idx = ?";
                return "UPDATE Thread SET status = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetSenderAlias = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET senderAlias = ?  WHERE idx = ?";
                return "UPDATE Thread SET senderAlias = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetSenderAlias_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET senderAlias = ?  WHERE senderPid = ?";
                return "UPDATE Thread SET senderAlias = ?  WHERE senderPid = ?";
            }
        };
        this.__preparedStmtOfSetThreadStatus_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET status = ?  WHERE status = ?";
                return "UPDATE Thread SET status = ?  WHERE status = ?";
            }
        };
        this.__preparedStmtOfSetCid = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET cid =?  WHERE idx = ?";
                return "UPDATE Thread SET cid =?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetMimeType = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET mimeType =?  WHERE idx = ?";
                return "UPDATE Thread SET mimeType =?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetBundle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET bundle = ? WHERE idx = ?";
                return "UPDATE Thread SET bundle = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET hash = ? WHERE idx = ?";
                return "UPDATE Thread SET hash = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetImage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET image = ? WHERE idx = ?";
                return "UPDATE Thread SET image = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetMarkedFlag = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET markedFlag = ? WHERE idx = ?";
                return "UPDATE Thread SET markedFlag = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetUnreadNotesNumber = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET unreadNotes = ?  WHERE idx = ?";
                return "UPDATE Thread SET unreadNotes = ?  WHERE idx = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertThread(Thread thread) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfThread.insertAndReturnId((Object)thread);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertThreads(Thread ... threads) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfThread.insert((Object[])threads);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void removeThreads(Thread ... threads) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfThread.handleMultiple((Object[])threads);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateThreads(Thread ... threads) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfThread.handleMultiple((Object[])threads);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadStatus(long idx, ThreadStatus status) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetThreadStatus.acquire();
        int _argIndex = 1;
        Integer _tmp = ThreadStatus.toInteger(status);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetThreadStatus.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSenderAlias(long idx, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetSenderAlias.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetSenderAlias.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSenderAlias(PID pid, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetSenderAlias_1.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        String _tmp = Converter.toString(pid);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetSenderAlias_1.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadStatus(ThreadStatus oldStatus, ThreadStatus newStatus) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetThreadStatus_1.acquire();
        int _argIndex = 1;
        Integer _tmp = ThreadStatus.toInteger(newStatus);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer _tmp_1 = ThreadStatus.toInteger(oldStatus);
        if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetThreadStatus_1.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCid(long idx, CID cid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetCid.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetCid.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMimeType(long idx, String mimeType) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetMimeType.acquire();
        int _argIndex = 1;
        if (mimeType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, mimeType);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetMimeType.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(long idx, String bundle) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetBundle.acquire();
        int _argIndex = 1;
        if (bundle == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, bundle);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetBundle.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(long idx, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImage(long idx, CID image) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetImage.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(image);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetImage.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMarkedFlag(long idx, boolean flag) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetMarkedFlag.acquire();
        int _argIndex = 1;
        int _tmp = flag ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetMarkedFlag.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnreadNotesNumber(long idx, int unreadNotes) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetUnreadNotesNumber.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)unreadNotes);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetUnreadNotesNumber.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreads() {
        String _sql = "SELECT * FROM Thread";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_2 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_2);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_3);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_4 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_5 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_5);
                _item.setImage(_tmpImage);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_6 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item.setCid(_tmpCid);
                Long _tmp_8 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_8);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_9 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_9);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_10 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_10);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Thread>> getLiveDataThreads() {
        String _sql = "SELECT * FROM Thread";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Thread"}, false, (Callable)new Callable<List<Thread>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Thread> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ThreadDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
                    int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
                    int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
                    int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
                    int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
                    int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
                    int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                        Kind _tmpKind = Kind.toKind(_tmp);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                        PID _tmpSenderPid = Converter.toPID(_tmp_1);
                        String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                        String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                        Date _tmpDate = Converter.toDate(_tmp_2);
                        String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                        Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_3);
                        Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfReadOnly);
                        boolean _tmpReadOnly = _tmp_4 != 0;
                        _item.setReadOnly(_tmpReadOnly);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_5);
                        _item.setImage(_tmpImage);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                        boolean _tmpMarkedFlag = _tmp_6 != 0;
                        _item.setMarkedFlag(_tmpMarkedFlag);
                        int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                        _item.setUnreadNotes(_tmpUnreadNotes);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                        CID _tmpCid = Converter.toCID(_tmp_7);
                        _item.setCid(_tmpCid);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                        Date _tmpExpireDate = Converter.toDate(_tmp_8);
                        _item.setExpireDate(_tmpExpireDate);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfMembers);
                        Members _tmpMembers = Members.toMembers(_tmp_9);
                        _item.setMembers(_tmpMembers);
                        String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                        _item.setMimeType(_tmpMimeType);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_10);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _item.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Thread> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByDate(Date date) {
        String _sql = "SELECT * FROM Thread WHERE date =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE date =?", (int)1);
        int _argIndex = 1;
        Long _tmp = Converter.toLong(date);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_3 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_3);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_4);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_5 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_6 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_6);
                _item.setImage(_tmpImage);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_7 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_8);
                _item.setCid(_tmpCid);
                Long _tmp_9 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_9);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_10 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_10);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_11 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_11);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getExpiredThreads(Date date) {
        String _sql = "SELECT * FROM Thread WHERE expireDate < ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE expireDate < ?", (int)1);
        int _argIndex = 1;
        Long _tmp = Converter.toLong(date);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_3 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_3);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_4);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_5 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_6 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_6);
                _item.setImage(_tmpImage);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_7 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_8);
                _item.setCid(_tmpCid);
                Long _tmp_9 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_9);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_10 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_10);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_11 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_11);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByKindAndThreadStatus(Kind kind, ThreadStatus status) {
        String _sql = "SELECT * FROM Thread WHERE kind LIKE ? AND status = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE kind LIKE ? AND status = ?", (int)2);
        int _argIndex = 1;
        Integer _tmp = Kind.toInteger(kind);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer _tmp_1 = ThreadStatus.toInteger(status);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_3);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_4 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_4);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_5);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_6 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_7 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_7);
                _item.setImage(_tmpImage);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_8 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_9 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_9);
                _item.setCid(_tmpCid);
                Long _tmp_10 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_10);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_11 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_11);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMimeType(long idx) {
        String _sql = "SELECT mimeType FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT mimeType FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByThreadStatus(ThreadStatus status) {
        String _sql = "SELECT * FROM Thread WHERE status = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE status = ?", (int)1);
        int _argIndex = 1;
        Integer _tmp = ThreadStatus.toInteger(status);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_3 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_3);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_4);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_5 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_6 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_6);
                _item.setImage(_tmpImage);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_7 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_8);
                _item.setCid(_tmpCid);
                Long _tmp_9 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_9);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_10 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_10);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_11 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_11);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByCid(CID cid) {
        String _sql = "SELECT * FROM Thread WHERE cid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE cid = ?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_3 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_3);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_4);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_5 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_6 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_6);
                _item.setImage(_tmpImage);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_7 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_8);
                _item.setCid(_tmpCid);
                Long _tmp_9 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_9);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_10 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_10);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_11 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_11);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnreadNotes() {
        String _sql = "Select SUM(unreadNotes) FROM THREAD";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select SUM(unreadNotes) FROM THREAD", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByThread(long thread) {
        String _sql = "SELECT * FROM Thread WHERE thread =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE thread =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, thread);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_2 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_2);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_3);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_4 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_5 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_5);
                _item.setImage(_tmpImage);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_6 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item.setCid(_tmpCid);
                Long _tmp_8 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_8);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_9 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_9);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_10 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_10);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread getThreadByIdx(long idx) {
        String _sql = "SELECT * FROM Thread WHERE idx =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE idx =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Thread _result;
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_2 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_2);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_3);
                _result = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_4 != 0;
                _result.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _result.setIdx(_tmpIdx);
                String _tmp_5 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_5);
                _result.setImage(_tmpImage);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_6 != 0;
                _result.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _result.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _result.setCid(_tmpCid);
                Long _tmp_8 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_8);
                _result.setExpireDate(_tmpExpireDate);
                String _tmp_9 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_9);
                _result.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _result.setMimeType(_tmpMimeType);
                String _tmp_10 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_10);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Thread thread = _result;
            return thread;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadByIdxs(long ... idxs) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM Thread WHERE idx IN(");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : idxs) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_2 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_2);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_3);
                Thread _item_1 = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_4 != 0;
                _item_1.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item_1.setIdx(_tmpIdx);
                String _tmp_5 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_5);
                _item_1.setImage(_tmpImage);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_6 != 0;
                _item_1.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item_1.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item_1.setCid(_tmpCid);
                Long _tmp_8 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_8);
                _item_1.setExpireDate(_tmpExpireDate);
                String _tmp_9 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_9);
                _item_1.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item_1.setMimeType(_tmpMimeType);
                String _tmp_10 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_10);
                _item_1.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item_1.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item_1.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item_1.setTimestamp(_tmpTimestamp);
                _result.add(_item_1);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsBySenderPid(PID senderPid) {
        String _sql = "SELECT * FROM Thread WHERE senderPid =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE senderPid =?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(senderPid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
            int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Long _tmp_3 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_3);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_4);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfReadOnly);
                boolean _tmpReadOnly = _tmp_5 != 0;
                _item.setReadOnly(_tmpReadOnly);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_6 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_6);
                _item.setImage(_tmpImage);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                boolean _tmpMarkedFlag = _tmp_7 != 0;
                _item.setMarkedFlag(_tmpMarkedFlag);
                int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                _item.setUnreadNotes(_tmpUnreadNotes);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_8);
                _item.setCid(_tmpCid);
                Long _tmp_9 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                Date _tmpExpireDate = Converter.toDate(_tmp_9);
                _item.setExpireDate(_tmpExpireDate);
                String _tmp_10 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_10);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmp_11 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_11);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Thread>> getLiveDataThreadsByThread(long thread) {
        String _sql = "SELECT * FROM Thread WHERE thread =?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE thread =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, thread);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Thread"}, false, (Callable)new Callable<List<Thread>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Thread> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ThreadDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
                    int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
                    int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
                    int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
                    int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfReadOnly = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readOnly");
                    int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfMarkedFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedFlag");
                    int _cursorIndexOfUnreadNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadNotes");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfExpireDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expireDate");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                        Kind _tmpKind = Kind.toKind(_tmp);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                        PID _tmpSenderPid = Converter.toPID(_tmp_1);
                        String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                        String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                        Date _tmpDate = Converter.toDate(_tmp_2);
                        String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                        Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        ThreadStatus _tmpStatus = ThreadStatus.toThreadStatus(_tmp_3);
                        Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfReadOnly);
                        boolean _tmpReadOnly = _tmp_4 != 0;
                        _item.setReadOnly(_tmpReadOnly);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_5);
                        _item.setImage(_tmpImage);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfMarkedFlag);
                        boolean _tmpMarkedFlag = _tmp_6 != 0;
                        _item.setMarkedFlag(_tmpMarkedFlag);
                        int _tmpUnreadNotes = _cursor.getInt(_cursorIndexOfUnreadNotes);
                        _item.setUnreadNotes(_tmpUnreadNotes);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                        CID _tmpCid = Converter.toCID(_tmp_7);
                        _item.setCid(_tmpCid);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfExpireDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpireDate));
                        Date _tmpExpireDate = Converter.toDate(_tmp_8);
                        _item.setExpireDate(_tmpExpireDate);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfMembers);
                        Members _tmpMembers = Members.toMembers(_tmp_9);
                        _item.setMembers(_tmpMembers);
                        String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                        _item.setMimeType(_tmpMimeType);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_10);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _item.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Thread> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadStatus getThreadStatus(long idx) {
        String _sql = "SELECT status FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT status FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ThreadStatus _result;
            if (_cursor.moveToFirst()) {
                Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                _result = ThreadStatus.toThreadStatus(_tmp);
            } else {
                _result = null;
            }
            ThreadStatus threadStatus = _result;
            return threadStatus;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMarkedFlag(long idx) {
        String _sql = "SELECT markedFlag FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT markedFlag FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadsStatus(ThreadStatus status, long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET status = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  WHERE idx IN (");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        Integer _tmp = ThreadStatus.toInteger(status);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetUnreadNotes(long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET unreadNotes = 0 WHERE idx IN (");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetThreadUnreadNotes(long ... threads) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET unreadNotes = 0 WHERE thread IN (");
        int _inputSize = threads.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (long _item : threads) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementUnreadNotesNumber(long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET unreadNotes = unreadNotes + 1  WHERE idx IN(");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

